/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.egov.calendar.service.impl;

import com.gtis.egov.calendar.dao.CalendarDAO;
import com.gtis.egov.calendar.dao.EventDAO;
import com.gtis.egov.calendar.model.Calendar;
import com.gtis.egov.calendar.model.Event;
import com.gtis.egov.calendar.service.CalendarExchangeManager;
import com.gtis.egov.calendar.utils.DateUtils;
import com.gtis.egov.calendar.utils.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.List;
import net.fortuna.ical4j.data.CalendarBuilder;
import net.fortuna.ical4j.data.CalendarOutputter;
import net.fortuna.ical4j.data.ParserException;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.Recur;
import net.fortuna.ical4j.model.TimeZoneRegistryFactory;
import net.fortuna.ical4j.model.ValidationException;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.component.VTimeZone;
import net.fortuna.ical4j.model.parameter.Value;
import net.fortuna.ical4j.model.property.CalScale;
import net.fortuna.ical4j.model.property.Description;
import net.fortuna.ical4j.model.property.DtEnd;
import net.fortuna.ical4j.model.property.DtStart;
import net.fortuna.ical4j.model.property.Location;
import net.fortuna.ical4j.model.property.ProdId;
import net.fortuna.ical4j.model.property.RRule;
import net.fortuna.ical4j.model.property.Summary;
import net.fortuna.ical4j.model.property.Url;
import net.fortuna.ical4j.model.property.Version;
import net.fortuna.ical4j.model.property.XProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalendarExchangeManagerImpl
implements CalendarExchangeManager {
    private static final Logger logger = LoggerFactory.getLogger(CalendarExchangeManagerImpl.class);
    private CalendarDAO calendarDAO;
    private EventDAO eventDAO;

    public void setCalendarDAO(CalendarDAO calendarDAO) {
        this.calendarDAO = calendarDAO;
    }

    public void setEventDAO(EventDAO eventDAO) {
        this.eventDAO = eventDAO;
    }

    public int importIcsCalendarEvents(InputStream inputStream, Long calendarId) throws IOException {
        net.fortuna.ical4j.model.Calendar calendar;
        CalendarBuilder builder = new CalendarBuilder();
        int count = 0;
        try {
            calendar = builder.build(inputStream);
        }
        catch (ParserException e) {
            logger.error("Parser input file error");
            return count;
        }
        Calendar cal = this.calendarDAO.getCalendar(calendarId);
        for (Component component : calendar.getComponents()) {
            if (component instanceof VTimeZone || !(component instanceof VEvent)) continue;
            Summary summary = (Summary)component.getProperty("SUMMARY");
            Url url = (Url)component.getProperty("URL");
            Location location = (Location)component.getProperty("LOCATION");
            Description description = (Description)component.getProperty("DESCRIPTION");
            DtStart start = (DtStart)component.getProperty("DTSTART");
            DtEnd end = (DtEnd)component.getProperty("DTEND");
            RRule rRule = (RRule)component.getProperty("RRULE");
            if (summary == null || start == null) continue;
            Event event = new Event();
            event.setCalendarId(cal.getId());
            event.setTitle(summary.getValue());
            if (url != null) {
                event.setUrl(url.getValue());
            }
            if (location != null) {
                event.setLocation(location.getValue());
            }
            if (description != null) {
                event.setDescription(description.getValue());
            }
            Date sd = start.getDate();
            event.setStartTime((java.util.Date)sd);
            if (end != null) {
                Date ed = end.getDate();
                if (DateUtils.getStartOfDay((java.util.Date)sd).equals(sd) && DateUtils.addDays((java.util.Date)sd, (int)1).equals(ed)) {
                    event.setWholeDay(true);
                } else {
                    event.setEndTime((java.util.Date)ed);
                }
            }
            event.setCreator(cal.getCreator());
            event.setUpdateTime(new java.util.Date());
            if (rRule != null) {
                Recur recur = rRule.getRecur();
                if (recur.getInterval() < 1) {
                    recur.setInterval(1);
                }
                event.setRecurrenceRule(recur.toString());
                event.setRepeatEndTime((java.util.Date)rRule.getRecur().getUntil());
            }
            this.eventDAO.saveEvent(event);
            ++count;
        }
        return count;
    }

    public int exportIcsCalendarEvents(OutputStream outputStream, Long calendarId) throws IOException {
        Calendar cal = this.calendarDAO.getCalendar(calendarId);
        List events = this.eventDAO.getEvents(calendarId);
        net.fortuna.ical4j.model.Calendar calendar = new net.fortuna.ical4j.model.Calendar();
        PropertyList ps = calendar.getProperties();
        ComponentList cs = calendar.getComponents();
        ps.add((Property)new ProdId("-//WisEdu Inc//Ccs Calendar 1.0//EN"));
        ps.add((Property)Version.VERSION_2_0);
        ps.add((Property)CalScale.GREGORIAN);
        ps.add((Property)new XProperty("X-WR-CALNAME", cal.getName()));
        ps.add((Property)new XProperty("X-WR-CALDESC", cal.getDescription()));
        ps.add((Property)new XProperty("X-WR-CALCOLOR", cal.getColor()));
        VTimeZone tz = TimeZoneRegistryFactory.getInstance().createRegistry().getTimeZone("Asia/Shanghai").getVTimeZone();
        cs.add((Component)tz);
        int count = 0;
        for (int i = 0; i < events.size(); ++i) {
            Event event = (Event)events.get(i);
            VEvent vEvent = new VEvent();
            PropertyList eps = vEvent.getProperties();
            Summary summary = new Summary(event.getTitle());
            eps.add((Property)summary);
            if (StringUtils.isNotBlank((String)event.getUrl())) {
                try {
                    Url url = new Url(new URI(event.getUrl()));
                    eps.add((Property)url);
                }
                catch (URISyntaxException e) {
                    // empty catch block
                }
            }
            if (StringUtils.isNotBlank((String)event.getLocation())) {
                Location location = new Location(event.getLocation());
                eps.add((Property)location);
            }
            if (StringUtils.isNotBlank((String)event.getDescription())) {
                Description description = new Description(event.getDescription());
                eps.add((Property)description);
            }
            DtStart start = new DtStart();
            DtEnd end = new DtEnd();
            if (event.isWholeDay()) {
                start.getParameters().add((Parameter)Value.DATE);
                end.getParameters().add((Parameter)Value.DATE);
                start.setDate(new Date(event.getStartTime()));
                end.setDate(new Date(event.getEndTime()));
            } else {
                start.setDate((Date)new DateTime(event.getStartTime()));
                end.setDate((Date)new DateTime(event.getEndTime()));
            }
            eps.add((Property)start);
            eps.add((Property)end);
            if (StringUtils.isNotBlank((String)event.getRecurrenceRule())) {
                try {
                    Recur recur = new Recur(event.getRecurrenceRule());
                    if (event.getRepeatEndTime() != null) {
                        recur.setUntil((Date)new DateTime(event.getRepeatEndTime()));
                    }
                    RRule rRule = new RRule(recur);
                    eps.add((Property)rRule);
                }
                catch (ParseException e) {
                    // empty catch block
                }
            }
            cs.add((Component)vEvent);
            ++count;
        }
        CalendarOutputter outputter = new CalendarOutputter(false, 73);
        outputter.setValidating(false);
        try {
            outputter.output(calendar, outputStream);
        }
        catch (ValidationException e) {
            // empty catch block
        }
        return count;
    }
}

