/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.egov.calendar.model;

import com.gtis.egov.calendar.model.Event;
import com.gtis.egov.calendar.model.PersonalCalendar;
import com.gtis.egov.calendar.model.auto.TCalendarReminder;
import com.gtis.egov.calendar.utils.DateUtils;
import java.util.Date;
import org.apache.commons.lang.builder.ToStringBuilder;

public class Reminder
extends TCalendarReminder
implements Comparable {
    public static final int WEEK_UNIT = 604800;
    public static final int DAY_UNIT = 86400;
    public static final int HOUR_UNIT = 3600;
    public static final int MINUTE_UNIT = 60;
    public static final int MAX_SECONDS = 2419200;
    private Date remindDate;
    private Event event;
    private PersonalCalendar personalCalendar;

    public Event getEvent() {
        return this.event;
    }

    public void setEvent(Event event) {
        this.event = event;
        this.remindDate = DateUtils.addSeconds((Date)event.getStartTime(), (int)(-this.getSeconds()));
    }

    public PersonalCalendar getPersonalCalendar() {
        return this.personalCalendar;
    }

    public void setPersonalCalendar(PersonalCalendar personalCalendar) {
        this.personalCalendar = personalCalendar;
    }

    public void setSeconds(int seconds) {
        super.setSeconds(seconds > 2419200 ? 2419200 : seconds);
    }

    public int getNumber() {
        int seconds = this.getSeconds();
        if (seconds / 604800 > 0) {
            return seconds / 604800;
        }
        if (seconds / 86400 > 0) {
            return seconds / 86400;
        }
        if (seconds / 3600 > 0) {
            return seconds / 3600;
        }
        return seconds / 60;
    }

    public int getUnit() {
        int seconds = this.getSeconds();
        if (seconds / 604800 > 0) {
            return 604800;
        }
        if (seconds / 86400 > 0) {
            return 86400;
        }
        if (seconds / 3600 > 0) {
            return 3600;
        }
        return 60;
    }

    public Date getRemindDate() {
        return this.remindDate;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public int hashCode() {
        return (int)(this.getId() + (this.event == null ? 0L : this.getRemindDate().getTime()) * 31L);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Reminder)) {
            return false;
        }
        Reminder o = (Reminder)obj;
        return o.getId() != null && o.getRemindDate() != null && o.getId().equals(this.getId()) && o.getRemindDate().equals(this.getRemindDate());
    }

    public int compareTo(Object o) {
        return this.remindDate.compareTo(((Reminder)o).getRemindDate());
    }
}

