/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.egov.calendar.dao.jdbc;

import com.gtis.egov.calendar.dao.ReminderDAO;
import com.gtis.egov.calendar.model.Event;
import com.gtis.egov.calendar.model.Reminder;
import com.wiscom.generic.base.jdbc.AbstractJdbcDAO;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class ReminderDAOImpl
extends AbstractJdbcDAO
implements ReminderDAO {
    private static final String T_CALENDAR_REMINDER_SEQ = "T_CALENDAR_REMINDER_SEQ";
    private static Class[] beanClasses = new Class[]{Reminder.class, Event.class};

    public Reminder saveReminder(Reminder reminder) {
        return reminder.getId() == null ? this.addReminder(reminder) : this.updateReminder(reminder);
    }

    private Reminder updateReminder(Reminder reminder) {
        this.updateByBean("update t_calendar_reminder set event_id=:eventId,creator=:creator,method=:method,seconds=:seconds where id=:id", (Object)reminder);
        return reminder;
    }

    private Reminder addReminder(Reminder reminder) {
        reminder.setId(new Long(this.idGenerator.nextLongValue(T_CALENDAR_REMINDER_SEQ)));
        this.updateByBean("insert into t_calendar_reminder (id,event_id,creator,method,seconds) values (:id,:eventId,:creator,:method,:seconds)", (Object)reminder);
        return reminder;
    }

    public Reminder getReminder(Long reminderId) {
        String sql = "select * from t_calendar_reminder where id=:id";
        HashMap<String, Long> params = new HashMap<String, Long>(1);
        params.put("id", reminderId);
        return (Reminder)this.queryForBean("select * from t_calendar_reminder where id=:id", params, Reminder.class);
    }

    public List getReminders(Long eventId) {
        String sql = "select * from t_calendar_reminder where event_id=:eventId";
        HashMap<String, Long> params = new HashMap<String, Long>(1);
        params.put("eventId", eventId);
        return this.queryForBeanList("select * from t_calendar_reminder where event_id=:eventId", -1, -1, params, Reminder.class);
    }

    public List getBaseReminders(Date startDate, Date endDate) {
        String sql = "select * from t_calendar_reminder t1 left join t_calendar_event t2 on t2.id = t1.event_id left join t_calendar t3 on t3.id = t2.calendar_id where t2.start_time - t1.seconds / 86400 > :startDate and (t2.start_time - t1.seconds / 86400 < :endDate or (t2.recurrence_rule is not null and (t2.repeat_end_time is null or t2.repeat_end_time > :startDate)))";
        HashMap<String, Date> params = new HashMap<String, Date>(1);
        params.put("startDate", startDate);
        params.put("endDate", endDate);
        List beansList = this.queryForManyBeanList("select * from t_calendar_reminder t1 left join t_calendar_event t2 on t2.id = t1.event_id left join t_calendar t3 on t3.id = t2.calendar_id where t2.start_time - t1.seconds / 86400 > :startDate and (t2.start_time - t1.seconds / 86400 < :endDate or (t2.recurrence_rule is not null and (t2.repeat_end_time is null or t2.repeat_end_time > :startDate)))", -1, -1, params, beanClasses);
        ArrayList<Reminder> reminds = new ArrayList<Reminder>(beansList.size());
        for (int i = 0; i < beansList.size(); ++i) {
            Object[] objs = (Object[])beansList.get(i);
            Reminder reminder = (Reminder)objs[0];
            Event event = (Event)objs[1];
            reminder.setEvent(event);
            reminds.add(reminder);
        }
        return reminds;
    }

    public void removeReminder(Long reminderId) {
        HashMap<String, Long> params = new HashMap<String, Long>(1);
        params.put("id", reminderId);
        this.update("delete from t_calendar_reminder where id=:id", params);
    }

    public void removeReminders(Long eventId) {
        HashMap<String, Long> params = new HashMap<String, Long>(1);
        params.put("eventId", eventId);
        this.update("delete from t_calendar_reminder where event_id=:eventId", params);
    }

    public void removeRemindersByCalendarId(Long calendarId) {
        HashMap<String, Long> params = new HashMap<String, Long>(1);
        params.put("calendarId", calendarId);
        this.update("delete from t_calendar_reminder where event_id in (select event_id from t_calendar_event where calendar_id=:calendarId)", params);
    }
}

