/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.egov.calendar.dao.jdbc;

import com.gtis.egov.calendar.dao.EventDAO;
import com.gtis.egov.calendar.model.Event;
import com.gtis.egov.calendar.utils.DateUtils;
import com.wiscom.generic.base.jdbc.AbstractJdbcDAO;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class EventDAOImpl
extends AbstractJdbcDAO
implements EventDAO {
    private static final String T_CALENDAR_EVENT_SEQ = "T_CALENDAR_EVENT_SEQ";

    public Event saveEvent(Event event) {
        if (event.isWholeDay()) {
            event.setStartTime(DateUtils.getStartOfDay((Date)event.getStartTime()));
            event.setEndTime(DateUtils.addDays((Date)event.getStartTime(), (int)1));
        }
        return event.getId() == null ? this.addEvent(event) : this.updateEvent(event);
    }

    private Event updateEvent(Event event) {
        this.updateByBean("update t_calendar_event set calendar_id=:calendarId,title=:title,url=:url,location=:location,description=:description,start_time=:startTime,end_time=:endTime,whole_day=:wholeDay,creator=:creator,update_time=:updateTime,recurrence_rule=:recurrenceRule,repeat_end_time=:repeatEndTime where id=:id", (Object)event);
        return event;
    }

    private Event addEvent(Event event) {
        event.setId(new Long(this.idGenerator.nextLongValue(T_CALENDAR_EVENT_SEQ)));
        this.updateByBean("insert into t_calendar_event (id,calendar_id,title,url,location,description,start_time,end_time,whole_day,creator,update_time,recurrence_rule,repeat_end_time) values (:id,:calendarId,:title,:url,:location,:description,:startTime,:endTime,:wholeDay,:creator,:updateTime,:recurrenceRule,:repeatEndTime)", (Object)event);
        return event;
    }

    public Event getEvent(Long eventId) {
        String sql = "select * from t_calendar_event where id=:id";
        HashMap<String, Long> params = new HashMap<String, Long>(1);
        params.put("id", eventId);
        return (Event)this.queryForBean("select * from t_calendar_event where id=:id", params, Event.class);
    }

    public List getEvents(Long calendarId) {
        HashMap<String, Long> params = new HashMap<String, Long>(3);
        String sql = "select * from t_calendar_event where calendar_id=:calendarId order by start_time";
        params.put("calendarId", calendarId);
        return this.queryForBeanList("select * from t_calendar_event where calendar_id=:calendarId order by start_time", -1, -1, params, Event.class);
    }

    public List getBaseEvents(String userId, Long[] calendarIds, Date startDate, Date endDate) {
        if (calendarIds == null || calendarIds.length == 0) {
            return Collections.EMPTY_LIST;
        }
        List<Long> ids = Arrays.asList(calendarIds);
        String sql = "select t1.*,t2.color,(select count(id) from t_calendar_reminder t3 where t3.event_id=t1.id) as remind_count from t_calendar_event t1 inner join t_calendar_config t2 on t2.calendar_id=t1.calendar_id  where t2.creator=:userId and t1.calendar_id in (:calendarIds) and t1.start_time<=:endDate and ((t1.whole_day=1 or t1.end_time>=:startDate) or (t1.recurrence_rule is not null and (t1.repeat_end_time is null or t1.repeat_end_time>=t1.start_time))) order by t1.start_time";
        HashMap<String, Object> params = new HashMap<String, Object>(3);
        params.put("userId", userId);
        params.put("calendarIds", ids);
        params.put("startDate", startDate);
        params.put("endDate", endDate);
        return this.queryForBeanList("select t1.*,t2.color,(select count(id) from t_calendar_reminder t3 where t3.event_id=t1.id) as remind_count from t_calendar_event t1 inner join t_calendar_config t2 on t2.calendar_id=t1.calendar_id  where t2.creator=:userId and t1.calendar_id in (:calendarIds) and t1.start_time<=:endDate and ((t1.whole_day=1 or t1.end_time>=:startDate) or (t1.recurrence_rule is not null and (t1.repeat_end_time is null or t1.repeat_end_time>=t1.start_time))) order by t1.start_time", -1, -1, params, Event.class);
    }

    public List getUserBaseEvents(String userId, Date startDate, Date endDate) {
        String sql = "select t1.*,t2.color,(select count(id) from t_calendar_reminder t3 where t3.event_id=t1.id) as remind_count from t_calendar_event t1 inner join t_calendar_config t2 on t2.calendar_id=t1.calendar_id where t2.creator=:userId and t2.visible=1 and t2.selected=1 and t1.start_time<=:endDate and ((t1.whole_day=1 or t1.end_time>=:startDate) or (t1.recurrence_rule is not null and (t1.repeat_end_time is null or t1.repeat_end_time>=t1.start_time))) order by t1.start_time";
        HashMap<String, Object> params = new HashMap<String, Object>(3);
        params.put("userId", userId);
        params.put("startDate", startDate);
        params.put("endDate", endDate);
        return this.queryForBeanList("select t1.*,t2.color,(select count(id) from t_calendar_reminder t3 where t3.event_id=t1.id) as remind_count from t_calendar_event t1 inner join t_calendar_config t2 on t2.calendar_id=t1.calendar_id where t2.creator=:userId and t2.visible=1 and t2.selected=1 and t1.start_time<=:endDate and ((t1.whole_day=1 or t1.end_time>=:startDate) or (t1.recurrence_rule is not null and (t1.repeat_end_time is null or t1.repeat_end_time>=t1.start_time))) order by t1.start_time", -1, -1, params, Event.class);
    }

    public void removeEvent(Long eventId) {
        HashMap<String, Long> params = new HashMap<String, Long>(1);
        params.put("id", eventId);
        this.update("delete from t_calendar_event where id=:id", params);
    }

    public void removeEvents(Long calendarId) {
        HashMap<String, Long> params = new HashMap<String, Long>(1);
        params.put("calendarId", calendarId);
        this.update("delete from t_calendar_event where calendar_id=:calendarId", params);
    }
}

