/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.egov.calendar.dao.jdbc;

import com.gtis.egov.calendar.dao.CalendarDAO;
import com.gtis.egov.calendar.model.Calendar;
import com.gtis.egov.calendar.model.PersonalCalendar;
import com.wiscom.generic.base.jdbc.AbstractJdbcDAO;
import com.wiscom.generic.base.util.PaginationSupport;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class CalendarDAOImpl
extends AbstractJdbcDAO
implements CalendarDAO {
    private static final String T_CALENDAR_SEQ = "T_CALENDAR_SEQ";
    private static final String T_CALENDAR_CONFIG_SEQ = "T_CALENDAR_CONFIG_SEQ";

    public Calendar saveCalendar(Calendar calendar) {
        return calendar.getId() == null ? this.addCalendar(calendar) : this.updateCalendar(calendar);
    }

    private Calendar updateCalendar(Calendar calendar) {
        this.updateByBean("update t_calendar set name=:name,description=:description,color=:color,owner=:owner,creator=:creator,create_time=:createTime,type=:type where id=:id", (Object)calendar);
        return calendar;
    }

    private Calendar addCalendar(Calendar calendar) {
        calendar.setId(new Long(this.idGenerator.nextLongValue(T_CALENDAR_SEQ)));
        this.updateByBean("insert into t_calendar (id,name,description,color,owner,creator,create_time,type) values (:id,:name,:description,:color,:owner,:creator,:createTime,:type)", (Object)calendar);
        return calendar;
    }

    public Calendar getCalendar(Long calendarId) {
        String sql = "select * from t_calendar where id=:id";
        HashMap<String, Long> params = new HashMap<String, Long>(1);
        params.put("id", calendarId);
        return (Calendar)this.queryForBean("select * from t_calendar where id=:id", params, Calendar.class);
    }

    public PaginationSupport searchCalendars(String term, Short[] types, int start, int num) {
        if (types.length == 0) {
            return null;
        }
        StringBuffer sql = new StringBuffer("select * from t_calendar where type in (:types) ");
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("types", Arrays.asList(types));
        if (StringUtils.isNotBlank((String)term)) {
            params.put("name", "%" + term + "%");
            sql.append("and name like :name ");
        }
        sql.append("order by create_time desc");
        return this.getBeanPaginationSupport(sql.toString(), null, start, num, params, Calendar.class);
    }

    public PaginationSupport searchFriendCalendars(String term, String userId, int start, int num) {
        HashMap<String, String> params = new HashMap<String, String>(2);
        StringBuffer sql = new StringBuffer("select t1.* from t_calendar t1 left join t_user_friend t2 on t2.friend_user_id=t1.creator where t2.user_id=:userId and t1.type=3 ");
        if (StringUtils.isNotBlank((String)term)) {
            params.put("name", "%" + term + "%");
            sql.append("and t1.name like :name ");
        }
        sql.append("order by t1.create_time desc");
        params.put("userId", userId);
        return this.getBeanPaginationSupport(sql.toString(), null, start, num, params, Calendar.class);
    }

    public void removeCalendar(Long calendarId) {
        HashMap<String, Long> params = new HashMap<String, Long>(1);
        params.put("id", calendarId);
        this.update("delete from t_calendar where id=:id", params);
    }

    public void removePersonalCalendars(Long calendarId) {
        HashMap<String, Long> params = new HashMap<String, Long>(1);
        params.put("calendarId", calendarId);
        this.update("delete from t_calendar_config where calendar_id=:calendarId", params);
    }

    public void removePersonalCalendar(Long personalCalendarId) {
        HashMap<String, Long> params = new HashMap<String, Long>(1);
        params.put("id", personalCalendarId);
        this.update("delete from t_calendar_config where id=:id", params);
    }

    public PersonalCalendar savePersonalCalendar(PersonalCalendar personalCalendar) {
        return personalCalendar.getId() == null ? this.addPersonalCalendar(personalCalendar) : this.updatePersonalCalendar(personalCalendar);
    }

    private PersonalCalendar updatePersonalCalendar(PersonalCalendar personalCalendar) {
        this.updateByBean("update t_calendar_config set calendar_id=:calendarId,name=:name,creator=:creator,add_time=:addTime,color=:color,visible=:visible,selected=:selected,remind=:remind where id=:id", (Object)personalCalendar);
        return personalCalendar;
    }

    private PersonalCalendar addPersonalCalendar(PersonalCalendar personalCalendar) {
        personalCalendar.setId(new Long(this.idGenerator.nextLongValue(T_CALENDAR_CONFIG_SEQ)));
        this.updateByBean("insert into t_calendar_config (id,calendar_id,name,creator,add_time,color,visible,selected,remind) values (:id,:calendarId,:name,:creator,:addTime,:color,:visible,:selected,:remind)", (Object)personalCalendar);
        return personalCalendar;
    }

    public PersonalCalendar getPersonalCalendar(Long personalCalendarId) {
        String sql = "select t1.*,t2.description,t2.creator as calendar_creator,t2.create_time,t2.type from t_calendar_config t1 left join t_calendar t2 on t2.id = t1.calendar_id where t1.id = :id";
        HashMap<String, Long> params = new HashMap<String, Long>(1);
        params.put("id", personalCalendarId);
        return (PersonalCalendar)this.queryForBean("select t1.*,t2.description,t2.creator as calendar_creator,t2.create_time,t2.type from t_calendar_config t1 left join t_calendar t2 on t2.id = t1.calendar_id where t1.id = :id", params, PersonalCalendar.class);
    }

    public List getPersonalCalendars(Long calendarId) {
        String sql = "select t1.*,t2.description,t2.creator as calendar_creator,t2.create_time,t2.type from t_calendar_config t1 left join t_calendar t2 on t2.id = t1.calendar_id where t1.calendar_id = :calendarId order by t1.add_time desc";
        HashMap<String, Long> params = new HashMap<String, Long>(1);
        params.put("calendarId", calendarId);
        return this.queryForBeanList("select t1.*,t2.description,t2.creator as calendar_creator,t2.create_time,t2.type from t_calendar_config t1 left join t_calendar t2 on t2.id = t1.calendar_id where t1.calendar_id = :calendarId order by t1.add_time desc", -1, -1, params, PersonalCalendar.class);
    }

    public PersonalCalendar getPersonalCalendar(Long calendarId, String userId) {
        String sql = "select t1.*,t2.description,t2.creator as calendar_creator,t2.create_time,t2.type from t_calendar_config t1 inner join t_calendar t2 on t2.id = t1.calendar_id where t2.id = :calendarId and t1.creator=:userId";
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("calendarId", calendarId);
        params.put("userId", userId);
        return (PersonalCalendar)this.queryForBean("select t1.*,t2.description,t2.creator as calendar_creator,t2.create_time,t2.type from t_calendar_config t1 inner join t_calendar t2 on t2.id = t1.calendar_id where t2.id = :calendarId and t1.creator=:userId", params, PersonalCalendar.class);
    }

    public List getPersonalCalendars(String userId, Boolean isVisible) {
        String sql = "select t1.*,t2.description,t2.creator as calendar_creator,t2.create_time,t2.type from t_calendar_config t1 left join t_calendar t2 on t2.id = t1.calendar_id where t1.creator = :userId" + (isVisible != null ? " and visible=" + (isVisible != false ? 1 : 0) : "") + " order by t1.add_time desc";
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("userId", userId);
        return this.queryForBeanList(sql, -1, -1, params, PersonalCalendar.class);
    }

    public List getPersonalCalendars(String userId, short type) {
        String sql = "select t1.*,t2.description,t2.creator as calendar_creator,t2.create_time,t2.type from t_calendar_config t1 left join t_calendar t2 on t2.id = t1.calendar_id where t1.creator = :userId and t2.type=:type order by t1.add_time desc";
        HashMap<String, Object> params = new HashMap<String, Object>(1);
        params.put("userId", userId);
        params.put("type", type);
        return this.queryForBeanList("select t1.*,t2.description,t2.creator as calendar_creator,t2.create_time,t2.type from t_calendar_config t1 left join t_calendar t2 on t2.id = t1.calendar_id where t1.creator = :userId and t2.type=:type order by t1.add_time desc", -1, -1, params, PersonalCalendar.class);
    }

    public List getAsynchronousGroupCalendars(String userId) {
        String sql = "select t1.* from t_calendar t1 left join pf_user_organ_rel t2 on t2.organ_id = t1.owner left join t_calendar_config t3 on t3.creator=t2.user_id and t3.calendar_id=t1.id where t2.user_id = :userId and t3.id is null";
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("userId", userId);
        return this.queryForBeanList("select t1.* from t_calendar t1 left join pf_user_organ_rel t2 on t2.organ_id = t1.owner left join t_calendar_config t3 on t3.creator=t2.user_id and t3.calendar_id=t1.id where t2.user_id = :userId and t3.id is null", -1, -1, params, Calendar.class);
    }

    public List getStandardPersonalCalendars(String userId) {
        String sql = "select t1.*,t2.description,t2.creator as calendar_creator,t2.create_time,t2.type from t_calendar_config t1 left join t_calendar t2 on t2.id = t1.calendar_id where t1.creator = :userId and t2.type=5 order by t1.add_time desc";
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("userId", userId);
        return this.queryForBeanList("select t1.*,t2.description,t2.creator as calendar_creator,t2.create_time,t2.type from t_calendar_config t1 left join t_calendar t2 on t2.id = t1.calendar_id where t1.creator = :userId and t2.type=5 order by t1.add_time desc", -1, -1, params, PersonalCalendar.class);
    }

    public List getGroupPersonalCalendars(String userId, String groupId) {
        String sql = "select t1.*,t2.description,t2.creator as calendar_creator,t2.create_time,t2.type from t_calendar_config t1 left join t_calendar t2 on t2.id = t1.calendar_id where t1.creator = :userId and t2.type=6 and t2.owner=:groupId order by t1.add_time desc";
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("userId", userId);
        params.put("groupId", groupId);
        return this.queryForBeanList("select t1.*,t2.description,t2.creator as calendar_creator,t2.create_time,t2.type from t_calendar_config t1 left join t_calendar t2 on t2.id = t1.calendar_id where t1.creator = :userId and t2.type=6 and t2.owner=:groupId order by t1.add_time desc", -1, -1, params, PersonalCalendar.class);
    }

    public List getAsynchronousStandardCalendars(String userId) {
        String sql = "select * from t_calendar where type=5 and id not in (select calendar_id from t_calendar_config where creator=:userId)";
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("userId", userId);
        return this.queryForBeanList("select * from t_calendar where type=5 and id not in (select calendar_id from t_calendar_config where creator=:userId)", -1, -1, params, Calendar.class);
    }

    public List getGroupCalendars(String groupId) {
        String sql = "select * from t_calendar where type=6 and owner=:groupId";
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("groupId", groupId);
        return this.queryForBeanList("select * from t_calendar where type=6 and owner=:groupId", -1, -1, params, Calendar.class);
    }
}

