/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.egov.calendar;

import com.gtis.egov.calendar.model.Event;
import com.gtis.egov.calendar.model.Reminder;
import com.gtis.egov.calendar.utils.DateUtils;
import com.gtis.egov.calendar.utils.StringUtils;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.fortuna.ical4j.model.DateList;
import net.fortuna.ical4j.model.Recur;
import net.fortuna.ical4j.model.parameter.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Helper {
    private static final Logger logger = LoggerFactory.getLogger(Helper.class);

    public static List getRecurrenceEvents(Event baseEvent, Date startDate, Date endDate) {
        ArrayList<Event> events = new ArrayList<Event>();
        try {
            Recur recur = new Recur(baseEvent.getRecurrenceRule());
            if (startDate.before(baseEvent.getStartTime())) {
                startDate = baseEvent.getStartTime();
            }
            if (baseEvent.getRepeatEndTime() != null) {
                recur.setUntil(new net.fortuna.ical4j.model.Date(baseEvent.getRepeatEndTime()));
                if (endDate.after(baseEvent.getRepeatEndTime())) {
                    endDate = baseEvent.getRepeatEndTime();
                }
            } else {
                recur.setUntil(new net.fortuna.ical4j.model.Date(endDate));
            }
            DateList dateList = recur.getDates(new net.fortuna.ical4j.model.Date(baseEvent.getStartTime()), new net.fortuna.ical4j.model.Date(startDate), new net.fortuna.ical4j.model.Date(DateUtils.addDays((Date)endDate, (int)1)), Value.DATE);
            for (int i = 0; i < dateList.size(); ++i) {
                net.fortuna.ical4j.model.Date date = (net.fortuna.ical4j.model.Date)dateList.get(i);
                int diffDate = (int)Math.ceil((double)(date.getTime() - baseEvent.getStartTime().getTime()) / 8.64E7);
                try {
                    Event event = (Event)baseEvent.clone();
                    event.setStartTime(DateUtils.addDays((Date)event.getStartTime(), (int)diffDate));
                    event.setEndTime(DateUtils.addDays((Date)event.getEndTime(), (int)diffDate));
                    event.setRecurDiff((long)diffDate * 86400000L);
                    events.add(event);
                    continue;
                }
                catch (CloneNotSupportedException e) {
                    // empty catch block
                }
            }
        }
        catch (ParseException e) {
            logger.error("Parse recur ({}) error", (Object)baseEvent.getRecurrenceRule());
        }
        return events;
    }

    public static Reminder getNearRecurrenceEventReminder(Reminder reminder, Date startDate, Date endDate) {
        Event event = reminder.getEvent();
        if (StringUtils.isBlank((String)event.getRecurrenceRule())) {
            return reminder;
        }
        try {
            Recur recur = new Recur(event.getRecurrenceRule());
            if (startDate.before(event.getStartTime())) {
                startDate = event.getStartTime();
            }
            if (event.getRepeatEndTime() != null) {
                recur.setUntil(new net.fortuna.ical4j.model.Date(event.getRepeatEndTime()));
                if (endDate.after(event.getRepeatEndTime())) {
                    endDate = event.getRepeatEndTime();
                }
            } else {
                recur.setUntil(new net.fortuna.ical4j.model.Date(endDate));
            }
            DateList dateList = recur.getDates(new net.fortuna.ical4j.model.Date(event.getStartTime()), new net.fortuna.ical4j.model.Date(startDate), new net.fortuna.ical4j.model.Date(DateUtils.addDays((Date)endDate, (int)1)), Value.DATE);
            for (int i = 0; i < dateList.size(); ++i) {
                net.fortuna.ical4j.model.Date date = (net.fortuna.ical4j.model.Date)dateList.get(i);
                int diffDate = (int)Math.ceil((double)(date.getTime() - event.getStartTime().getTime()) / 8.64E7);
                Date remindDate = DateUtils.addSeconds((Date)DateUtils.addDays((Date)event.getStartTime(), (int)diffDate), (int)(-reminder.getSeconds()));
                if (!remindDate.after(startDate) || !remindDate.before(endDate)) continue;
                event.setStartTime(DateUtils.addDays((Date)event.getStartTime(), (int)diffDate));
                event.setEndTime(DateUtils.addDays((Date)event.getEndTime(), (int)diffDate));
                return reminder;
            }
        }
        catch (ParseException e) {
            logger.error("Parse recur ({}) error", (Object)event.getRecurrenceRule());
        }
        return null;
    }
}

