/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.egov.calendar;

import com.gtis.egov.calendar.model.Reminder;
import com.gtis.egov.calendar.service.ReminderManager;
import com.gtis.egov.calendar.utils.DateUtils;
import java.util.Date;
import java.util.List;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.quartz.QuartzJobBean;

public class EventRemindJob
extends QuartzJobBean {
    private static final Logger logger = LoggerFactory.getLogger(EventRemindJob.class);
    private ReminderManager reminderManager;
    private int remindInterval;
    private static Date updateTime;

    public void setReminderManager(ReminderManager reminderManager) {
        this.reminderManager = reminderManager;
    }

    public void setRemindInterval(int remindInterval) {
        this.remindInterval = remindInterval;
    }

    protected void executeInternal(JobExecutionContext context) throws JobExecutionException {
        logger.debug(" EventRemindJob start");
        Date now = new Date();
        if (updateTime == null) {
            updateTime = now;
        }
        Date endTime = DateUtils.addSeconds((Date)updateTime, (int)this.remindInterval);
        boolean expired = endTime.before(now);
        if (updateTime.equals(now) || expired) {
            if (expired) {
                updateTime = endTime;
                endTime = DateUtils.addSeconds((Date)updateTime, (int)this.remindInterval);
            }
            this.reminderManager.updateRemindersQueue(updateTime, endTime);
        }
        List reminders = this.reminderManager.getNeedProcessRemindersFromQueue(now);
        for (int i = 0; i < reminders.size(); ++i) {
            Reminder reminder = (Reminder)reminders.get(i);
            if (!this.reminderManager.sendReminder(reminder)) continue;
            this.reminderManager.removeReminderFromQueue(reminder);
        }
        logger.debug(" EventRemindJob end");
    }
}

