/*
 * Author: xyang
 *
 * Project: trunk
 *
 * File: UserServiceImpl.java
 *
 * LastModified: 2010-01-26 02:24:17
 *
 * Copyright (c) 2010 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */

package com.gtis.egov.generic.impl;

import com.gtis.egov.generic.User;
import com.gtis.egov.generic.UserService;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.plat.vo.UserInfo;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2010-1-26
 */
public class UserServiceImpl implements UserService {

    private SysUserService sysUserService;
    private Ehcache userNameCache;

    public void setSysUserService(SysUserService sysUserService) {
        this.sysUserService = sysUserService;
    }


    public void setUserNameCache(Ehcache userNameCache) {
        this.userNameCache = userNameCache;
    }

    public User loadUser(String userId) {
        Element element = userNameCache.get(userId);
        if (element != null)
            return (User) element.getObjectValue();
        PfUserVo vo = sysUserService.getUserVo(userId);
        if (vo == null)
            return null;
        UserInfo user = new UserInfo();
        user.setId(vo.getUserId());
        user.setUsername(vo.getUserName());
        User u = new User(user);
        userNameCache.put(new Element(userId, u));
        return u;
    }
}
