/*
 * Author: xyang
 *
 * Project: trunk
 *
 * File: MessageServiceImpl.java
 *
 * LastModified: 2010-01-26 03:52:27
 *
 * Copyright (c) 2010 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */

package com.gtis.egov.generic.impl;

import com.gtis.common.util.UUIDGenerator;
import com.gtis.egov.calendar.utils.StringUtils;
import com.gtis.egov.generic.Message;
import com.gtis.egov.generic.MessageService;
import com.gtis.plat.service.SysMessageService;
import com.gtis.plat.vo.PfMessageSendVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2010-1-26
 */
public class MessageServiceImpl implements MessageService {

    private static final Logger logger = LoggerFactory.getLogger(MessageServiceImpl.class);
    private SysMessageService sysMessageService;

    public void setSysMessageService(SysMessageService sysMessageService) {
        this.sysMessageService = sysMessageService;
    }


    public boolean sendMessage(Message message) {
        PfMessageSendVo vo = new PfMessageSendVo();
        vo.setUserId(message.getSender());
        vo.setMessageAcceptUser(StringUtils.join(message.getReceivers(), ","));
        vo.setMessageSendTitle(message.getSubject());
        vo.setMessageSendContent(message.getContent());
        vo.setMessageSendId(UUIDGenerator.generate());
        sysMessageService.insertMessage(vo);
        logger.debug("test send message [{}]", message);
        return true;
    }

    public boolean sendMail(Message message) {
        logger.debug("test send mail [{}]", message);
        return true;
    }

    public boolean sendSms(Message message) {
        logger.debug("test send sms [{}]", message);
        return true;
    }
}
