/*
 * Author: xyang
 *
 * Project: trunk
 *
 * File: RequestUtils.java
 *
 * LastModified: 2010-01-26 01:09:21
 *
 * Copyright (c) 2010 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */

package com.gtis.egov.calendar.utils;

import org.apache.commons.lang.StringUtils;

import javax.servlet.http.HttpServletRequest;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2010-1-26
 */
public final class RequestUtils {
    /**
     * get referer page from request object
     *
     * @param request HttpServletRequest object.
     * @return url of referer page.
     */
    public static String getReferer(final HttpServletRequest request) {
        String url = request.getParameter("referer");
        if (org.apache.commons.lang.StringUtils.isBlank(url)) {
            url = request.getHeader("referer");
        }
        return url;
    }

    /**
     * 获取上下文路径.
     *
     * @param request HttpServletRequest.
     * @return 上下文路径.
     */
    public static String getContextPath(final HttpServletRequest request) {
        String ctx = request.getContextPath();
        if ("/".equals(ctx)) {
            ctx = "";
        }

        return ctx;
    }

    /**
     * Get start number from HttpServletRequest.
     *
     * @param request       HttpServletRequest.
     * @param pageParamName page paramenter name in the request object.
     * @param num           record number per page.
     * @return record start number.
     */
    public static int getStartNum(HttpServletRequest request, String pageParamName, int num) {
        // get page value from HttpServletRequest
        int page = org.apache.commons.lang.math.NumberUtils.toInt(StringUtils.trimToNull(request.getParameter(pageParamName)), 1);
        if (page < 1) {
            page = 1;
        }
        page--;
        return page * num;
    }

    /**
     * Get start number from HttpServletRequest.
     *
     * @param request HttpServletRequest.
     * @return record start number.
     */
    public static int getStartNum(HttpServletRequest request) {
        return getStartNum(request, "page", 10);
    }

    /**
     * Get start number from HttpServletRequest.
     *
     * @param request HttpServletRequest.
     * @param num     record number per page.
     * @return record start number.
     */
    public static int getStartNum(HttpServletRequest request, int num) {
        return getStartNum(request, "page", num);
    }

    /**
     * Get start number from HttpServletRequest.
     *
     * @param request       HttpServletRequest.
     * @param pageParamName page paramenter name in the request object.
     * @return record start number.
     */
    public static int getStartNum(HttpServletRequest request, String pageParamName) {
        return getStartNum(request, pageParamName, 10);
    }

    /**
     * Private constructor.
     */
    private RequestUtils() {
        // prevent being initializing.
    }
}
