package com.gtis.egov.calendar.service;

import com.gtis.egov.calendar.model.Reminder;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 提醒管理接口
 * <p/>
 *
 * @author <a href="mailto:oznyang@163.com">oznyang</a>
 * @version V1.0, 2009-5-14 10:31:43
 */
public interface ReminderManager {

    /**
     * 保存提醒
     *
     * @param reminder 提醒
     * @return 提醒
     */
    Reminder saveReminder(Reminder reminder);

    /**
     * 获取提醒
     *
     * @param reminderId 提醒Id
     * @return 提醒
     */
    Reminder getReminder(Long reminderId);

    /**
     * 获取事件的所有提醒
     *
     * @param eventId 事件Id
     * @return 提醒列表
     */
    List/*<Reminder>*/ getReminders(Long eventId);

    /**
     * 获取时间段内需要处理的提醒
     *
     * @param startDate startDate
     * @param endDate   endDate
     * @return 提醒列表
     */
    List/*<Reminder>*/ getReminders(Date startDate, Date endDate);

    /**
     * 获取时间段内到指定时间点需要处理的提醒列表
     *
     * @param date date
     * @return 提醒列表
     */
    List getNeedProcessRemindersFromQueue(Date date);

    /**
     * 更新时间段内需要处理的提醒队列
     *
     * @param startDate startDate
     * @param endDate   endDate
     */
    void updateRemindersQueue(Date startDate, Date endDate);

    /**
     * 从队列中删除指定reminder
     * @param reminder reminder
     */
    void removeReminderFromQueue(Reminder reminder);

    /**
     * 删除提醒
     *
     * @param reminderId 提醒Id
     */
    void removeReminder(Long reminderId);

    /**
     * 发送消息提醒
     *
     * @param reminder 提醒
     * @return 是否成功
     */
    boolean sendReminder(Reminder reminder);
}
