package com.gtis.egov.calendar.service;

import com.gtis.egov.calendar.model.Event;

import java.util.Date;
import java.util.List;

/**
 * 事件管理接口
 * <p/>
 *
 * @author <a href="mailto:oznyang@163.com">oznyang</a>
 * @version V1.0, 2009-5-14 10:30:48
 */
public interface EventManager {

    /**
     * 保存事件
     *
     * @param event 事件
     * @return 事件
     */
    Event saveEvent(Event event);

    /**
     * 获取事件
     *
     * @param eventId 事件Id
     * @return 事件
     */
    Event getEvent(Long eventId);

    /**
     * 获取时间段内的事件
     *
     * @param userId      用户Id
     * @param calendarIds 日历Id
     * @param startDate   开始时间
     * @param endDate     结束时间    @return 事件列表    @return  事件列表
     * @return 事件列表
     */
    List/*<Event>*/ getEvents(String userId, Long[] calendarIds, Date startDate, Date endDate);

    /**
     * 获取用户时间段内所有事件
     *
     * @param userId    用户Id
     * @param startDate 开始时间
     * @param endDate   结束时间
     * @return 事件列表
     */
    List/*<Event>*/ getAllEvents(String userId, Date startDate, Date endDate);

    /**
     * 删除事件
     *
     * @param eventId 事件Id
     */
    void removeEvent(Long eventId);
}
