package com.gtis.egov.calendar.service;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

/**
 * 日历导入导出管理接口
 * <p/>
 *
 * @author <a href="mailto:oznyang@163.com">oznyang</a>
 * @version V1.0, 2009-5-14 10:32:29
 */
public interface CalendarExchangeManager {

    /**
     * 导入iCalendar格式日历文件
     *
     * @param inputStream 输入流
     * @param calendarId  日历Id
     * @return 成功导入事件数量
     * @throws java.io.IOException IOException
     */
    public int importIcsCalendarEvents(InputStream inputStream, Long calendarId) throws IOException;

    /**
     * 导出iCalendar格式日历文件
     *
     * @param outputStream 输出流
     * @param calendarId   日历Id
     * @return 成功导出事件数量
     * @throws IOException IOException
     */
    public int exportIcsCalendarEvents(OutputStream outputStream, Long calendarId) throws IOException;

}
