package com.gtis.egov.calendar.model;

import com.gtis.egov.calendar.model.auto.TCalendarReminder;
import com.gtis.egov.calendar.utils.DateUtils;
import org.apache.commons.lang.builder.ToStringBuilder;

import java.util.Date;

/**
 * 提醒
 * <p/>
 *
 * @author <a href="mailto:oznyang@163.com">oznyang</a>
 * @version V1.0, 2009-5-13 19:56:18
 */
public class Reminder extends TCalendarReminder implements Comparable {

    public static final int WEEK_UNIT = 604800;
    public static final int DAY_UNIT = 86400;
    public static final int HOUR_UNIT = 3600;
    public static final int MINUTE_UNIT = 60;

    public static final int MAX_SECONDS = 4 * WEEK_UNIT; //提醒时间范围最大为四周

    private Date remindDate;
    private Event event;
    private PersonalCalendar personalCalendar;

    public Event getEvent() {
        return event;
    }

    public void setEvent(Event event) {
        this.event = event;
        remindDate = DateUtils.addSeconds(event.getStartTime(), -getSeconds());
    }

    public PersonalCalendar getPersonalCalendar() {
        return personalCalendar;
    }

    public void setPersonalCalendar(PersonalCalendar personalCalendar) {
        this.personalCalendar = personalCalendar;
    }

    public void setSeconds(int seconds) {
        super.setSeconds(seconds > MAX_SECONDS ? MAX_SECONDS : seconds);
    }

    public int getNumber() {
        int seconds = getSeconds();
        if (seconds / WEEK_UNIT > 0) {
            return seconds / WEEK_UNIT;
        } else if (seconds / DAY_UNIT > 0) {
            return seconds / DAY_UNIT;
        } else if (seconds / HOUR_UNIT > 0) {
            return seconds / HOUR_UNIT;
        } else {
            return seconds / MINUTE_UNIT;
        }
    }

    public int getUnit() {
        int seconds = getSeconds();
        if (seconds / WEEK_UNIT > 0) {
            return WEEK_UNIT;
        } else if (seconds / DAY_UNIT > 0) {
            return DAY_UNIT;
        } else if (seconds / HOUR_UNIT > 0) {
            return HOUR_UNIT;
        } else {
            return MINUTE_UNIT;
        }
    }

    public Date getRemindDate() {
        return remindDate;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    public int hashCode() {
        return (int) (getId().longValue() + (event == null ? 0 : getRemindDate().getTime()) * 31);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Reminder)) {
            return false;
        }
        Reminder o = (Reminder) obj;
        return o.getId() != null && o.getRemindDate() != null &&
                o.getId().equals(getId()) &&
                o.getRemindDate().equals(getRemindDate());
    }

    public int compareTo(Object o) {
        return remindDate.compareTo(((Reminder) o).getRemindDate());
    }
}
