package com.gtis.egov.calendar.model;

import com.gtis.egov.calendar.model.auto.TCalendarConfig;
import org.apache.commons.lang.builder.ToStringBuilder;

import java.util.Date;

/**
 * 个人日历
 * <p/>
 *
 * @author <a href="mailto:oznyang@163.com">oznyang</a>
 * @version V1.0, 2009-5-13 19:52:37
 */
public class PersonalCalendar extends TCalendarConfig {

    private String calendarCreator;
    private String description;
    private String creatorName;
    private Date createTime;
    private short type;

    public String getCalendarCreator() {
        return calendarCreator;
    }

    public void setCalendarCreator(String calendarCreator) {
        this.calendarCreator = calendarCreator;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getCreatorName() {
        return creatorName;
    }

    public void setCreatorName(String creatorName) {
        this.creatorName = creatorName;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public short getType() {
        return type;
    }

    public void setType(short type) {
        this.type = type;
    }

    public boolean isAdmin() {
        return this.getCalendarCreator().equals(this.getCreator());
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
