package com.gtis.egov.calendar.model;

import com.gtis.egov.calendar.model.auto.TCalendarEvent;
import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * 事件
 * <p/>
 *
 * @author <a href="mailto:oznyang@163.com">oznyang</a>
 * @version V1.0, 2009-5-13 19:55:54
 */
public class Event extends TCalendarEvent implements Cloneable, Comparable {

    /**
     * 事件的颜色
     */
    private String color;
    /**
     * 记录重复事件中，事件和基本事件相差的时间
     */
    private long recurDiff = -1;
    /**
     * 提醒个数
     */
    private int remindCount;

    public String getColor() {
        return color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public long getRecurDiff() {
        return recurDiff;
    }

    public void setRecurDiff(long recurDiff) {
        this.recurDiff = recurDiff;
    }

    public int getRemindCount() {
        return remindCount;
    }

    public void setRemindCount(int remindCount) {
        this.remindCount = remindCount;
    }

    public int getHashCode() {
        return hashCode();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public int hashCode() {
        int h = getRemindCount() + 1;
        long ut = getUpdateTime().getTime();
        long st = getStartTime().getTime();
        h = h * 37 + getId().intValue();
        h = h * 37 + (int) (ut ^ (ut >>> 32));
        h = h * 37 + (int) (st ^ (st >>> 32));
        if (getColor() != null)
            h = h * 37 + getColor().hashCode();
        return h;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Event)) {
            return false;
        }
        Event o = (Event) obj;
        return o.getId() != null && o.getStartTime() != null &&
                o.getId().equals(getId()) &&
                o.getStartTime().equals(getStartTime());
    }

    public int compareTo(Object o) {
        return getStartTime().compareTo(((Event) o).getStartTime());
    }
}
