package com.gtis.egov.calendar.model;

import com.gtis.egov.calendar.model.auto.TCalendar;
import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * 基本日历
 * <p/>
 *
 * @author <a href="mailto:oznyang@163.com">oznyang</a>
 * @version V1.0, 2009-5-13 19:25:22
 */
public class Calendar extends TCalendar {

    public static final short PRIVATE = 0;//个人私有日历
    public static final short PRIMARY = 1;//个人私有默认日历,不能删除
    public static final short PROTECTED = 2;//个人日历,不能修改
    public static final short FRIEND = 3;//好友可见日历，能够被好友看到
    public static final short PUBLIC = 4;//公开日历，能够被检索
    public static final short STANDARD = 5;//标准日历，如农历节假日，能够被检索
    public static final short GROUP = 6;//群组日历，群组成员可见，群组管理员可修改

    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
