package com.gtis.egov.calendar.dao;

import com.gtis.egov.calendar.model.Reminder;

import java.util.List;
import java.util.Date;

/**
 * 提醒管理DAO接口
 * <p/>
 *
 * @author <a href="mailto:oznyang@163.com">oznyang</a>
 * @version V1.0, 2009-5-14 10:39:24
 */
public interface ReminderDAO {

    /**
     * 保存提醒
     *
     * @param reminder 提醒
     * @return 提醒
     */
    Reminder saveReminder(Reminder reminder);

    /**
     * 获取提醒
     *
     * @param reminderId 提醒Id
     * @return 提醒
     */
    Reminder getReminder(Long reminderId);

    /**
     * 获取指定事件的所有提醒
     *
     * @param eventId 事件Id
     * @return 提醒列表
     */
    List/*<Reminder>*/ getReminders(Long eventId);

    /**
     * 获取时间段内需要处理的提醒
     *
     * @param startDate 起始时间
     * @param endDate    结束时间
     * @return 提醒列表
     */
    List/*<Reminder>*/ getBaseReminders(Date startDate, Date endDate);

    /**
     * 删除提醒
     *
     * @param reminderId 提醒Id
     */
    void removeReminder(Long reminderId);

    /**
     * 删除指定事件的提醒
     *
     * @param eventId 提醒Id
     */
    void removeReminders(Long eventId);

    /**
     * 删除指定日历的提醒
     *
     * @param calendarId 日历Id
     */
    void removeRemindersByCalendarId(Long calendarId);

}
