package com.gtis.egov.calendar;

import com.gtis.egov.calendar.model.Reminder;
import com.gtis.egov.calendar.service.ReminderManager;
import com.gtis.egov.calendar.utils.DateUtils;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.quartz.QuartzJobBean;

import java.util.Date;
import java.util.List;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oznyang@163.com">oznyang</a>
 * @version V1.0, 2009-5-14 10:59:19
 */
public class EventRemindJob extends QuartzJobBean {

    private static final Logger logger = LoggerFactory.getLogger(EventRemindJob.class);

    private ReminderManager reminderManager;

    private int remindInterval;

    public void setReminderManager(ReminderManager reminderManager) {
        this.reminderManager = reminderManager;
    }

    public void setRemindInterval(int remindInterval) {
        this.remindInterval = remindInterval;
    }

    private static Date updateTime;

    protected void executeInternal(JobExecutionContext context) throws JobExecutionException {
        logger.debug(" EventRemindJob start");
        Date now = new Date();
        if (updateTime == null) {
            updateTime = now;
        }
        Date endTime = DateUtils.addSeconds(updateTime, remindInterval);
        boolean expired = endTime.before(now);
        if (updateTime.equals(now) || expired) {
            if (expired) {
                updateTime = endTime;
                endTime = DateUtils.addSeconds(updateTime, remindInterval);
            }
            reminderManager.updateRemindersQueue(updateTime, endTime);
        }
        List reminders = reminderManager.getNeedProcessRemindersFromQueue(now);
        for (int i = 0; i < reminders.size(); i++) {
            Reminder reminder = (Reminder) reminders.get(i);
            if (reminderManager.sendReminder(reminder))
                reminderManager.removeReminderFromQueue(reminder);
        }
        logger.debug(" EventRemindJob end");
    }
}
