package com.gtis.archive.web.admin;

import com.gtis.archive.core.AppPropsManager;
import com.opensymphony.xwork2.ActionSupport;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;
import java.util.Map;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:USER@gtis.com.cn">WangGang</a>
 * @version V1.0, 2010-10-20
 */
public class PropsAction extends ActionSupport {
    private static final long serialVersionUID = 3955744585380151651L;
    @Autowired
    private AppPropsManager appPropService;

    private List<String> envName;
    private List<String> envValue;

    public List<String> getEnvName() {
        return envName;
    }

    public void setEnvName(List<String> envName) {
        this.envName = envName;
    }

    public List<String> getEnvValue() {
        return envValue;
    }

    public void setEnvValue(List<String> envValue) {
        this.envValue = envValue;
    }

    @Override
    public String execute() throws Exception {
        return SUCCESS;
    }

    public Map<String, String> getProps() {
        return appPropService.getAppProps();
    }

    public String getTab() {
        return "props";
    }

    public String save() throws Exception {
        if (envName != null) {
            Map<String, String> props = appPropService.getAppProps();
            props.clear();
            for (int i = 0; i < envName.size(); i++) {
                if (StringUtils.isBlank(envName.get(i)))
                    continue;
                props.put(envName.get(i), envValue.get(i));
            }
            appPropService.saveAppProps();
        }
        return SUCCESS;
    }
}
