package com.gtis.archive.web;

import com.alibaba.fastjson.JSON;
import com.gtis.archive.Constants;
import com.gtis.archive.Switch;
import com.gtis.archive.core.Model;
import com.gtis.archive.core.dict.Item;
import com.gtis.archive.core.environment.EnvHolder;
import com.gtis.archive.core.ex.ModelNotFoundException;
import com.gtis.archive.core.ex.NoPermissionException;
import com.gtis.archive.core.ex.TemplateNotFoundException;
import com.gtis.archive.core.web.BaseModelAction;
import com.gtis.archive.entity.Archive;
import com.gtis.archive.entity.Permission;
import com.gtis.archive.entity.Resource;
import com.gtis.archive.service.ArchiveService;
import com.gtis.archive.service.ExtTreeService;
import com.gtis.archive.service.ResourceService;
import com.gtis.archive.service.SecurityService;
import com.gtis.archive.util.SearchUtils;
import com.gtis.archive.util.Struts2Utils;
import com.gtis.common.Page;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.vo.PfOrganVo;
import com.gtis.web.SessionUtil;
import com.opensymphony.xwork2.Action;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.struts2.ServletActionContext;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:USER@gtis.com.cn">WangGang</a>
 * @version V1.0, 2010-10-20
 */
public class TransferAction extends BaseModelAction<Archive> {
    private String type = "model";

    @Autowired
    private ArchiveService archiveService;
    @Autowired
    private ResourceService resourceService;
    @Autowired
    private ExtTreeService treeService;
    @Autowired
    private SecurityService securityService;
    @Autowired
    private SysUserService userService;
    /**
     * 案卷ID
     */
    private String archiveid;
    /**
     * id
     */
    private String id;
    /**
     * 权证号
     */
    private String qzh;
    /**
     * 档号
     */
    private String dh;
    /**
     * ids
     */
    private String[] ids;
    /**
     * 查询类型1为权证号,2为档号，3为无条件
     */
    private int st;
    /**
     * tree id
     */
    private String treeId;
    /**
     * 链接字段
     */
    private String linkField;
    /**
     * 模糊检索关键字
     */
    protected String query;

    public int getSt() {
        return st;
    }

    public void setSt(int st) {
        this.st = st;
    }

    public String getQzh() {
        return qzh;
    }

    public void setQzh(String qzh) {
        this.qzh = qzh;
    }

    public String getDh() {
        return dh;
    }

    public void setDh(String dh) {
        this.dh = dh;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getArchiveid() {
        return archiveid;
    }

    public void setArchiveid(String archiveid) {
        this.archiveid = archiveid;
    }

    @Override
    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String[] getIds() {
        return ids;
    }

    public void setIds(String[] ids) {
        this.ids = ids;
    }

    public String getTreeId() {
        return treeId;
    }

    public void setTreeId(String treeId) {
        this.treeId = treeId;
    }

    public String getQuery() {
        return query;
    }

    @Override
    public void setQuery(String query) {
        this.query = query;
    }

    /**
     * 获取业务模型
     *
     * @return
     */
    public String resourceList() throws Exception {
//        List<Resource> ress = resourceService.getChildrenResource(null,"model");
        List<Resource> ress = StringUtils.isBlank(id) ? resourceService.getChildrenResource(resourceService.getResource(null, type).getId()) : resourceService.getChildrenResource(id);
        List<Map<Object, Serializable>> list = new ArrayList<Map<Object, Serializable>>();
        for (Resource res : ress) {
            Map<Object, Serializable> map = new HashMap<Object, Serializable>();
            map.put("id", res.getId());
            String text = res.getName();
//            if (StringUtils.isNotEmpty(res.getTitle())) {
//                text = text + "(" + res.getTitle() + ")";
//            }
            map.put("text", text);
            map.put("name", res.getName());
            map.put("title", res.getTitle());
            map.put("content", res.getContent());
            map.put("parentId", res.getParentId());
            map.put("flh", res.getFlh());
            map.put("orderNumber", res.getOrderNumber());
            map.put("iconCls", "no-icon");
//            if(!StringUtils.isBlank(id)) {
//                map.put("checked", false);
//            }
            list.add(map);
        }
        Struts2Utils.renderJson(list);
        return null;
    }

    /**
     * 判断查询数据方法
     *
     * @return
     * @throws Exception
     */
    public void archiveList() throws Exception {
        renderJson(getArchiveEntityPage());
    }

    /**
     * 查询数据
     *
     * @return
     */
    protected Page<Archive> getArchiveEntityPage() {
        List<Criterion> criterions = new ArrayList<Criterion>();

        if (StringUtils.isNotBlank(query)) {
            criterions.add(Restrictions.like("id", "%" + query + "%"));
        }
        if (st == 2) {
            criterions.add(Restrictions.eq("state", 3));
        }

        if (StringUtils.isNotBlank(condition)) {
            criterions.addAll(SearchUtils.conditionToCriterion(getFields(), condition));
        }
        if(!SessionUtil.getCurrentUser().isAdmin()){
            criterions.add(Restrictions.or(Restrictions.isNull("dwdm"), Restrictions.like("dwdm", "%" + getDwdm() + "%")));
        }
        List<Order> orders = createOrders(new ArrayList<Order>());
        Page<Archive> page = entityService.search(modelName, criterions, orders, start, limit);
        return page;
    }

    protected List<Order> createOrders(final ArrayList<Order> orders) {
        if (StringUtils.isNotEmpty(sort)) {
            if (DIR_ASC.equalsIgnoreCase(dir)) {
                orders.add(Order.asc(sort));
            } else {
                orders.add(Order.desc(sort));
            }
        }
        if (orders.isEmpty()) {
            for (Map.Entry<String, String> entry : getOrderFields().entrySet()) {
                orders.add(entry.getValue().equalsIgnoreCase(DIR_ASC) ? Order.asc(entry.getKey()) : Order.desc(entry.getKey()));
            }
        }
        return orders;
    }

    private List<Map<String, Object>> tree;

    public List<Map<String, Object>> getTree() {
        if (tree == null) {
            List<Map<String, Object>> listTree = treeService.getTree(null, Constants.MODEL_ROOT);
            for (Map item : listTree) {
                logger.debug(item.toString());
                if (item.get("name").equals(Constants.GENERIC)) {
                    listTree.remove(item);
                    break;
                }
            }
            tree = listTree;
        }
        return tree;
    }

    @Override
    public String execute() {
        if (StringUtils.isNotEmpty(modelName)) {
            Resource res = resourceService.findChildResource(null, modelName, Constants.MODEL_ROOT);
            if (res != null) {
                treeId = res.getId();
                if (!securityService.isPermitted(treeId, Permission.VIEW_PERMISSION)) {
                    throw new NoPermissionException(modelName);
                }
            } else {
                throw new ModelNotFoundException(modelName);
            }
        }
        modelService.getModel(modelName);
        String id = getId();
        if (id != null) {
            Archive archive = archiveService.getArchive(modelName, id);
            if (archive != null) {
                type = archive.getState() == Archive.STATE_YGD ? "ygd" : "wgd";
            }
        }

        return Action.SUCCESS;
    }

    /**
     * 获取超链接字段
     *
     * @return
     */
    public String getLinkField() {
        if (linkField == null) {
            try {
                linkField = archiveService.getArchiveModel(modelName).getTemplate("linkField");
            } catch (Exception ex) {
                linkField = "tm";
            }
        }
        return linkField;
    }

    public void updateArchive() {
        String yjdh = createYjdh();
        if (StringUtils.isEmpty(yjdh)) return;
        ids = ids[0].split(",");
        for (String id : ids) {
            archiveService.updateYjdhById("t_archive_"+modelName,id,yjdh);
        }
    }

    private String oraganNo() {
       String userId = SessionUtil.getCurrentUserId();
        String oraganNo = null;
        List<PfOrganVo> pfOrganVoList = userService.getOrganListByUser(userId);
        if (pfOrganVoList != null && pfOrganVoList.size() > 0) {
            PfOrganVo pfOrganVo = pfOrganVoList.get(0);
            oraganNo = pfOrganVo.getOraganNo();
        }
       return oraganNo;
    }

    /**
     * 返回一个新的移交单
     * @return
     */
    private String createYjdh() {
        DateFormat format =  new SimpleDateFormat("yyyymmdd");
        String date = format.format(new Date());
        DateFormat year = new SimpleDateFormat("yyyy");
        String years = year.format(new Date());
        StringBuffer buffer = new StringBuffer();
        String dwdm = oraganNo();
        String dwjc = null;
        if (dwdm != null) {
            List<Item> items = this.dictService.getItems("dwjc");
            for (Item item : items) {
                String value = item.getValue();
                if (value.equals(dwdm)) {
                    dwjc = item.getName();
                    break;
                }
            }
        } else {
            logger.error("获取单位简称失败");
            return null;
        }
        String ywjc = null;
        if(!StringUtils.isEmpty(modelName)){
            List<Item> items = this.dictService.getItems("ywjc");
            for (Item item : items) {
                String value = item.getValue();
                if (value.equals(modelName)) {
                    ywjc = item.getName();
                    break;
                }
            }
        }
        int maxyjdh = archiveService.maxYjdh("t_archive_"+modelName,years,ywjc,dwjc);
        int newyjdh = maxyjdh +1;
        String yjdh = String.valueOf(newyjdh);
        StringBuffer sb = new StringBuffer();
        for (int i = 0;i< 4 - yjdh.length();i++){
            sb.append("0");
        }
        sb.append(yjdh);
        buffer.append(date).append(dwjc).append(ywjc).append(sb);
        return buffer.toString();
    }
    private String getDwdm() {
        String dwdm = (String) Struts2Utils.getSessionAttribute("__dwdm");
        if (dwdm == null) {
            ////单位代码用部门代码进行替换
            if (EnvHolder.isEnable(Switch.ORAGAN_NO)) {
                String oraganNo = null;
                List<PfOrganVo> pfOrganVoList = userService.getOrganListByUser(SessionUtil.getCurrentUserId());
                if (pfOrganVoList != null && pfOrganVoList.size() > 0) {
                    PfOrganVo pfOrganVo = pfOrganVoList.get(0);
                    oraganNo = pfOrganVo.getOraganNo();
                }

                dwdm = oraganNo;
            } else {
                dwdm = userService.getUserRegionCode(SessionUtil.getCurrentUserId());
            }
        }

        return dwdm;
    }
}
