package com.gtis.archive.web;

import com.alibaba.fastjson.JSONArray;
import com.gtis.archive.Constants;
import com.gtis.archive.core.dict.DictService;
import com.gtis.archive.core.dict.Item;
import com.gtis.archive.core.ex.ModelNotFoundException;
import com.gtis.archive.core.ex.NoPermissionException;
import com.gtis.archive.core.web.BaseModelAction;
import com.gtis.archive.entity.*;
import com.gtis.archive.service.*;
import com.gtis.common.Page;
import com.gtis.web.SessionUtil;
import com.opensymphony.xwork2.Action;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.*;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">fan yong sheng</a>
 * @version V1.0, 2016-11-02
 */
public class BindAction extends BaseModelAction<Archive> {
    @Autowired
    private ArchiveService archiveService;
    @Autowired
    private ExtTreeService treeService;
    @Autowired
    private ResourceService resourceService;
    @Autowired
    private SecurityService securityService;
    @Autowired
    private DictService dictService;

    /**
     * tree id
     */
    private String treeId;

    /**
     * 所有定义的操作项
     */
    private List<Item> operations;

    /**
     * 盒号
     */
    private String boxId;

    /**
     * 多个盒号
     */
    private String[] boxIds;

    /**
     * 年度
     */
    private String nd;

    /**
     * 档号
     */
    private String dh;

    /**
     * 目录号
     */
    private String mlh;

    /**
     * 存放位置
     */
    private String cfwz;

    /**
     * 是否显示提示
     */
    private Boolean showInfo;

    /**
     * 保存的值
     */
    private String saveValue;

    public String getTreeId() {
        return treeId;
    }

    public void setTreeId(String treeId) {
        this.treeId = treeId;
    }

    public List<Item> getOperations() {
        return operations;
    }

    public void setOperations(List<Item> operations) {
        this.operations = operations;
    }

    public String getNd() {
        return nd;
    }

    public void setNd(String nd) {
        this.nd = nd;
    }

    public String getDh() {
        return dh;
    }

    public void setDh(String dh) {
        this.dh = dh;
    }

    public String getMlh() {
        return mlh;
    }

    public void setMlh(String mlh) {
        this.mlh = mlh;
    }

    public String getBoxId() {
        return boxId;
    }

    public void setBoxId(String boxId) {
        this.boxId = boxId;
    }

    public String[] getBoxIds() {
        return boxIds;
    }

    public void setBoxIds(String[] boxIds) {
        this.boxIds = boxIds;
    }

    public String getCfwz() {
        return cfwz;
    }

    public void setCfwz(String cfwz) {
        this.cfwz = cfwz;
    }

    public String getSaveValue() {
        return saveValue;
    }

    public void setSaveValue(String saveValue) {
        this.saveValue = saveValue;
    }

    public Boolean getShowInfo() {
        showInfo = false;
        return showInfo;
    }

    public void setShowInfo(Boolean showInfo) {
        this.showInfo = showInfo;
    }

    private List<Map<String, Object>> tree;

    public List<Map<String, Object>> getTree() {
        if (tree == null) {
            List<Map<String, Object>> listTree = treeService.getTree(null, Constants.MODEL_ROOT);
            for (Map item : listTree) {
                logger.debug(item.toString());
                if (item.get("name").equals(Constants.GENERIC)) {
                    listTree.remove(item);
                    break;
                }
            }
            tree = listTree;
        }
        return tree;
    }

    private List<String> ndTree;

    public List<String> getNdTree() {
        if (ndTree == null) {
            ndTree = new ArrayList<String>();
            List list = archiveService.getArchiveNd(modelName);
            if (list != null && list.size() > 0) {
                for (int i = 0; i < list.size(); i++) {
                    ndTree.add(list.get(i).toString());
                }
            }
        }

        return ndTree;
    }

    private List<String> qy;

    public List<String> getQy() {
        if (qy == null) {
            qy = new ArrayList<String>();
            List<Item> items = this.dictService.getItems("dwjc");
            if (items != null && items.size() > 0) {
                for (int i = 0; i < items.size(); i++) {
                    qy.add(items.get(i).getName());
                }
            }
        }

        return qy;
    }

    private List<String> mlhTree;

    public List<String> getMlhTree() {
        if (mlhTree == null) {
            mlhTree = new ArrayList<String>();
            List list = archiveService.getArchiveMlh(modelName);
            if (list != null && list.size() > 0) {
                for (int i = 0; i < list.size(); i++) {
                    mlhTree.add(list.get(i).toString());
                }
            }
        }

        return mlhTree;
    }

    @Override
    public String execute() {
        operations = dictService.getItems(Permission.OPERATION_DICT);

        if (StringUtils.isNotEmpty(modelName)) {
            Resource res = resourceService.findChildResource(null, modelName, Constants.MODEL_ROOT);
            if (res != null) {
                treeId = res.getId();
                if (!securityService.isPermitted(treeId, Permission.VIEW_PERMISSION)) {
                    throw new NoPermissionException(modelName);
                }
            } else {
                throw new ModelNotFoundException(modelName);
            }
        }

        ServletActionContext.getRequest().getSession().setAttribute("username", SessionUtil.getCurrentUser().getUsername());
        return Action.SUCCESS;
    }

    public void list() throws Exception {
        try {
            List list = archiveService.getBox(modelName, nd, dh, mlh, boxId, cfwz);
            List<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
            if (list != null && list.size() > 0) {
                int iMaxCnt = 20;
                for (int i = 0; i < list.size(); i++) {
                    if(i >= iMaxCnt) {
                        showInfo = true;
                        break;
                    }

                    Object[] objects = (Object[]) list.get(i);
                    if (objects != null && objects.length > 0) {
                        Map<String, Object> map = new HashMap<String, Object>();
                        map.put("xh", i + 1);
                        map.put("hh", objects[0]);
                        if (objects.length > 1) {
                            map.put("cfwz", objects[1]);
                        }

                        mapList.add(map);
                    }
                }
            }

            Page<Map<String, Object>> page = new Page<Map<String, Object>>();
            page.setItems(mapList);
            renderJson(page);
        } catch (Exception e) {
            renderJson(new Page());
        }
    }

    /**
     * 删除盒号信息
     */
    public void delete(){
        if(boxIds == null || boxIds.length == 0){
            return;
        }

        archiveService.deleteArchiveBoxId(boxIds, modelName, nd, dh, mlh, cfwz);
    }

    /**
     * 保存盒号信息
     */
    public void saveArchiveBox() {
        try {
            if (saveValue == null || StringUtils.isBlank(saveValue)) {
                return;
            }
            List archiveList = JSONArray.parseArray(saveValue);
            if (archiveList != null && archiveList.size() > 0) {
                for (int i = 0; i < archiveList.size(); i++) {
                    Map archiveMap = (Map) archiveList.get(i);
                    String boxId = archiveMap.get("boxId").toString();
                    String cfwz = archiveMap.get("cfwz").toString();
                    archiveService.updateArchiveBoxIDd(modelName, nd, dh, mlh, boxId, cfwz);
                }
            }

            renderJson("保存成功！");
        } catch (Exception e) {
            logger.error(e.getMessage());
            renderJson("保存失败：" + e.toString());
        }
    }
}
