package com.gtis.archive.web.admin.xian;

import com.gtis.archive.util.Struts2Utils;
import com.opensymphony.xwork2.ActionSupport;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.SessionFactory;


import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.orm.hibernate3.SessionFactoryUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * Creator: Cache John
 * E-mail:550595698@qq.com
 * Date: 11-8-3
 * To change this template use File | Settings | File Templates.
 */
public class SqAction extends ActionSupport {
    
    private static final long serialVersionUID = -5158668525677437759L;
    private List<Map> sqs = new ArrayList<Map>();
    private String sqr;
    private String sqrfile;
    private String rq;

    protected SessionFactory sessionFactory;

    public List<Map> getSqs() {
        return sqs;
    }

    public void setSqs(List<Map> sqs) {
        this.sqs = sqs;
    }

    public String getSqr() {
        return sqr;
    }

    public void setSqr(String sqr) {
        this.sqr = sqr;
    }

    public String getSqrfile() {
        return sqrfile;
    }

    public void setSqrfile(String sqrfile) {
        this.sqrfile = sqrfile;
    }

    public String getRq() {
        return rq;
    }

    public void setRq(String rq) {
        this.rq = rq;
    }

    @Override
    public String execute() throws Exception {
        sqs = getSqFormat();
        return SUCCESS;
    }

    public String sqExcel() throws Exception {
        sqs = getSqFormat();
        Struts2Utils.setFileDownloadHeader("授权列表.xls", "xls");
        return "sqexcel";
    }

    @SuppressWarnings("unchecked")
    public List<Map> getSqFormat() throws Exception {
        String sql = "select t.Id,t.user_name,t.authorizer,t.create_time,t.expire_time,t1.Name,t.operation,t2.dh from t_original_permission t inner join t_original t1 on t.original_id=t1.Id left join t_archive t2 on t2.id=t1.owner_id";
        if (StringUtils.isNotBlank(sqr)) {
            sql += " and t.authorizer like '%" + sqr + "%' ";
        }
        if (StringUtils.isNotBlank(sqrfile)) {
            sql += " and t1.Name like '%" + sqrfile + "%'";
        }
        if (StringUtils.isNotBlank(rq)) {
            sql += " and TO_DATE('" + rq + " ','YYYY-MM-DD HH24:MI:SS')>TO_DATE(to_char( t.expire_time,'yyyy-mm-dd hh24:mi:ss'),'YYYY-MM-DD HH24:MI:SS')";
        }
        sql +=" order by t.id desc";
        SQLQuery query = getSession().createSQLQuery(sql);
        sqs = (List<Map>) query.setResultTransformer(Criteria.ALIAS_TO_ENTITY_MAP).list();
        return sqs;
    }

    /**
     * 取得当前Session.
     */
    protected final Session getSession(){
        return SessionFactoryUtils.getSession(sessionFactory, true);
    }

    /**
     * 取得sessionFactory.
     */
    public SessionFactory getSessionFactory() {
        return sessionFactory;
    }

    /**
     * 采用@Autowired按类型注入SessionFactory, 当有多个SesionFactory的时候Override本函数.
     */
    @Autowired
    public void setSessionFactory(final SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
        afterSessionFactorySet();
    }

    protected void afterSessionFactorySet() {
        //don't know where this method has empty body
    }

    public String getTab() {
        return "sq";
    }
}
