package com.gtis.archive.web.admin.xian;

import com.gtis.archive.core.dict.DictService;
import com.gtis.archive.core.dict.Item;
import com.gtis.archive.util.Struts2Utils;
import com.opensymphony.xwork2.ActionSupport;
import org.apache.commons.lang.StringUtils;



import org.hibernate.Criteria;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import org.springframework.orm.hibernate3.SessionFactoryUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Creator: Cache John
 * E-mail:550595698@qq.com
 * Date: 11-8-3
 * To change this template use File | Settings | File Templates.
 */
public class KgdaAction extends ActionSupport {
    private static final Logger logger = LoggerFactory.getLogger(KgdaAction.class);
    private static final long serialVersionUID = -6629655502303293330L;
    private List<Map> kgdas = new ArrayList<Map>();
    protected SessionFactory sessionFactory;
    private String rq1;
    private String rq2;

    @Autowired
    private DictService dictService;

    public List<Map> getKgdas() {
        return kgdas;
    }

    public void setKgdas(List<Map> kgdas) {
        this.kgdas = kgdas;
    }

    public String getRq1() {
        return rq1;
    }

    public void setRq1(String rq1) {
        this.rq1 = rq1;
    }

    public String getRq2() {
        return rq2;
    }

    public void setRq2(String rq2) {
        this.rq2 = rq2;
    }

    @Override
    public String execute() throws Exception {
        kgdas = getKgdaFormat();
        return SUCCESS;
    }

    public String kgdaExcel() throws Exception {
        kgdas = getKgdaFormat();
        Struts2Utils.setFileDownloadHeader("控规档案.xls", "xls");
        return "kgdaexcel";
    }

    public List<Map> getKgdaFormat() throws Exception {
        StringBuilder strB = new StringBuilder();
        List<Item> items = dictService.getItems("kgda");
        String sql = "select t1.Id as id ";
        for (int j = 0; j < items.size(); j++) {
            strB = strB.append(sql).append(" , (Case When t1.flh='").append(items.get(j).getValue()).append("' Then  t2.xmmc Else Null End) As xmmc").append((j + 1));
        }
        sql = strB.toString() + " from t_archive t1 , t_archive_jsxmkg t2 where  t2.Id=t1.Id ";

        if (!items.isEmpty()) {
            String temp = " and (";
            for (int l = 0; l < items.size() - 1; l++) {
                strB = new StringBuilder();
                strB = strB.append(temp).append("t1.flh='").append(items.get(l).getValue()).append("' or ");
                temp = strB.toString();
            }
            if (!items.isEmpty()) {
                temp += " t1.flh='" + items.get(items.size() - 1).getValue() + "') ";
                sql += temp;
            }
        }
        //匹配条件
        if (StringUtils.isNotBlank(rq1)) {
            sql += " and TO_DATE( '" + rq1 + "','YYYY-MM-DD HH24:MI:SS')<TO_DATE(to_char( t2.BZRQ,'yyyy-mm-dd hh24:mi:ss'),'YYYY-MM-DD HH24:MI:SS') ";
        }
        if (StringUtils.isNotBlank(rq2)) {
            sql += " and TO_DATE( '" + rq2 + "','YYYY-MM-DD HH24:MI:SS')>TO_DATE(to_char( t2.BZRQ,'yyyy-mm-dd hh24:mi:ss'),'YYYY-MM-DD HH24:MI:SS') ";
        }

        sql += "  order By t1.flh";
        SQLQuery query = getSession().createSQLQuery(sql);
        logger.error(sql);
        List<Map> list = (List<Map>) query.setResultTransformer(Criteria.ALIAS_TO_ENTITY_MAP).list();
        kgdas = dealListFormat(list);
        return kgdas;
    }

    public List<Map> dealListFormat(List<Map> list) throws Exception {
        String xmmc1 = "XMMC1";
        String xmmc2 = "XMMC2";
        String xmmc3 = "XMMC3";
        String xmmc4 = "XMMC4";
        String xmmc5 = "XMMC5";
        String xmmc6 = "XMMC6";
        String xmmc7 = "XMMC7";
        String xmmc8 = "XMMC8";
        String xmmc9 = "XMMC9";
        if (!list.isEmpty()) {
            if (list.get(0).get(xmmc2) == null && list.size() > 1) {
                for (int i = 0; i < list.size(); i++) {
                    for (int j = i + 1; j < list.size(); j++) {
                        if (list.get(j).get(xmmc2) != null && j > i) {
                            Map map = list.get(i);
                            map.put(xmmc2, list.get(j).get(xmmc2).toString());
                            list.set(i, map);
                            map = list.get(j);
                            map.put(xmmc2, null);
                            list.set(j, map);
                            i++;
                        }
                    }
                }
            }

            if (list.get(0).get(xmmc3) == null && list.size() > 1) {
                for (int i = 0; i < list.size(); i++) {
                    for (int j = i + 1; j < list.size(); j++) {
                        if (list.get(j).get(xmmc3) != null && j > i) {
                            Map map = list.get(i);
                            map.put(xmmc3, list.get(j).get(xmmc3).toString());
                            list.set(i, map);
                            map = list.get(j);
                            map.put(xmmc3, null);
                            list.set(j, map);
                            i++;
                        }
                    }
                }
            }

            if (list.get(0).get(xmmc4) == null && list.size() > 1) {
                for (int i = 0; i < list.size(); i++) {
                    for (int j = i + 1; j < list.size(); j++) {
                        if (list.get(j).get(xmmc4) != null && j > i) {
                            Map map = list.get(i);
                            map.put(xmmc4, list.get(j).get(xmmc4).toString());
                            list.set(i, map);
                            map = list.get(j);
                            map.put(xmmc4, null);
                            list.set(j, map);
                            i++;
                        }
                    }
                }
            }

            if (list.get(0).get(xmmc5) == null && list.size() > 1) {
                for (int i = 0; i < list.size(); i++) {
                    for (int j = i + 1; j < list.size(); j++) {
                        if (list.get(j).get(xmmc5) != null && j > i) {
                            Map map = list.get(i);
                            map.put(xmmc5, list.get(j).get(xmmc5).toString());
                            list.set(i, map);
                            map = list.get(j);
                            map.put(xmmc5, null);
                            list.set(j, map);
                            i++;
                        }
                    }
                }
            }

            if (list.get(0).get(xmmc6) == null && list.size() > 1) {
                for (int i = 0; i < list.size(); i++) {
                    for (int j = i + 1; j < list.size(); j++) {
                        if (list.get(j).get(xmmc6) != null && j > i) {
                            Map map = list.get(i);
                            map.put(xmmc6, list.get(j).get(xmmc6).toString());
                            list.set(i, map);
                            map = list.get(j);
                            map.put(xmmc6, null);
                            list.set(j, map);
                            i++;
                        }
                    }
                }
            }

            if (list.get(0).get(xmmc7) == null && list.size() > 1) {
                for (int i = 0; i < list.size(); i++) {
                    for (int j = i + 1; j < list.size(); j++) {
                        if (list.get(j).get(xmmc7) != null && j > i) {
                            Map map = list.get(i);
                            map.put(xmmc7, list.get(j).get(xmmc7).toString());
                            list.set(i, map);
                            map = list.get(j);
                            map.put(xmmc7, null);
                            list.set(j, map);
                            i++;
                        }
                    }
                }
            }

            if (list.get(0).get(xmmc8) == null && list.size() > 1) {
                for (int i = 0; i < list.size(); i++) {
                    for (int j = i + 1; j < list.size(); j++) {
                        if (list.get(j).get(xmmc8) != null && j > i) {
                            Map map = list.get(i);
                            map.put(xmmc8, list.get(j).get(xmmc8).toString());
                            list.set(i, map);
                            map = list.get(j);
                            map.put(xmmc8, null);
                            list.set(j, map);
                            i++;
                        }
                    }
                }
            }

            if (list.get(0).get(xmmc9) == null && list.size() > 1) {
                for (int i = 0; i < list.size(); i++) {
                    for (int j = i + 1; j < list.size(); j++) {
                        if (list.get(j).get(xmmc9) != null && j > i) {
                            Map map = list.get(i);
                            map.put(xmmc9, list.get(j).get(xmmc9).toString());
                            list.set(i, map);
                            map = list.get(j);
                            map.put(xmmc9, null);
                            list.set(j, map);
                            i++;
                        }
                    }
                }
            }

            for (int i = 0; i < list.size(); i++) {
                if (list.get(i).get(xmmc1) == null
                        && list.get(i).get(xmmc2) == null
                        && list.get(i).get(xmmc3) == null
                        && list.get(i).get(xmmc4) == null
                        && list.get(i).get(xmmc5) == null
                        && list.get(i).get(xmmc6) == null
                        && list.get(i).get(xmmc7) == null
                        && list.get(i).get(xmmc8) == null
                        && list.get(i).get(xmmc9) == null) {
                    list.remove(i);
                    i--;
                }
            }
            for (int i = 0; i < list.size(); i++) {
                Map map = list.get(i);
                map.put("ID", i + 1);
                list.set(i, map);
            }
            int no1 = 0;
            int no2 = 0;
            int no3 = 0;
            int no4 = 0;
            int no5 = 0;
            int no6 = 0;
            int no7 = 0;
            int no8 = 0;
            int no9 = 0;
            for (int i = 0; i < list.size(); i++) {
                if (list.get(i).get(xmmc1) != null) {
                    no1++;
                }
                if (list.get(i).get(xmmc2) != null) {
                    no2++;
                }
                if (list.get(i).get(xmmc3) != null) {
                    no3++;
                }
                if (list.get(i).get(xmmc4) != null) {
                    no4++;
                }
                if (list.get(i).get(xmmc5) != null) {
                    no5++;
                }
                if (list.get(i).get(xmmc6) != null) {
                    no6++;
                }
                if (list.get(i).get(xmmc7) != null) {
                    no7++;
                }
                if (list.get(i).get(xmmc8) != null) {
                    no8++;
                }
                if (list.get(i).get(xmmc9) != null) {
                    no9++;
                }
            }
            Map map = new HashMap();
            map.put("ID", "数量合计");
            map.put(xmmc1, no1);
            map.put(xmmc2, no2);
            map.put(xmmc3, no3);
            map.put(xmmc4, no4);
            map.put(xmmc5, no5);
            map.put(xmmc6, no6);
            map.put(xmmc7, no7);
            map.put(xmmc8, no8);
            map.put(xmmc9, no9);
            list.add(map);
        }

        return list;
    }

    /**
     * 取得当前Session.
     */
    protected final Session getSession() {
        return SessionFactoryUtils.getSession(sessionFactory, true);
    }

    /**
     * 取得sessionFactory.
     */
    public SessionFactory getSessionFactory() {
        return sessionFactory;
    }

    /**
     * 采用@Autowired按类型注入SessionFactory, 当有多个SesionFactory的时候Override本函数.
     */
    @Autowired
    public void setSessionFactory(final SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
        afterSessionFactorySet();
    }

    protected void afterSessionFactorySet() {
        //don't know why this method has empty body
    }

    public String getTab() {
        return "kgda";
    }
}
