package com.gtis.archive.web.admin.xian;

import com.gtis.archive.util.Struts2Utils;
import com.opensymphony.xwork2.ActionSupport;
import org.apache.commons.lang.StringUtils;

import org.hibernate.Criteria;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.orm.hibernate3.SessionFactoryUtils;

import java.util.List;
import java.util.Map;

public class DlAction extends ActionSupport {
    private static final Logger logger = LoggerFactory.getLogger(DlAction.class);
    private static final long serialVersionUID = -5158668525677437759L;
    private List<Map> page;
    private String name;
    private Integer index = 0;
    private int size = 30;

    protected SessionFactory sessionFactory;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<Map> getPage() {
        return page;
    }

    public Integer getIndex() {
        return index;
    }

    public void setIndex(Integer index) {
        this.index = index;
    }

    public int getSize() {
        return size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    @Override
    public String execute() throws Exception {
        page = doGet();
        return SUCCESS;
    }

    public String dlExcel() throws Exception {
        page = doGet();
        Struts2Utils.setFileDownloadHeader("下载日志.xls","xls");
        return "dlexcel";
    }

    @SuppressWarnings("unchecked")
    public List<Map> doGet() throws Exception {
        String sql = "select t.*,t1.update_time,t1.Name from t_downloadlog t,t_original t1 Where t.original_id=t1.Id";
        if (StringUtils.isNotBlank(name)) {
            sql += " and t1.Name like '%" + name + "%'";
        }
        sql +=" order by t.id desc";
        logger.info(sql);
        SQLQuery query = getSession().createSQLQuery(sql);
        return (List<Map>) query.setResultTransformer(Criteria.ALIAS_TO_ENTITY_MAP).list();
    }

    protected final Session getSession() throws DataAccessResourceFailureException{
        return SessionFactoryUtils.getSession(sessionFactory, true);
    }

    @Autowired
    public void setSessionFactory(final SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public String getTab() {
        return "dl";
    }
}
