package com.gtis.archive.web.admin;

import com.gtis.archive.core.Model;
import com.gtis.archive.core.ModelService;
import com.gtis.archive.entity.Archive;
import com.gtis.archive.entity.Document;
import com.gtis.archive.util.Struts2Utils;
import com.gtis.web.SessionUtil;
import com.opensymphony.xwork2.ActionSupport;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.orm.hibernate3.SessionFactoryUtils;

import javax.persistence.Table;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 12-5-23
 */
public class SystemAction extends ActionSupport {
    private static final Logger LOG = LoggerFactory.getLogger(SystemAction.class);
    private static final long serialVersionUID = 1054771129120378245L;

    @Autowired
    private SessionFactory sessionFactory;
    private Session session;

    @Autowired
    private ModelService modelService;

    private String userName;

    public String getUserName() {
        return SessionUtil.getCurrentUser().getUsername();
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Override
    public String execute() throws Exception {
        return super.execute();
    }

    @SuppressWarnings("unchecked")
    public String update0() throws Exception {
        String selectIdSql = "' where id in (select id from ";
        session = SessionFactoryUtils.getSession(sessionFactory, true);
        Transaction tx = session.beginTransaction();
        tryExecSql("alter table t_archive add model_name varchar2(10)");
        tryExecSql("alter table t_document add model_name varchar2(10)");
        tryExecSql("alter table t_original add owner_model_name varchar2(10)");
        for (Model model : modelService.getModels()) {
            String modelName = model.getName();
            String tableName = (String) AnnotationUtils.getValue(modelService.getClass(modelName).getAnnotation(Table.class), "name");
            if (Archive.MODEL_NAME.equals(model.getParentName())) {
                tryExecSql("update t_archive set model_name='" + modelName + selectIdSql + tableName + ")");
                tryExecSql("update t_archive set model_name='" + modelName + selectIdSql + tableName + ")");
                tryExecSql("update t_original set owner_model_name='" + modelName + "' where owner_id in (select id from " + tableName + ")");
            } else if (Document.MODEL_NAME.equals(model.getParentName())) {
                tryExecSql("update t_document set model_name='" + modelName + selectIdSql + tableName + ")");
                tryExecSql("update t_original set owner_model_name='" + modelName + "' where owner_id in (select id from " + tableName + ")");
            }
        }
        tx.commit();
        Struts2Utils.renderHtml("升级成功!");
        return null;
    }

    public String getTab() {
        return "system";
    }

    private void tryExecSql(String sql) {
        try {
            session.createSQLQuery(sql).executeUpdate();
        } catch (HibernateException e) {
            LOG.error("run sql [" + sql + "] error [" + e.getMessage() + "]",e);
        }
    }
}
