package com.gtis.archive.web.admin;

import com.gtis.archive.Constants;
import com.gtis.archive.Switch;
import com.gtis.archive.core.dict.DictService;
import com.gtis.archive.core.dict.Item;
import com.gtis.archive.core.environment.EnvHolder;
import com.gtis.archive.entity.Permission;
import com.gtis.archive.service.ExtTreeService;
import com.gtis.archive.service.PermissionService;
import com.gtis.archive.util.ServletUtils;
import com.gtis.archive.util.Struts2Utils;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.vo.PfRoleVo;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.web.SessionUtil;
import com.opensymphony.xwork2.ActionSupport;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.json.JSONUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import java.util.*;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oznyang@163.com">Administrator</a>
 * @version V1.0, 2010-12-9
 */
public class PermissionAction extends ActionSupport {
    private static final Logger logger = LoggerFactory.getLogger(PermissionAction.class);
    private static final long serialVersionUID = -3107528495499282167L;
    private String childrenString = "children";
    private String checkedString = "checked";
    private String iconClsString = "iconCls";
    private String folderString = "folder";
    @Autowired
    private PermissionService permissionService;
    @Autowired
    private ExtTreeService treeService;
    @Autowired
    private SysUserService userService;
    @Autowired
    private DictService dictService;

    private String userName;
    private List<PfRoleVo> roles;
    private List<PfUserVo> userList;
    private String treeJson;
    // 角色的id
    private String roleId;
    // 角色名
    private String roleName;
    //用户id
    private String userId;
    //用户id集合
    private String[] userIds;
    // 业务的id
    private String resId;
    // 已选择的权限
    private String[] checked;
    // 未选择的系统权限
    private String[] unChecked;
    // 选中的系统系统权限
    private String[] sysChecked;
    // 未选中的系统权限
    private String[] sysUnchecked;
    // 选中的单位代码
    private String[] dwdmChecked;
    // 未选中的单位代码
    private String[] dwdmUnchecked;
    // 选中的年度
    private String[] ndChecked;
    // 未选中的年度
    private String[] ndUnchecked;

    private Set<Permission> permissions = new HashSet<Permission>();
    private List<Item> operations; //item存放所有定义的操作项

    @SuppressWarnings("unchecked")
    private List<Map<String, Object>> rewrite(List<Map<String, Object>> tree) {
        try {
            if (tree != null) {
                for (Map<String, Object> map : tree) {
                    rewrite((List<Map<String, Object>>) map.get(childrenString));
                    String id = (String) map.get("id");
                    List<Map<String, Object>> opts = new ArrayList<Map<String, Object>>();
                    for (Item item : operations) {
                        Map<String, Object> op = new HashMap<String, Object>();
                        op.put("name", id + "_" + item.getName());
                        op.put("text", item.getValue());
                        op.put(checkedString, permissions.contains(new Permission(id, roleId, item.getName())));
                        opts.add(op);
                    }
                    map.put("data", opts);
                }
            }
        } catch (Exception e) {
            logger.error(e.getMessage());
        }
        return tree;
    }

    public String getUserName() {
        return SessionUtil.getCurrentUser().getUsername();
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setUnChecked(String[] unChecked) {
        this.unChecked = unChecked;
    }

    public void setChecked(String[] checked) {
        this.checked = checked;
    }

    public void setDwdmChecked(String[] dwdmChecked) {
        this.dwdmChecked = dwdmChecked;
    }

    public void setDwdmUnchecked(String[] dwdmUnchecked) {
        this.dwdmUnchecked = dwdmUnchecked;
    }

    public String[] getNdChecked() {
        return ndChecked;
    }

    public void setNdChecked(String[] ndChecked) {
        this.ndChecked = ndChecked;
    }

    public String[] getNdUnchecked() {
        return ndUnchecked;
    }

    public void setNdUnchecked(String[] ndUnchecked) {
        this.ndUnchecked = ndUnchecked;
    }

    public String getRoleId() {
        return roleId;
    }

    public void setRoleId(String roleId) {
        this.roleId = roleId;
    }

    public String getRoleName() {
        return roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public List<PfRoleVo> getRoles() {
        return roles;
    }

    public String getTreeJson() {
        return treeJson;
    }

    public String getResId() {
        return resId;
    }

    public void setResId(String resId) {
        this.resId = resId;
    }

    public void setSysChecked(String[] sysChecked) {
        this.sysChecked = sysChecked;
    }

    public void setSysUnchecked(String[] sysUnchecked) {
        this.sysUnchecked = sysUnchecked;
    }

    public List<PfUserVo> getUsers() {
        return userList;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String[] getUserIds() {
        return userIds;
    }

    public void setUserIds(String[] userIds) {
        this.userIds = userIds;
    }

    @Override
    public String execute() throws Exception {
        userName = SessionUtil.getCurrentUser().getUsername();
        return SUCCESS;
    }

    public String tree() throws Exception {
        permissions.addAll(permissionService.getPermissions(null, roleId));
        operations = dictService.getItems(Permission.OPERATION_DICT);
        List<Map<String, Object>> tree = EnvHolder.isEnable(Switch.ZHEN_JINAG) ? treeService.getAjhTree(null, Constants.MODEL_ROOT) : treeService.getTree(null, Constants.MODEL_ROOT);
        if (tree != null) {
            tree.add(0, getSysFunctionNode());
            treeJson = JSONUtil.serialize(tree);
        } else {
            logger.error("获取操作权限失败!");
        }
        return "tree";
    }

    private Map<String, Object> getSysFunctionNode() {
        List<Item> sysFunction = dictService.getItems(Permission.SYS_FUNCTION_DICT);
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("id", "sys");
        map.put("text", "系统功能");
        map.put("leaf", true);
        map.put(iconClsString, "node");
        List<Map<String, Object>> functions = new ArrayList<Map<String, Object>>();
        for (Item item : sysFunction) {
            Map<String, Object> op = new HashMap<String, Object>();
            op.put("name", "sys_" + item.getName());
            op.put("text", item.getValue());
            op.put(checkedString, permissions.contains(new Permission("sys", roleId, item.getName())));
            functions.add(op);
        }
        map.put("data", functions);
        return map;
    }

    public String save() throws Exception {
        if (checked != null && StringUtils.isNotBlank(checked[0])) {
            Permission[] ps = new Permission[checked.length];
            for (int i = 0, len = checked.length; i < len; i++) {
                ps[i] = toPermission(checked[i], roleId);
            }
            permissionService.grant(ps);
        }
        if (unChecked != null && StringUtils.isNotBlank(unChecked[0])) {
            Permission[] ps = new Permission[unChecked.length];
            for (int i = 0, len = unChecked.length; i < len; i++) {
                ps[i] = toPermission(unChecked[i], roleId);
            }
            permissionService.revoke(ps);
        }
        return null;
    }

    private static Permission toPermission(String s, String roleId) {
        String[] ss = s.split("_");
        return new Permission(ss[0], roleId, ss[1]);
    }

    public String getTab() {
        if (!EnvHolder.isEnable(Switch.isNewPermission)) {
            return "permission";
        }else {
            return "permissionNew";
        }
    }

    /**
     * 获取角色列表
     */
    public void getRoleList() {
        List root = new ArrayList();
        Map rootMap = new HashMap();
        List roleList = new ArrayList();
        List detailRoot = new ArrayList();
        rootMap.put("text", "角色列表");
        rootMap.put("id", roleId);
        rootMap.put(iconClsString, folderString);
        rootMap.put(childrenString, detailRoot);
        root.add(rootMap);
        roles = userService.getRoleList();
        for (PfRoleVo role : roles) {
            Map roleMap = new HashMap();
            roleMap.put("text", role.getRoleName());
            roleMap.put("id", role.getRoleId());
            roleMap.put(iconClsString, "human");
            roleMap.put("leaf", true);
            roleMap.put(checkedString, false);
            roleList.add(roleMap);

        }
        rootMap.put(childrenString, roleList);
        detailRoot.add(rootMap);
        Struts2Utils.renderJson(root);
    }

    /**
     * 获取业务分类
     */
    public void getTrees() {
        Struts2Utils.renderJson(treeService.getTreeByCheck(null, Constants.MODEL_ROOT));
    }

    /**
     * 从json文件获取操作权限列表
     */
    public void getPermissions() {
        String location = ServletActionContext.getRequest().getSession().getServletContext().getRealPath("/tpls/permission.json");
        Struts2Utils.render(ServletUtils.JSON_TYPE, permissionService.getPermissionJson(location));
    }

    /**
     * 获取系统的功能列表
     */
    public void getSysFunctions() {
        List root = new ArrayList();
        List<Item> sysFunctions = dictService.getItems(Permission.SYS_FUNCTION_DICT);
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("id", "sys");
        map.put("text", "系统功能");
        map.put("cls", folderString);
        map.put(checkedString, false);
        List<Map<String, Object>> functions = new ArrayList<Map<String, Object>>();
        for (Item item : sysFunctions) {
            Map<String, Object> op = new HashMap<String, Object>();
            op.put("id", item.getName());
            op.put("text", item.getValue());
            op.put("leaf", true);
            op.put(checkedString, false);
            functions.add(op);
        }
        map.put(childrenString, functions);
        root.add(map);
        Struts2Utils.renderJson(root);
    }

    /**
     * 获取所有的单位
     */
    public void getDwdms() {
        List root = new ArrayList();
        List<Item> items = dictService.getItems("dwdm");
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("id", "dwdms");
        map.put("text", "单位列表");
        map.put("cls", folderString);
        map.put("leaf", false);
        map.put(checkedString, false);
        map.put("expanded", true);
        List<Map<String, Object>> dwdms = new ArrayList<Map<String, Object>>();

        for (Item item : items) {
            Map<String, Object> dwdm = new HashMap<String, Object>();
            dwdm.put("id", item.getValue());
            dwdm.put("text", item.getName());
            dwdm.put("leaf", true);
            dwdm.put(checkedString, false);
            dwdms.add(dwdm);
        }
        map.put(childrenString, dwdms);
        root.add(map);
        Struts2Utils.renderJson(root);
    }

    /**
     * 获取所有的年度
     */
    public void getNds() {
        List root = new ArrayList();
        List<Item> items = dictService.getItems("nd");
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("id", "nd");
        map.put("text", "年度列表");
        map.put("cls", folderString);
        map.put(checkedString, false);
        map.put("expanded", true);
        List<Map<String, Object>> nds = new ArrayList<Map<String, Object>>();

        for (Item item : items) {
            Map<String, Object> nd = new HashMap<String, Object>();
            nd.put("id", item.getValue());
            nd.put("text", item.getName());
            nd.put("leaf", true);
            nd.put(checkedString, false);
            nds.add(nd);
        }
        map.put(childrenString, nds);
        root.add(map);
        Struts2Utils.renderJson(root);
    }

    /**
     * 通过角色id获取基本信息
     */
    public void getBaseInfo() {
        List<Permission> permissions = permissionService.getPermissions(null, roleId);
        Set<String> strSet = new HashSet<String>();
        StringBuilder sysStr = new StringBuilder();
        String resStr;
        Map map = new HashMap();
        for (Permission permission : permissions) {
            if ("sys".equals(permission.getResourceId())) {
                sysStr.append(permission.getOperation());
                sysStr.append(",");
            }
            strSet.add(permission.getResourceId());
        }
        resStr = trimCollectionBlank(strSet);
        map.put("sysStr", StringUtils.isBlank(sysStr.toString()) ? "none" : sysStr.toString().substring(0, sysStr.toString().length() - 1));
        map.put("modelStr", StringUtils.isBlank(resStr) ? "none" : resStr);
        Struts2Utils.renderJson(map);
    }

    /**
     * 获取某一业务的具体信息
     */
    public void getModelInfo() {
        List<Permission> permissions = null;
        String operationStr;
        String dwdmStr;
        String ndStr;
        if (StringUtils.isNotBlank(roleId)) {
            permissions = permissionService.getPermissions(resId, roleId);
        }

        if (permissions == null || permissions.isEmpty()) {
            return;
        }

        Map<String, String> map = new HashMap<String, String>();
        List<String> operations = new ArrayList<String>();
        Set<String> dwdms = new HashSet<String>();
        Set<String> nds = new HashSet<String>();
        for (Permission permission : permissions) {
            operations.add(permission.getOperation());
            if ("dwdm".equals(permission.getOperation())) {
                dwdms.add(permission.getDwdm());
            }
            if ("nd".equals(permission.getOperation())) {
                nds.add(permission.getDwdm());
            }
        }
        operationStr = trimCollectionBlank(operations);
        dwdmStr = trimCollectionBlank(dwdms);
        ndStr = trimCollectionBlank(nds);
        map.put("operationStr", StringUtils.isBlank(operationStr) ? "none" : operationStr);
        map.put("dwdmStr", StringUtils.isBlank(dwdmStr) ? "none" : dwdmStr);
        map.put("ndStr", StringUtils.isBlank(ndStr) ? "none" : ndStr);
        Struts2Utils.renderJson(map);
    }

    /**
     * 保存权限
     */
    public String savePermissions() throws Exception {
        List<Permission> grants = new ArrayList<Permission>();
        List<Permission> revokes = new ArrayList<Permission>();

        if (checked != null && StringUtils.isNotBlank(checked[0])) {
            for (String perm : checked) {
                grants.add(toOpPermission(perm));
            }
        }

        if (sysChecked != null && StringUtils.isNotBlank(sysChecked[0])) {
            for (String s : sysChecked) {
                grants.add(toSysPermission(s));
            }
        }

        if (dwdmChecked != null && StringUtils.isNotBlank(dwdmChecked[0])) {
            for (String s : dwdmChecked) {
                grants.add(toDwdmPermission(s));
            }
        }

        if (ndChecked != null && StringUtils.isNotBlank(ndChecked[0])) {
            for (String s : ndChecked) {
                grants.add(toDwdmPermission(s));
            }
        }

        permissionService.grant(grants);

        if (unChecked != null && StringUtils.isNotBlank(unChecked[0])) {
            for (String unPerm : unChecked) {
                revokes.add(toOpPermission(unPerm));
            }
        }

        if (sysUnchecked != null && StringUtils.isNotBlank(sysUnchecked[0])) {
            for (String s : sysUnchecked) {
                revokes.add(toSysPermission(s));
            }
        }

        if (dwdmUnchecked != null && StringUtils.isNotBlank(dwdmUnchecked[0])) {
            for (String s : dwdmUnchecked) {
                revokes.add(toDwdmPermission(s));
            }
        }

        if (ndUnchecked != null && StringUtils.isNotBlank(ndUnchecked[0])) {
            for (String s : ndUnchecked) {
                revokes.add(toNdPermission(s));
            }
        }
        permissionService.revoke(revokes);

        return SUCCESS;
    }


    public void getUserDwdm() {
        String s = SessionUtil.getCurrentUser().getRegionCode();
        Map map = new HashMap();
        map.put("dwdm", s);
        Struts2Utils.renderJson(map);
    }

    /**
     * 去掉collection中的空格o
     *
     * @param collection
     * @return
     */
    private String trimCollectionBlank(Collection collection) {
        String str = null;
        if (!collection.isEmpty()) {
            str = collection.toString().replace(" ", "");
            str = str.substring(1, str.length() - 1);
        }
        return str;
    }

    /**
     * 转为系统权限
     *
     * @param s
     * @return 系统权限列表
     */
    private static Permission toSysPermission(String s) {
        String[] ss = s.split("_");

        return new Permission(ss[0], ss[1], ss[2]);
    }

    /**
     * 将字符串转换为业务操作权限
     *
     * @param s
     * @return 操作权限
     */
    private static Permission toOpPermission(String s) {
        String[] ss = s.split("_");
        return new Permission(ss[1], ss[0], ss[2]);
    }

    /**
     * 将字符串转换为单位代码权限
     *
     * @param s
     * @return
     */
    private static Permission toDwdmPermission(String s) {
        String[] ss = s.split("_");
        return new Permission(ss[1], ss[0], ss[2], ss[3]);
    }

    /**
     * 将字符串转换为年度权限
     *
     * @param s
     * @return
     */
    private static Permission toNdPermission(String s) {
        String[] ss = s.split("_");
        return new Permission(ss[1], ss[0], ss[2], ss[3]);
    }

    public String getNew(){
        userName = SessionUtil.getCurrentUser().getUsername();
        return "new";
    }

//================================= 新版权限控制 =========================================
    /**
     * 获取平台库用户id列表
     */
    public void getUserList() {
        List root = new ArrayList();
        Map rootMap = new HashMap();
        List roleList = new ArrayList();
        List detailRoot = new ArrayList();
        rootMap.put("text", "用户列表");
        rootMap.put("id", userId);
        rootMap.put(iconClsString, folderString);
        rootMap.put(childrenString, detailRoot);
        rootMap.put("expended", true);
        root.add(rootMap);
        if (StringUtils.isEmpty(roleName)) {
            userList = userService.getAllUsers();
        } else {
            userList = userService.getUserVoListByUserNameFuzzy(roleName);
        }
        for (PfUserVo user : userList) {
            Map roleMap = new HashMap();
            roleMap.put("text", user.getUserName());
            roleMap.put("id", user.getUserId());
            roleMap.put(iconClsString, "human");
            roleMap.put("leaf", true);
            roleMap.put(checkedString, false);
            roleList.add(roleMap);
        }
        rootMap.put(childrenString, roleList);
        detailRoot.add(rootMap);
        Struts2Utils.renderJson(root);
    }

    /**
     * 获取业务库用户列表
     */
    public void getAccessUser() {
        List root = new ArrayList();
        Map rootMap = new HashMap();
        List roleList = new ArrayList();
        List detailRoot = new ArrayList();
        rootMap.put("text", "用户列表");
        rootMap.put("id", userId);
        rootMap.put(iconClsString, folderString);
        rootMap.put(childrenString, detailRoot);
        rootMap.put("expended", true);
        root.add(rootMap);
        List<Permission> permissions = permissionService.getUsers();
        for (Permission user : permissions) {
            Map roleMap = new HashMap();
            roleMap.put("text", user.getUserName());
            roleMap.put("id", user.getUserId());
            roleMap.put(iconClsString, "human");
            roleMap.put("leaf", true);
            roleMap.put(checkedString, false);
            roleList.add(roleMap);
        }
        rootMap.put(childrenString, roleList);
        detailRoot.add(rootMap);
        Struts2Utils.renderJson(root);
    }

    /**
     * 通过用户id获取基本信息
     */
    public void getUserPerssion() {
        List<Permission> permissions = permissionService.getUserPermissions(null, userId);
        Set<String> strSet = new HashSet<String>();
        StringBuilder sysStr = new StringBuilder();
        String resStr;
        String operationStr;
        String dwdmStr;
        String ndStr;
        List<String> operations = new ArrayList<String>();
        Set<String> dwdms = new HashSet<String>();
        Set<String> nds = new HashSet<String>();
        Map map = new HashMap();
        for (Permission permission : permissions) {
            if ("sys".equals(permission.getResourceId())) {
                sysStr.append(permission.getOperation());
                sysStr.append(",");
            }
            strSet.add(permission.getResourceId());
        }
        resStr = trimCollectionBlank(strSet);
        map.put("sysStr", StringUtils.isBlank(sysStr.toString()) ? "none" : sysStr.toString().substring(0, sysStr.toString().length() - 1));
        map.put("modelStr", StringUtils.isBlank(resStr) ? "none" : resStr);
        permissions = permissionService.getUserPermissions(resId, userId);
        for (Permission permission : permissions) {
            operations.add(permission.getOperation());
            if ("dwdm".equals(permission.getOperation())) {
                dwdms.add(permission.getDwdm());
            }
            if ("nd".equals(permission.getOperation())) {
                nds.add(permission.getDwdm());
            }
        }
        operationStr = trimCollectionBlank(operations);
        dwdmStr = trimCollectionBlank(dwdms);
        ndStr = trimCollectionBlank(nds);
        map.put("operationStr", StringUtils.isBlank(operationStr) ? "none" : operationStr);
        map.put("dwdmStr", StringUtils.isBlank(dwdmStr) ? "none" : dwdmStr);
        map.put("ndStr", StringUtils.isBlank(ndStr) ? "none" : ndStr);
        Struts2Utils.renderJson(map);
    }

    /**
     * 获取某一业务的具体信息
     */
    public void getModelInfoNew() {
        List<Permission> permissions = null;
        String operationStr;
        String dwdmStr;
        String ndStr;
        if (StringUtils.isNotBlank(userId)) {
            permissions = permissionService.getUserPermissions(resId, userId);
        }
        if (permissions == null || permissions.isEmpty()) {
            return;
        }
        Map<String, String> map = new HashMap<String, String>();
        List<String> operations = new ArrayList<String>();
        Set<String> dwdms = new HashSet<String>();
        Set<String> nds = new HashSet<String>();
        for (Permission permission : permissions) {
            operations.add(permission.getOperation());
            if ("dwdm".equals(permission.getOperation())) {
                dwdms.add(permission.getDwdm());
            }
            if ("nd".equals(permission.getOperation())) {
                nds.add(permission.getDwdm());
            }
        }
        operationStr = trimCollectionBlank(operations);
        dwdmStr = trimCollectionBlank(dwdms);
        ndStr = trimCollectionBlank(nds);
        map.put("operationStr", StringUtils.isBlank(operationStr) ? "none" : operationStr);
        map.put("dwdmStr", StringUtils.isBlank(dwdmStr) ? "none" : dwdmStr);
        map.put("ndStr", StringUtils.isBlank(ndStr) ? "none" : ndStr);
        Struts2Utils.renderJson(map);
    }

    public Set<String> dwdms(Permission permission){
        Set<String> dwdms = new HashSet<String>();
        if ("dwdm".equals(permission.getOperation())) {
            dwdms.add(permission.getDwdm());
        }
        return dwdms;
    }

    public Set<String> nds(Permission permission){
        Set<String> nds = new HashSet<String>();
        if ("dwdm".equals(permission.getOperation())) {
            nds.add(permission.getDwdm());
        }
        return nds;
    }

    /**
     * 保存权限
     */
    public String savePerm() throws Exception {
        remove(); //删除原权限
        List<Permission> grants = new ArrayList<Permission>();
        if (checked != null && StringUtils.isNotBlank(checked[0])) {
            for (String perm : checked) {
                grants.add(toOpPermissionNew(perm));
            }
        }
        if (sysChecked != null && StringUtils.isNotBlank(sysChecked[0])) {
            for (String s : sysChecked) {
                grants.add(toSysPermissionNew(s));
            }
        }
        if (dwdmChecked != null && StringUtils.isNotBlank(dwdmChecked[0])) {
            for (String s : dwdmChecked) {
                grants.add(toDwdmPermissionNew(s));
            }
        }
        if (ndChecked != null && StringUtils.isNotBlank(ndChecked[0])) {
            for (String s : ndChecked) {
                grants.add(toDwdmPermissionNew(s));
            }
        }
        permissionService.grantNew(grants);
        return SUCCESS;
    }

    /**
     * 根据uersId删除权限
     */
    public void remove(){
        for (String user : userIds){
            permissionService.delete(user,resId);
        }
    }

    /**
     * 根据uersId获取用户名
     */
    public String getName(String userId){
        return userService.getUserVo(userId).getUserName();
    }

    /**
     * 转为系统权限
     *
     * @param s
     * @return 系统权限列表
     */
    private Permission toSysPermissionNew(String s) {
        String[] ss = s.split("_");
        String name = getName(ss[1]);
        return new Permission(ss[0], ss[1], ss[2],null, name);
    }

    /**
     * 将字符串转换为业务操作权限
     *
     * @param s
     * @return 操作权限
     */
    private Permission toOpPermissionNew(String s) {
        String[] ss = s.split("_");
        String name = getName(ss[0]);
        return new Permission(ss[1], ss[0], ss[2],null, name);
    }

    /**
     * 将字符串转换为单位代码权限
     *
     * @param s
     * @return
     */
    private Permission toDwdmPermissionNew(String s) {
        String[] ss = s.split("_");
        String name = getName(ss[0]);
        return new Permission(ss[1], ss[0], ss[2], ss[3], name);
    }

}
