package com.gtis.archive.web.admin;

import com.gtis.archive.core.dict.DictService;
import com.gtis.archive.core.dict.Item;
import com.gtis.web.SessionUtil;
import com.opensymphony.xwork2.ActionSupport;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2010-9-1
 */
@Results({@Result(name = "toIndex", location = "item.action?dictName=${dictName}", type = "redirect")})
public class ItemAction extends ActionSupport {
    private static final long serialVersionUID = 3736616155649415355L;
    @Autowired
    private DictService dictService;

    private String dictName;
    private String id;
    private Item item;
    private List<Item> items;
    private String msg;
    private String userName;

    public String getDictName() {
        return dictName;
    }

    public void setDictName(String dictName) {
        this.dictName = dictName;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Item getItem() {
        return item;
    }

    public void setItem(Item item) {
        this.item = item;
    }

    public String getMsg() {
        return msg;
    }

    public String getUserName() {
        return SessionUtil.getCurrentUser().getUsername();
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Override
    public String execute() throws Exception {
        return super.execute();
    }

    public String edit() throws Exception {
        if (item == null) {
            if (StringUtils.isNotBlank(id)) {
                item = dictService.getItem(id);
            } else {
                item = new Item();
            }
        } else {
            if (StringUtils.isBlank(item.getName())) {
                return "edit";
            }
            String dictId = dictService.getDict(dictName).getId();
            item.setDictId(dictId);
            dictService.saveItem(item);
            msg = "successed";
        }
        return "edit";
    }

    public List<Item> getItems() {
        return dictService.getItems(dictName);
    }

    public String getTab() {
        return "dict";
    }

    public String remove() throws Exception {
        dictService.removeItem(id);
        return "toIndex";
    }
}
