package com.gtis.archive.web.admin;

import com.alibaba.fastjson.JSON;
import com.gtis.archive.core.Model;
import com.gtis.archive.core.ModelService;


import com.gtis.archive.entity.DownloadLog;
import com.gtis.archive.entity.Original;
import com.gtis.archive.service.ArchiveService;
import com.gtis.archive.service.DownLoadLogService;
import com.gtis.archive.service.OriginalService;

import com.gtis.archive.util.Struts2Utils;
import com.gtis.common.Page;
import com.gtis.plat.service.SysUserService;
import com.gtis.web.SessionUtil;
import com.opensymphony.xwork2.ActionSupport;
import org.hibernate.criterion.Order;
import org.springframework.beans.factory.annotation.Autowired;


import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by admin on 2018/3/14.
 */
public class DownloadlogAction extends ActionSupport {

    @Autowired
    private DownLoadLogService downLoadLogService;

    @Autowired
    private ModelService modelService;

    @Autowired
    private SysUserService userService;

    @Autowired
    private OriginalService originalService;

    @Autowired
    private ArchiveService archiveService;

    private List<DownloadLog> actionList;

    private int start = 0;

    private int limit = 30;

    private String msg;

    private DownloadLog downloadLog;

    private Map<String, String> modelsMap;

    private String id;

    private String userName;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getUserName() {
        return SessionUtil.getCurrentUser().getUsername();
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public List<DownloadLog> getActionList() {
        Order[] orders = new Order[3];
        orders[0] = Order.asc("dwdm");
        orders[1] = Order.asc("modelName");
        orders[2] = Order.asc("mlh");
        Page<DownloadLog> list = downLoadLogService.getDllRanges(start,limit,orders);
        actionList = list.getItems();
        return actionList;
    }

    public void setActionList(List<DownloadLog> actionList) {
        this.actionList = actionList;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public String getMsg(){
        return this.msg;
    }

    public String getTab(){
        return "downloadlog";
    }

    public DownloadLog getDownloadLog() {
        return downloadLog;
    }

    public void setDownloadLog(DownloadLog downloadLog) {
        this.downloadLog = downloadLog;
    }

    public List<String> getModels(){
        List<String> list=new ArrayList<String>();
        for (Model model:modelService.getModels()){
            list.add(model.getName());
        }
        return list;
    }

    public String getModelsMap() {
        return JSON.toJSON(modelsMap).toString();
    }

    @Override
    public String execute() throws Exception {
        modelsMap=new HashMap<String, String>();
        for (Model model : modelService.getModels()) {
            modelsMap.put(model.getName(),model.getTitle());
        }
        return SUCCESS;
    }

    public void list() {
        Order[] orders = new Order[3];
        orders[0] = Order.desc("downloadTime");
        orders[1] = Order.asc("id");
        orders[2] = Order.asc("action");
        try {
            Page<DownloadLog> page = downLoadLogService.getDllRanges(start,limit,orders);

            for(DownloadLog downloadLog: page.getItems()){
                Original original = originalService.getOriginal(downloadLog.getOriginalId());
                if(original != null) {
                    downloadLog.setName(original.getName());
                    downloadLog.setOwnerId(original.getOwnerId());
                    downloadLog.setOwnerModelName(original.getOwnerModelName());
                }
            }

            Struts2Utils.renderJson(page);
        } catch (Exception ex) {
            Struts2Utils.renderJson(new Page());
        }
    }

    public String getDwdm() {
        String dwdm = (String) Struts2Utils.getSessionAttribute("__dwdm");
        if (dwdm == null) {
            dwdm = userService.getUserRegionCode(SessionUtil.getCurrentUserId());
            Struts2Utils.getSession().setAttribute("__dwdm", dwdm);
        }
        return dwdm;
    }
}
