package com.gtis.archive.web.admin;

import com.gtis.archive.core.environment.EnvHolder;
import com.gtis.archive.core.web.BaseModelAction;
import com.gtis.archive.entity.Archive;
import com.gtis.archive.service.GatewayService;
import com.gtis.archive.service.sv.SqlServerServiceImpl;
import com.gtis.common.Page;
import com.opensymphony.xwork2.Action;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import java.util.*;



/**
 * .
 * <p/>
 *
 * @author wangxinyi
 * @version V1.0, 2018-03-08
 */
@Component
public class ConversionAction extends BaseModelAction<Archive> {
    @Autowired
    private SqlServerServiceImpl sqlServerService;
    @Autowired
    private GatewayService gatewayService;
    /**
     * 业务名称
     */
    private String modelName;

    /**
     * 附件下载地址
     */
    private String url;

    @Override
    public String getModelName() {
        return modelName;
    }

    @Override
    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getTab() {
        return "conversion";
    }

    @Override
    public String execute() {
        return Action.SUCCESS;
    }

    public void getArchiveXml(){
        Page<Map<String,Object>> page = new Page<Map<String, Object>>();
        try {
            page = sqlServerService.getPfDate(modelName);
            String s = getXml(page, url, modelName);
            String ss = gatewayService.in(s);

            renderJson(ss);
        }catch (Exception e){
            logger.error("导入数据错误" + e,e);
        }
    }

    public String getXml(Page<Map<String,Object>> page,String url,String modelName){
        StringBuilder xmlnodes = new StringBuilder();
        String fieldString = "</field>\n";
        String urlIdString = "URL_ID";
        xmlnodes.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        xmlnodes.append("<list>\n");
        for (int i = 0; i < page.getItems().size(); i++) {
            Map<String,Object> map = page.getItem(i);
            xmlnodes.append("<archive type='" + modelName + "'>\n");
            xmlnodes.append("<field name='qzh'>" + map.get("QZH") + fieldString);
            xmlnodes.append("<field name='mlh'>" + map.get("MLH") + fieldString);
            xmlnodes.append("<field name='dh'>" + map.get("DH") + fieldString);
            xmlnodes.append("<field name='flh'>" + map.get("FLH") + fieldString);
            xmlnodes.append("<field name='dwdm'>" + map.get("DWDM") + fieldString);
            xmlnodes.append("<field name='bgqx'>" + map.get("BGQX") + fieldString);
            xmlnodes.append("<field name='ajh'>" + map.get("AJH") + fieldString);
            xmlnodes.append("<field name='modelName'>" + modelName + fieldString);
            xmlnodes.append("<field name='nd'>" + map.get("ND") + fieldString);
            xmlnodes.append("<field name='tm'>" + map.get("TM") + fieldString);
            xmlnodes.append("<field name='dz'>" + map.get("DZ") + fieldString);
            xmlnodes.append("<field name='tdmj'>" + map.get("TDMJ") + fieldString);
            xmlnodes.append("<field name='jfr'>" + map.get("JFR") + fieldString);
            xmlnodes.append("<field name='tdyt'>" + map.get("TDYT") + fieldString);
            xmlnodes.append("<field name='proId'>" + map.get("pro_id") + fieldString);
            String urlIds = map.get(urlIdString) != null? map.get(urlIdString).toString():"null";

            if(!"null".equals(urlIds)) {
                String[] urls = urlIds.split(";|；");
                String url1 = "";
                for (String urlId : urls) {
                    url1 = url + urlId;
                    xmlnodes.append("<file url='" + url1 + "'></file>\n");
                }
            }
            Page<Map<String,Object>> pageJn = new Page<Map<String, Object>>();
            pageJn = sqlServerService.getJnDate(modelName);
            for (int n = 0; n < pageJn.getItems().size(); n++) {
                Map<String,Object> mapJn = pageJn.getItem(n);
                xmlnodes.append("<doc>\n");
                xmlnodes.append("<field name='sxh'>" + mapJn.get("sxh") + fieldString);
                xmlnodes.append("<field name='tm'>" + mapJn.get("TM") + fieldString);

                String urlIdJn = map.get(urlIdString) != null? map.get(urlIdString).toString():"null";

                if(!"null".equals(urlIdJn)) {
                    String[] urls = urlIdJn.split(";|；");
                    String url1 = "";
                    for (String urlId : urls) {
                        url1 = url + urlId;
                        xmlnodes.append("<file url='" + url1 + "'></file>\n");
                    }
                }

                xmlnodes.append("</doc>\n");
            }
            xmlnodes.append("</archive>\n");
        }
        xmlnodes.append("</list>\n");

        return xmlnodes.toString();
    }

    /*
     *马鞍山收发文数据 定时任务
     */
    public void getTransmitXml() {
        String judgeMas = EnvHolder.getAppEnv().get("maanshan.enable");
        if (judgeMas.equalsIgnoreCase("true")) {
            Page<Map<String, Object>> page;
            String esql = "SELECT * FROM dbo.Archive where datediff(week,QCRQ,getdate()) = 0";
            try {
                page = sqlServerService.getTransmitDate(esql);
                for (int i = 0; i < page.getItems().size(); i++) {
                    Map<String, Object> map = page.getItem(i);
                    String id = map.get("ID").toString();
                    Archive archive = archiveService.getArchive("Zhda", id);
                    if (archive == null) {
                        String s = gatewayService.getTransmitXmlData(map);
                        String ss = gatewayService.in(s);
                        logger.info(ss);
                        logger.info(map.get("ID").toString() + map.get("TM").toString());
                    }
                }
                logger.error("更新完成");
                logger.error("remove:{}", new Date());
            } catch (Exception e) {
                logger.error("导入数据错误:{}", e.getMessage());
            }
        }
    }
}
