package com.gtis.archive.web.admin;

import com.google.common.collect.Maps;
import com.gtis.archive.core.web.BaseAction;
import com.gtis.archive.entity.ConfigProp;
import com.gtis.archive.service.ConfigPropService;
import com.gtis.archive.util.Struts2Utils;
import com.opensymphony.xwork2.Preparable;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;
import java.util.Map;

/**
 * 配置项的修改和获取
 *
 * @author linlong
 */
public class ConfigPropAction extends BaseAction implements Preparable {

    private List<ConfigProp> list;

    /** 获取前端的改变值的key */
    private String enables;

    private static Map<String, String> map;

    @Autowired
    private ConfigPropService configPropService;

    private String electronicCabinetUrl;

    private String fineReportDirName;

    private String bdcdjMaterialSrc;

    private String classifyViewMode;

    private String dictWikiUrl;

    private String qrCodeFieldName;

    private String indexViewMode;

    private String tddjPath;

    private String ocrUrl;

    private String viewOriginal;

    private String documentPrintCount;

    private String convertToJpg;

    private String previewServerUrl;


    public List<ConfigProp> getList() {
        return list;
    }

    public void setList(List<ConfigProp> list) {
        this.list = list;
    }

    public String getEnables() {
        return enables;
    }

    public void setEnables(String enables) {
        this.enables = enables;
    }

    public String getElectronicCabinetUrl() {
        return electronicCabinetUrl;
    }

    public void setElectronicCabinetUrl(String electronicCabinetUrl) {
        this.electronicCabinetUrl = electronicCabinetUrl;
    }

    public String getFineReportDirName() {
        return fineReportDirName;
    }

    public void setFineReportDirName(String fineReportDirName) {
        this.fineReportDirName = fineReportDirName;
    }

    public String getBdcdjMaterialSrc() {
        return bdcdjMaterialSrc;
    }

    public void setBdcdjMaterialSrc(String bdcdjMaterialSrc) {
        this.bdcdjMaterialSrc = bdcdjMaterialSrc;
    }

    public String getClassifyViewMode() {
        return classifyViewMode;
    }

    public void setClassifyViewMode(String classifyViewMode) {
        this.classifyViewMode = classifyViewMode;
    }

    public String getDictWikiUrl() {
        return dictWikiUrl;
    }

    public void setDictWikiUrl(String dictWikiUrl) {
        this.dictWikiUrl = dictWikiUrl;
    }

    public String getQrCodeFieldName() {
        return qrCodeFieldName;
    }

    public void setQrCodeFieldName(String qrCodeFieldName) {
        this.qrCodeFieldName = qrCodeFieldName;
    }

    public String getIndexViewMode() {
        return indexViewMode;
    }

    public void setIndexViewMode(String indexViewMode) {
        this.indexViewMode = indexViewMode;
    }

    public String getTddjPath() {
        return tddjPath;
    }

    public void setTddjPath(String tddjPath) {
        this.tddjPath = tddjPath;
    }

    public String getOcrUrl() {
        return ocrUrl;
    }

    public void setOcrUrl(String ocrUrl) {
        this.ocrUrl = ocrUrl;
    }

    public String getViewOriginal() {
        return viewOriginal;
    }

    public void setViewOriginal(String viewOriginal) {
        this.viewOriginal = viewOriginal;
    }

    public String getDocumentPrintCount() {
        return documentPrintCount;
    }

    public void setDocumentPrintCount(String documentPrintCount) {
        this.documentPrintCount = documentPrintCount;
    }

    public String getConvertToJpg() {
        return convertToJpg;
    }

    public void setConvertToJpg(String convertToJpg) {
        this.convertToJpg = convertToJpg;
    }

    public String getPreviewServerUrl() {
        return previewServerUrl;
    }

    public void setPreviewServerUrl(String previewServerUrl) {
        this.previewServerUrl = previewServerUrl;
    }

    @Override
    public String execute() throws Exception {
        list = configPropService.getConfigProps();
        return SUCCESS;
    }

    public void save() {
        String msg;
        Map<String, String> responseMsg = Maps.newHashMapWithExpectedSize(4);
        try {
            logger.debug("enables = {}", enables);
            logger.debug("map = {}", map);
            configPropService.updateProps(enables, map);
            msg = "success";
        } catch (Exception e) {
            msg = "failure";
            responseMsg.put("error", e.getMessage());
        }
        responseMsg.put("msg", msg);
        Struts2Utils.renderJson(responseMsg);
    }

    @Override
    public void prepare() throws Exception {
        // 大小是输入值参数的个数
        map = Maps.newLinkedHashMapWithExpectedSize(13);
        map.put("electronicCabinetUrl", electronicCabinetUrl);
        map.put("fineReportDirName", fineReportDirName);
        map.put("bdcdjMaterialSrc", bdcdjMaterialSrc);
        map.put("classifyViewMode", classifyViewMode);
        map.put("dictWikiUrl", dictWikiUrl);
        map.put("qrCodeFieldName", qrCodeFieldName);
        map.put("indexViewMode", indexViewMode);
        map.put("tddjPath", tddjPath);
        map.put("ocrUrl", ocrUrl);
        map.put("viewOriginal", viewOriginal);
        map.put("documentPrintCount", documentPrintCount);
        map.put("convertToJpg", convertToJpg);
        map.put("previewServerUrl", previewServerUrl);
    }
}
