package com.gtis.archive.web.admin;

import com.gtis.archive.Constants;
import com.gtis.archive.Switch;
import com.gtis.archive.core.Field;
import com.gtis.archive.core.Model;
import com.gtis.archive.core.ModelManager;
import com.gtis.archive.core.dict.DictService;
import com.gtis.archive.core.dict.Item;
import com.gtis.archive.core.environment.EnvHolder;
import com.gtis.archive.entity.AjhRange;
import com.gtis.archive.service.AjhRangeService;
import com.gtis.archive.service.ExtTreeService;
import com.gtis.archive.util.Struts2Utils;
import com.gtis.plat.service.SysUserService;
import com.gtis.web.SessionUtil;
import com.opensymphony.xwork2.ActionSupport;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.*;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2010-10-13
 */
@Results({@Result(name = "toList", location = "ajh!list.action?modelName=${modelName}", type = "redirect")})
public class AjhAction extends ActionSupport {
    private static final long serialVersionUID = 7582278548353967361L;
    private String id;
    private String modelName;
    private AjhRange ajhRange;
    private List<AjhRange> ajhRanges;
    private Map<String, Integer> modelsMap;
    private Map<String,String> modelAliasMap;
    private Map<String,String> flMap;
    private String msg;

    private String mlh;
    private String dm;
    private String year;
    private String term;
    private String userName;

    @Autowired
    private ModelManager modelService;

    @Autowired
    private AjhRangeService ajhRangeService;

    @Autowired
    private SysUserService userService;

    @Autowired
    private ExtTreeService treeService;

    @Autowired
    protected DictService dictService;


    public String getMlh() {
        return mlh;
    }

    public void setMlh(String mlh) {
        this.mlh = mlh;
    }

    public String getDm() {
        return dm;
    }

    public void setDm(String dm) {
        this.dm = dm;
    }

    public AjhRange getAjhRange() {
        return ajhRange;
    }

    public void setAjhRange(AjhRange ajhRange) {
        this.ajhRange = ajhRange;
    }

    public List<AjhRange> getAjhRanges() {
        return ajhRanges;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getModelName() {
        return modelName;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public Map<String, Integer> getModelsMap() {
        return modelsMap;
    }
    
    public Map<String,String> getModelAliasMap(){
        return modelAliasMap;
    }

    public Map<String, String> getFlMap() {
        return flMap;
    }

    public String getMsg() {
        return msg;
    }

    public String getYear() {
        return year;
    }

    public void setYear(String year) {
        this.year = year;
    }

    public String getTerm() {
        return term;
    }

    public void setTerm(String term) {
        this.term = term;
    }

    public String getUserName() {
        return SessionUtil.getCurrentUser().getUsername();
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public List<String> getBgqxs() {
        List<Item> items=dictService.getItems(Constants.BGQX);
        List<String> bgqxs=new ArrayList<String>();
        for (Item item:items){
            bgqxs.add(item.getValue());
        }
        return bgqxs;
    }

    public List<Map<String,String>> getJnmllx(){
        List<Map<String,String>> jnmllx = new ArrayList<Map<String,String>>();

        String dictName = "";
        Model model = modelService.getModel(modelName);
        Set<Field> fields = model.getFields();
        for(Field field : fields){
            if("jnmllx".equals(field.getName())){
                dictName = field.getValueDict();
            }
        }
        if(!StringUtils.isBlank(dictName)){
            List<Item> items = dictService.getItems(dictName);
            for (Item item:items){
                Map<String,String> map=new HashMap<String, String>();
                map.put("name",item.getName());
                map.put("value",item.getValue());
                jnmllx.add(map);
            }
        }
        return jnmllx;
    }

    public List<Map<String,String>> getLbs() {
        List<Item> items=dictService.getItems(Constants.LB);
        List<Map<String,String>> lbs=new ArrayList<Map<String,String>>();
        for (Item item:items){
            Map<String,String> map=new HashMap<String, String>();
            map.put("name",item.getName());
            map.put("value",item.getValue());
            lbs.add(map);
        }
        return lbs;
    }

    public List<String> getLxs(){
        List<Item> items=dictService.getItems(Constants.CWLX);
        List<String> lxs = new ArrayList<String>();
        for(Item item:items){
            lxs.add(item.getValue());
        }
        return lxs;
    }

    @Override
    public String execute() throws Exception {
        modelsMap = new LinkedHashMap<String, Integer>();
        modelAliasMap = new HashMap<String, String>();
        Map<String, Integer> map;
        if((EnvHolder.isEnable(Switch.JURONG)||EnvHolder.isEnable(Switch.JIN_TAN))&&EnvHolder.isEnable(Switch.DWDM)&&!SessionUtil.getCurrentUser().isAdmin()){
           map=ajhRangeService.getAvailableAjhCountMapByDwdm(getDwdm());
        }else {
            map = ajhRangeService.getAvailableAjhCountMap();
        }
        if(EnvHolder.isEnable(Switch.JIANGYIN)){
            flMap=new HashMap<String, String>();
            List<Map<String, Object>> temp= treeService.getTree(null, Constants.MODEL_ROOT);
            for(Map<String, Object> parentNode:temp){
                String fl= parentNode.get("text").toString();
                    ArrayList<Map<String, Object>> children= (ArrayList<Map<String, Object>>) parentNode.get("children");
                    for(Map<String, Object> model:children) {
                        Model tempModel=modelService.getModelAllowNull(model.get("name").toString());
                        if(tempModel!=null){
                            modelsMap.put(tempModel.getName(), map.get(tempModel.getName()));
                            modelAliasMap.put(tempModel.getName(),tempModel.getTitle());
                            flMap.put(tempModel.getName(),fl);
                        }
                    }
            }
        }else{
            for (Model model : modelService.getModels()) {
                if ("Archive".equals(model.getParentName())||(EnvHolder.isEnable(Switch.JIANGYIN) && model.getParentName()==null)) {
                    modelsMap.put(model.getName(), map.get(model.getName()));
                    modelAliasMap.put(model.getName(),model.getTitle());
                }
            }
        }
        return super.execute();
    }

    public String edit(){
        if (ajhRange == null) {
            if (StringUtils.isNotBlank(id)) {
                ajhRange = ajhRangeService.getAjhRange(id);
                modelName = ajhRange.getModelName();
            } else {
                ajhRange = new AjhRange();
                ajhRange.setModelName(modelName);
            }
        } else {
            if (ajhRange.getCurrentValue() < ajhRange.getMinValue()) {
                ajhRange.setCurrentValue(ajhRange.getMinValue());
            }
            if (StringUtils.isBlank(ajhRange.getId())) {
                ajhRange.setId(null);
            }

            if(EnvHolder.isEnable(Switch.DWDM)&&ajhRange.getDwdm()==null) {
                ajhRange.setDwdm(getDwdm());
            }

            ajhRangeService.saveAjhRange(ajhRange);
            msg = "successed";
        }
        return "edit";
    }

    public String getTab() {
        return "ajh";
    }

    public String list() throws Exception {
        ajhRanges = ajhRangeService.getAjhRangeByModelName(modelName);
        if(EnvHolder.isEnable(Switch.JIN_TAN) && "Swda".equals(modelName)){
            List<Item> items=dictService.getItems(Constants.LB);
            for(AjhRange ajhRange1:ajhRanges){
                  String value=ajhRange1.getTerm();
                for(Item item:items){
                    if(item.getValue().equals(value)) {
                        ajhRange1.setTerm(item.getName());
                    }
                }
            }
        }
        return "list";
    }

    public String remove() throws Exception {
        ajhRangeService.removeAjhRange(id);
        return "toList";
    }

    /**
     * 获取当前对应单位代码
     * @return
     */
    public String getDwdm() {
        String dwdm = (String) Struts2Utils.getSessionAttribute("__dwdm");
        if (dwdm == null) {
            dwdm = userService.getUserRegionCode(SessionUtil.getCurrentUserId());
            Struts2Utils.getSession().setAttribute("__dwdm", dwdm);
        }
        return dwdm;
    }

    public String validateMlh(){
        if(EnvHolder.isEnable(Switch.JIN_TAN) && "Swda".equals(modelName)){
            Struts2Utils.renderJson("false");
            //金坛实物档案不做重复验证
        }

        if(ajhRangeService.exist(mlh,dm,id,year,term)){
            Struts2Utils.renderJson("true");
        }else{
            Struts2Utils.renderJson("false");
        }
        return null;
    }

    /**
     * 获取当前目录号列表的顺序号
     * @return
     */
    public String currentSxh(){
        Struts2Utils.renderJson(ajhRangeService.getCurrentSxh(modelName,dm));
        return null;
    }

}
