package com.gtis.archive.web;

import com.gtis.archive.Switch;
import com.gtis.archive.core.dict.DictService;
import com.gtis.archive.core.dict.Item;
import com.gtis.archive.core.environment.EnvHolder;
import com.gtis.archive.entity.Archive;
import com.gtis.archive.entity.Permission;
import com.gtis.archive.service.ArchiveService;
import com.gtis.archive.service.OriginalService;
import com.gtis.archive.service.SecurityService;
import com.gtis.archive.service.VRService;
import com.gtis.archive.service.sv.SqlServerService;
import com.gtis.archive.util.Struts2Utils;
import com.gtis.common.Page;
import com.gtis.config.AppConfig;
import com.gtis.plat.vo.UserInfo;
import com.gtis.web.SessionUtil;
import com.opensymphony.xwork2.Action;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.io.FileUtils;

import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.hibernate.criterion.Criterion;

import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;


import javax.jws.soap.SOAPBinding;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.util.*;


/**
 * .VrAction
 *
 * @author <a href="mailto:lanxy88@gmail.com">NelsonXu</a>
 * @version V1.0, 2015/6/26 13:15
 */
public class VrAction implements Action {
    protected final Logger logger = LoggerFactory.getLogger(getClass());

    @Autowired
    private VRService vrService;

    @Autowired
    private ArchiveService archiveService;

    @Autowired
    private SqlServerService sqlServerService;

    @Autowired
    private OriginalService originalService;

    @Autowired
    private DictService dictService;
    @Autowired
    private SecurityService securityService;

    private String roomId;

    private String modelName;

    private String mlh;

    private String nd;

    private String ajhs;

    private String id;

    private Page<Archive> archives;

    private String cabId;

    private String sideId;

    private String cellId;

    private String boxId;

    private Boolean isA3d;
    private String userName;

    public Boolean isA3d() {
        return isA3d;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Override
    public String execute() throws Exception {
        UserInfo userInfo = SessionUtil.getCurrentUser();
        if (AppConfig.getBooleanProperty("archive3d.enable")) {
            isA3d = true;
        }
        Map<String, Boolean> perms = new HashMap<String, Boolean>();
        // 系统权限列表
        Map<String, Boolean> sysPerms = new HashMap<String, Boolean>();
        if (userInfo.isAdmin()) {
            for (Item item : dictService.getItems(Permission.SYS_FUNCTION_DICT)) {
                perms.put(item.getName(), true);

            }
        }else if (!EnvHolder.isEnable(Switch.isNewPermission)) {
            for (Item item : dictService.getItems(Permission.SYS_FUNCTION_DICT)) {
                if (securityService.isPermitted("sys", item.getName())) {
                    perms.put(item.getName(), true);
                    sysPerms.put(item.getName(), true);
                }
            }
            for (Item item : dictService.getItems(Permission.SYS_FUNCTION_DICT)) {
                if (securityService.isPermitted("sys", item.getName())) {
                    sysPerms.put(item.getName(), true);
                }
            }
        }else {
            perms = securityService.getUserPermMap(userInfo,"sys");
            sysPerms = securityService.getUserPermMap(userInfo,"sys");
        }
        logger.info("perm: {}",perms);
        userName = userInfo.getUsername();
        return SUCCESS;
    }

    public List getRooms() {
        return vrService.getRoomsOnly();
    }

    public Map getRoom() {
        try {
            return vrService.getRoomByIdFromDb(roomId);
        } catch (Exception e) {
            return new HashMap();
        }
    }

    /**
     * 获取柜子
     * @return
     */
    public List getCabinet(){
        return vrService.getCabinetByRoomId(roomId);
    }

    public void cabinetsDetail(){
        List list = new ArrayList();
        try {
            list = vrService.cabinetsDetail(roomId,cabId,sideId);
        } catch (Exception e) {
            logger.error(e.getMessage());
        }
        Struts2Utils.renderJson(list);
    }

    public void cellsDetail(){
        List list = new ArrayList();
        try {
            list = vrService.cellsDetail(roomId, cabId, sideId, cellId);
        } catch (Exception e) {
            logger.error(e.getMessage());
        }
        Struts2Utils.renderJson(list);
    }

    public void boxAjhs(){
        List list = new ArrayList();
        try {
            list = vrService.boxajhs(roomId, cabId, sideId, cellId, boxId);
        } catch (Exception e) {
            logger.error("查询格子信息" + e.getMessage(),e);
        }
        Struts2Utils.renderJson(list);
    }

    public Page<Archive> getArchives() {
        return archives;
    }

    public List getRoomCabinets() {
        try {
            return (List) vrService.getRoomById(roomId).get(VRService.Tag.cabinets.name());
        } catch (Exception e) {
            return new ArrayList();
        }
    }

    /**
     * get room details
     */
    public void roomDetail() {
        Struts2Utils.renderJson(getRoom());
    }

    public String boxes() {
        List<Criterion> criterions = new ArrayList<Criterion>();
        if (StringUtils.isNotBlank(id)) {
            criterions.add(Restrictions.eq("id", id));
        } else {
            criterions.add(Restrictions.eq("mlh", mlh));
            criterions.add(Restrictions.eq("nd", nd));
            List<String> sqls = new ArrayList<String>();
            for (String ajh : ajhs.split(",")) {
                sqls.add(" ajh=" + ajh);
            }
            criterions.add(Restrictions.sqlRestriction(" ( "+StringUtils.join(sqls," or ")+" ) "));
        }
        List<Order> orders = new ArrayList<Order>();
        orders.add(Order.asc("dh"));
        this.archives = archiveService.searchArchive(modelName, criterions, orders, 0, -1);
        for (Archive archive :this.archives.getItems()){
            archive.setHasOriginal(originalService.hasOriginal(archive.getId()));
        }
        return "boxes";
    }

    /**
     * 马鞍山触摸屏原文
     */
    public String box() {
        if(id  != null){
            Archive archive = archiveService.getSimpleArchive(id);
            archive.setHasOriginal(originalService.hasOriginal(archive.getId()));
            List<Archive> archiveList = new ArrayList<Archive>();
            archiveList.add(archive);
            if(this.archives == null){
                this.archives = new Page<Archive>();
            }
            this.archives.setItems(archiveList);
        }
        return "boxes";
    }

    /**
     * open cbi
     */
    public void openCabinet() {
        String successString = "success";
        Map result = new HashMap();
        result.put(successString, true);
        try {
            result = sqlServerService.insertOpenCmd(BeanUtils.getProperty(archiveService.getArchive(modelName, id), "szjgwz"), "Open", SessionUtil.getCurrentUser().getUsername());
        } catch (NullPointerException ex) {
            result.put(successString, false);
            result.put("msg", "该档案未设置机柜位置！");
        } catch (Exception ex) {
            result.put(successString, false);
            result.put("msg", ex.getLocalizedMessage());
        }
        Struts2Utils.renderJson(result);
    }

    /**
     * open room
     *
     * @return
     */
    public String room() {
        return "room";
    }

    public String exh() {
        return "exh";
    }

    public void zipArchiveOg() {
        HttpServletResponse response = ServletActionContext.getResponse();
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", "attachment; filename=" + new Date().toString() + ".zip");
        try {
            org.apache.tools.zip.ZipOutputStream zos = new org.apache.tools.zip.ZipOutputStream(response.getOutputStream());
            Object[] ids = originalService.getIds(id);
            if (ids != null) {
                for (Object id : ids) {
                    File file = originalService.getOriginalFile((String) id, "download", SessionUtil.getCurrentUser());
                    zos.putNextEntry(new org.apache.tools.zip.ZipEntry(file.getName()));
                    zos.write(FileUtils.readFileToByteArray(file));
                }
            }
            zos.flush();
            zos.close();
        } catch (IOException e) {
            try {
                response.sendError(500, e.getLocalizedMessage());
            } catch (IOException e1) {
                logger.error(e1.getMessage());
            }
        }
    }

    public void setRoomId(String roomId) {
        this.roomId = roomId;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public String getModelName() {
        return modelName;
    }

    public void setMlh(String mlh) {
        this.mlh = mlh;
    }

    public void setAjhs(String ajhs) {
        this.ajhs = ajhs;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setNd(String nd) {
        this.nd = nd;
    }



    public String getCabId() {
        return cabId;
    }

    public void setCabId(String cabId) {
        this.cabId = cabId;
    }

    public String getSideId() {
        return sideId;
    }

    public void setSideId(String sideId) {
        this.sideId = sideId;
    }

    public String getCellId() {
        return cellId;
    }

    public void setCellId(String cellId) {
        this.cellId = cellId;
    }

    public String getBoxId() {
        return boxId;
    }

    public void setBoxId(String boxId) {
        this.boxId = boxId;
    }

    public String getRoomId() {
        return roomId;
    }
}
