package com.gtis.archive.web;

import com.gtis.archive.core.web.BaseAction;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.util.Md5Util;
import com.gtis.web.SessionUtil;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.HashMap;
import java.util.Map;

/**
 * 用户操作类
 * Created by linlong on 2017/8/8.
 */
public class UserAction extends BaseAction {

    @Autowired
    private SysUserService userService;

    // 用户的id
    private String userId;
    // 老密码
    private String oldPassword;
    // 新密码
    private String newPassword;
    // 确认密码
    private String confirmPassword;



    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getOldPassword() {
        return oldPassword;
    }

    public void setOldPassword(String oldPassword) {
        this.oldPassword = oldPassword;
    }

    public String getNewPassword() {
        return newPassword;
    }

    public void setNewPassword(String newPassword) {
        this.newPassword = newPassword;
    }

    public String getConfirmPassword() {
        return confirmPassword;
    }

    public void setConfirmPassword(String confirmPassword) {
        this.confirmPassword = confirmPassword;
    }

    /**
     * 打开更新页面
     * @return
     */
    public String openUpdate() {
        return "updatePassword";
    }

    /**
     * 更新用户的密码
     */
    public void updatePassword() {
        String failureString = "failure";
        String failureMassage = "三项输入有为空";
        String confirmFailureMassage = "新密码与确认密码不一致";
        Map<String, String> map = new HashMap<String, String>();
        if (StringUtils.isBlank(oldPassword) && StringUtils.isBlank(newPassword) && StringUtils.isBlank(confirmPassword)) {
            map.put(failureString, failureMassage);
            renderJson(map);
            logger.error(failureMassage);
            throw new IllegalArgumentException(failureMassage);
        }

        if (!newPassword.equals(confirmPassword)) {
            map.put(failureString, confirmFailureMassage);
            renderJson(map);
            logger.error(confirmFailureMassage);
            throw new IllegalArgumentException(confirmFailureMassage);
        }

        userId = SessionUtil.getCurrentUserId();
        logger.info("user id = {}", userId);
        try {
            PfUserVo user = userService.getUserVo(userId);
            if (user == null) {
                map.put(failureString, "用户为空");
            } else {
                logger.debug("user password = {}", user.getLoginPassWord());
                String check = oldPassword;
                String md5Passwd = Md5Util.Build(check);
                if (!md5Passwd.equals(user.getLoginPassWord())) {
                    map.put(failureString, "原始密码错误");
                } else {
                    user.setLoginPassWord(newPassword);
                    userService.savePassWord(userId, newPassword);
                    map.put("success", "保存成功");
                }
            }
        } catch (Exception e) {
            map.put(failureString, "保存失败");
            logger.error("保存失败, {}", e.getMessage());
            logger.error("保存失败" + e.getMessage(),e);
        }
        renderJson(map);
    }
}
