package com.gtis.archive.web;

import com.gtis.archive.Constants;
import com.gtis.archive.service.ArchiveService;
import com.gtis.archive.service.ExtTreeService;
import com.opensymphony.xwork2.ActionSupport;
import org.apache.struts2.ServletActionContext;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:wanglei@gtis.com.cn">wanglei</a>
 * @version V1.0, 2011-3-30
 */

public class StatisticsAction extends ActionSupport {
    private static final long serialVersionUID = 8810580227666165801L;
    @Autowired
    private ExtTreeService treeService;
    @Autowired
    private ArchiveService archiveService;

    private String nd;
    private List<Map<String, Object>> results;
    private Map<String, Object> totalStatistics;

    public void setNd(String nd) {
        this.nd = nd;
    }

    public List<Map<String, Object>> getResults() {
        return results;
    }

    public Map<String, Object> getTotalStatistics() {
        return totalStatistics;
    }

    public String getNd() {
        return nd;
    }

    @Override
    public String execute() throws Exception {
        ServletActionContext.getResponse().setContentType("application/vnd.ms-word");
        ServletActionContext.getResponse().setHeader("Content-Disposition", "attachment; filename=stat.doc");
        initInfo();
        return SUCCESS;
    }

    private List<Map<String, Object>> initInfo(){
        List<Map<String, Object>> tree = treeService.getTree(null, Constants.MODEL_ROOT);
        results = new ArrayList<Map<String, Object>>();
        totalStatistics = new HashMap<String, Object>();

        //---------------已归档----------------
        Criterion criterionState = Restrictions.eq("state", 1);

        Criterion criterionNd = Restrictions.eq("nd", nd);
        Criterion criteriond = Restrictions.eq("bgqx", "短期");
        Criterion criterionz = Restrictions.eq("bgqx", "长期");
        Criterion criterionc = Restrictions.eq("bgqx", "永久");

        int lx = 0;
        int ld = 0;
        int lz = 0;
        int lc = 0;
        int lzj = 0;
        int lzd = 0;
        int lzz = 0;
        int lzc = 0;

        for (Map res : tree) {
            Map<String, Object> result = new HashMap<String, Object>();
            int x = 0;
            int d = 0;
            int z = 0;
            int c = 0;
            int zj = 0;
            int zd = 0;
            int zz = 0;
            int zc = 0;
            if (res.get("children") != null) {
                List children = (ArrayList) (res.get("children"));
                for (Object child : children) {
                    String modelName = (String) ((Map) child).get("name");
                    List<Criterion> criterions = new ArrayList<Criterion>();
                    criterions.add(criterionState);
                    criterions.add(criterionNd);
                    x += archiveService.getArchiveCount(modelName, criterions);
                    criterions.add(criteriond);
                    d += archiveService.getArchiveCount(modelName, criterions);
                    criterions.remove(criteriond);
                    criterions.add(criterionz);
                    z += archiveService.getArchiveCount(modelName, criterions);
                    criterions.remove(criterionz);
                    criterions.add(criterionc);
                    c += archiveService.getArchiveCount(modelName, criterions);

                    criterions.remove(criterionNd);
                    criterions.remove(criterionc);
                    zj += archiveService.getArchiveCount(modelName, criterions);
                    criterions.add(criteriond);
                    zd += archiveService.getArchiveCount(modelName, criterions);
                    criterions.remove(criteriond);
                    criterions.add(criterionz);
                    zz += archiveService.getArchiveCount(modelName, criterions);
                    criterions.remove(criterionz);
                    criterions.add(criterionc);
                    zc += archiveService.getArchiveCount(modelName, criterions);
                }
                result.put("nd", nd);
                result.put("title", res.get("name"));
                result.put("x", x);
                lx += x;
                result.put("d", d);
                ld += d;
                result.put("z", z);
                lz += z;
                result.put("c", c);
                lc += c;
                result.put("zj", zj);
                lzj += zj;
                result.put("zd", zd);
                lzd += zd;
                result.put("zz", zz);
                lzz += zz;
                result.put("zc", zc);
                lzc += zc;

                totalStatistics.put("lx", lx);
                totalStatistics.put("ld", ld);
                totalStatistics.put("lz", lz);
                totalStatistics.put("lc", lc);
                totalStatistics.put("lzj", lzj);
                totalStatistics.put("lzd", lzd);
                totalStatistics.put("lzz", lzz);
                totalStatistics.put("lzc", lzc);
                results.add(result);
            }

        }
        return new ArrayList<Map<String, Object>>();
    }

}
