package com.gtis.archive.web;

import com.alibaba.fastjson.JSON;
import com.gtis.archive.Constants;
import com.gtis.archive.Switch;
import com.gtis.archive.core.Model;
import com.gtis.archive.core.dict.DictService;
import com.gtis.archive.core.dict.Item;
import com.gtis.archive.core.environment.EnvHolder;
import com.gtis.archive.core.ex.EntityNotFoundException;
import com.gtis.archive.core.ex.ModelNotFoundException;
import com.gtis.archive.core.ex.NoPermissionException;
import com.gtis.archive.core.ex.TemplateNotFoundException;
import com.gtis.archive.core.web.BaseModelAction;
import com.gtis.archive.entity.*;
import com.gtis.archive.service.*;
import com.gtis.archive.util.Struts2Utils;
import com.gtis.common.Page;
import com.gtis.plat.service.SysUserService;
import com.gtis.web.SessionUtil;
import com.opensymphony.xwork2.Action;
import freemarker.template.TemplateException;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.json.JSONException;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;

import java.io.IOException;
import java.util.*;

public class ScrutinyAction extends BaseModelAction<Archive> {

    private static final Object Lock = 0x001;

    @Autowired
    private ArchiveService archiveService;
    @Autowired
    private ExtTreeService treeService;
    @Autowired
    private ResourceService resourceService;
    @Autowired
    private SecurityService securityService;
    @Autowired
    private DictService dictService;
    @Autowired
    private AjhRangeService ajhRangeService;

    @Autowired
    private OriginalService originalService;

    @Autowired
    private RecordAjhRangeService recordAjhRangeService;

    @Autowired
    private SysUserService userService;
    /**
     * tree id
     */
    private String treeId;
    /**
     * archive view type,wgd(未归档) ygd(已归档)
     */
    private String type;
    /**
     * 所有定义的操作项
     */
    private List<Item> operations;
    private Map<String, String> topMenu;
    /**
     * 自动组盒用的目录号
     */
    private String mlh;
    /**
     * 自动组盒用的起始案卷号
     */
    private Integer ajh;

    /**
     * 自动组合截止案卷号
     */
    private Integer endAjh;
    /**
     * 自动组盒用装盒份数
     */
    private Integer boxSize;
    /**
     * 档案中卷内显示的字段
     */
    private Map docShowFields;
    private Map docFields;

    /**
     * 链接字段
     */
    private String linkField;

    private String docLinkField;

    private String dwdm;

    public String getDwdm() {
        return dwdm;
    }

    public void setDwdm(String dwdm) {
        this.dwdm = dwdm;
    }

    @Override
    public void setModelName(String modelName) {
        super.setModelName(Document.toArchiveModelName(modelName));
    }

    @Override
    public String getModelName() {
        return super.getModelName();
    }


    public void setTreeId(String treeId) {
        this.treeId = treeId;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setMlh(String mlh) {
        this.mlh = mlh;
    }

    public void setAjh(Integer ajh) {
        this.ajh = ajh;
    }

    public void setEndAjh(Integer endAjh) {
        this.endAjh = endAjh;
    }

    public void setBoxSize(Integer boxSize) {
        this.boxSize = boxSize;
    }

    public Integer getBoxSize() {
        return boxSize;
    }

    public String getTreeId() {
        return treeId;
    }

    public String getType() {
        return type;
    }

    public List<Item> getOperations() {
        return operations;
    }


    public String getPermJson() {
        Map<String, Boolean> perm = new HashMap<String, Boolean>();
        for (Item item : operations) {
            if ("view".equals(item.getName())) {
                perm.put(item.getName(), true);
            }
        }
        return JSON.toJSONString(perm);
    }

    public Map<String, Boolean> getPerms() {
        Map<String, Boolean> perm = new HashMap<String, Boolean>();
        if (!EnvHolder.isEnable(Switch.isNewPermission) || SessionUtil.getCurrentUser().isAdmin()) {
            for (Item item : operations) {
                if (securityService.isPermitted(treeId, item.getName())) {
                    perm.put(item.getName(), true);
                }
            }
        }else {
            perm = securityService.getUserPermMap(SessionUtil.getCurrentUser(),treeId);
        }
        return perm;
    }

    public String getTreeJson() throws JSONException {
        return JSON.toJSONString(rewrite(treeService.getTree(treeId)));
    }

    private List<Map<String, Object>> tree;

    public List<Map<String, Object>> getTree() {
        if (tree == null) {
            List<Map<String, Object>> listTree = treeService.getAllTree(null, Constants.MODEL_ROOT);
            for (Map item : listTree) {
                logger.debug(item.toString());
                if (item.get("name").equals(Constants.GENERIC)) {
                    listTree.remove(item);
                    break;
                }
            }
            tree = listTree;
        }
        return tree;
    }

    public Map<String, String> getTopMenu() {
        if (topMenu == null) {
            topMenu = new LinkedHashMap<String, String>();
            for (Item item : dictService.getItems("archiveMenu")) {
                if ("true".equalsIgnoreCase(item.getValue())) {
                    topMenu.put(item.getName(), item.getRemark());
                }
            }
        }
        return topMenu;
    }

    @Override
    public String execute() {
        if (modelName == null || "Archive".equals(modelName)) {
            List<Map<String, Object>> tree = getTree();
            for (Map<String, Object> map : tree) {
                List<Map<String, Object>> children = (List<Map<String, Object>>) map.get("children");
                if (children != null && !children.isEmpty()) {
                    modelName = children.get(0).get("name").toString();
                    break;
                }
            }
        }
        String currentDwdm = getCurrentDwdm();
        boolean  hasPermission= false;
        try{
            List<Item> items = dictService.getItems(Constants.HUCHA_PREFIX + currentDwdm);
            for (Item item : items) {
                if (item.getValue().equals(this.dwdm)) {
                    hasPermission=true;
                }
            }
        }catch (Exception ex){
            logger.error(ex.getMessage());
        }
        if(!hasPermission) {
            return Action.NONE;
        }
        operations = dictService.getItems(Permission.OPERATION_DICT);
        if (StringUtils.isNotEmpty(modelName)) {
            Resource res = resourceService.findChildResource(null, modelName, Constants.MODEL_ROOT);
            if (res != null) {
                treeId = res.getId();
                if (!EnvHolder.isEnable(Switch.isNewPermission)) {
                    if (!securityService.isPermitted(treeId, Permission.VIEW_PERMISSION)) {
                        throw new NoPermissionException(modelName);
                    }
                } else {
                    if (!securityService.isResPermittedNew(treeId, Permission.VIEW_PERMISSION)){
                        throw new NoPermissionException(modelName);
                    }
                }
            } else {
                throw new ModelNotFoundException(modelName);
            }
        }
        modelService.getModel(modelName);
        String id = getId();
        if (id != null) {
            Archive archive = archiveService.getArchive(modelName, id);
            if (archive != null) {
                type = archive.getState() == Archive.STATE_YGD ? "ygd" : "wgd";
            }
        }
        return Action.SUCCESS;
    }

    public String gd() {
        for (String id : ids) {
            if (StringUtils.isBlank(id)) {
                continue;
            }
            Archive archive = archiveService.getArchive(modelName, id);
            AjhRange ajhRange = null;
            if (archive.getDh() == null) {
                try {
                    ajhRange = ajhRangeService.getAvailableAjhRange(modelName);
                    archive.setMlh(ajhRange.getMlh());
                    archive.setAjh(ajhRange.getNextValue());
                } catch (EntityNotFoundException e) {
                    Struts2Utils.renderText(e.getMessage());
                }
            }
            archive.setState(Archive.STATE_YGD);
            archive.setGdsj(new Date());
            archiveService.saveArchive(archive);
            if (ajhRange != null) {
                ajhRange.setCurrentValue(archive.getAjh());
                ajhRangeService.saveAjhRange(ajhRange);
            }
        }
        return null;
    }

    public String cxgd() {
        for (String id : ids) {
            if (StringUtils.isBlank(id)) {
                continue;
            }
            Archive archive = archiveService.getArchive(modelName, id);
            archive.setState(Archive.STATE_WGD);
            archive.setGdsj(null);
            if (EnvHolder.isEnable(Switch.ALLOW_NULL_DH)) {
                archive.setMlh(null);
                archive.setAjh(null);
                archive.setDh(null);
            }
            archiveService.saveArchive(archive);
        }
        return null;
    }

    public String fastGd() throws Exception {
        synchronized (Lock) {
            String id = getId();
            if (StringUtils.isNotBlank(id)) {
                Archive archive = archiveService.getArchive(modelName, id);
                archive.setState(Archive.STATE_YGD);
                archive.setGdsj(new Date());
                AjhRange ajhRange = null;
                if (archive.getDh() == null) {
                    ajhRange = ajhRangeService.getAvailableAjhRange(modelName);
                    archive.setMlh(ajhRange.getMlh());
                    archive.setAjh(ajhRange.getNextValue());
                }

                archiveService.saveArchive(archive);
                if (ajhRange != null) {
                    ajhRange.setCurrentValue(archive.getAjh());
                    ajhRangeService.saveAjhRange(ajhRange);
                }
            }
        }
        return renderModelTemplate("fastGd");
    }

    public String move() {
        if (StringUtils.isBlank(treeId)) {
            treeId = null;
        }
        for (String id : ids) {
            if (StringUtils.isBlank(id)) {
                continue;
            }
            Archive archive = archiveService.getArchive(modelName, id);
            archive.setResourceId(treeId);
            archiveService.saveArchive(archive);
        }
        return null;
    }

    public String order() {
        AjhRange ajhRange = ajhRangeService.getAvailableAjhRange(modelName);
        for (Archive archive : getEntities()) {
            if (!ajhRange.hasExhausted()) {
                ajhRangeService.saveAjhRange(ajhRange);
                ajhRange = ajhRangeService.getAvailableAjhRange(modelName);
            }
            archive.setAjh(ajhRange.getNextValue());
            archive.setDh(null);
            archiveService.saveArchive(archive);
        }
        return null;
    }

    @Override
    protected Page<Archive> searchEntity(List<Criterion> criterions, List<Order> orders) {
        if (EnvHolder.isEnable(Switch.JIANGYIN)) {
            Page<Archive> page = archiveService.searchArchive(modelName, criterions, orders, dwdm, start, limit);
            for (Archive archive : page.getItems()) {
                archive.setHasOriginal(originalService.hasOriginal(archive.getId()));
            }
            return page;
        } else {
            return archiveService.searchArchive(modelName, criterions, orders, dwdm, start, limit);
        }
    }

    @Override
    protected List<Criterion> createCriterions(ArrayList<Criterion> criterions) {
        String resourceIdString = "resourceId";
        if (ajh != null) {
            criterions.add(Restrictions.eq("mlh", mlh));
            criterions.add(Restrictions.gt("ajh", ajh));
            if (endAjh != null) {
                criterions.add(Restrictions.lt("ajh", endAjh));
            }
            sort = "ajh";
        } else {
            if (type == null || !"all".equals(type)) {
                criterions.add(Restrictions.eq("state", "ygd".equals(type) ? Archive.STATE_YGD : Archive.STATE_WGD));
            }
            if (StringUtils.isNotBlank(treeId)) {
                if ("checkbox".equals(EnvHolder.getAppEnv().get(Switch.CLASSIFYVIEWMODE))) {
                    String[] treeIds = treeId.split(",");
                    if (treeIds.length == 1) {
                        if (resourceService.getResource(treeId).getName().equals(modelName)) {
                            criterions.add(Restrictions.or(Restrictions.eq(resourceIdString, treeId), Restrictions.isNull(resourceIdString)));
                        } else {
                            criterions.add(Restrictions.eq(resourceIdString, treeId));
                        }
                    } else {
                        if (treeIds.length > 2) {
                            Criterion temp = Restrictions.or(Restrictions.eq(resourceIdString, treeIds[0]), Restrictions.eq(resourceIdString, treeIds[1]));
                            for (int i = 2; i < treeIds.length; i++) {
                                temp = Restrictions.or(temp, Restrictions.eq(resourceIdString, treeIds[i]));
                            }
                            criterions.add(temp);
                        } else {
                            criterions.add(Restrictions.or(Restrictions.eq(resourceIdString, treeIds[0]), Restrictions.eq(resourceIdString, treeIds[1])));
                        }
                    }

                } else {
                    if (resourceService.getResource(treeId).getName().equals(modelName)) {
                        criterions.add(Restrictions.or(Restrictions.eq(resourceIdString, treeId), Restrictions.isNull(resourceIdString)));
                    } else {
                        criterions.add(Restrictions.eq(resourceIdString, treeId));
                    }
                }
            } else {
                criterions.add(Restrictions.isNull(resourceIdString));
            }
        }
        return super.createCriterions(criterions);
    }

    @SuppressWarnings("unchecked")
    private List<Map<String, Object>> rewrite(List<Map<String, Object>> tree) {
        if (tree != null) {
            for (Map<String, Object> map : tree) {
                rewrite((List<Map<String, Object>>) map.get("children"));
                String id = (String) map.get("id");
                Map<String, Boolean> perm = new HashMap<String, Boolean>();
                if (!EnvHolder.isEnable(Switch.isNewPermission) || SessionUtil.getCurrentUser().isAdmin()) {
                    for (Item item : operations) {
                        if (securityService.isPermitted(id, item.getName())) {
                            perm.put(item.getName(), true);
                        }
                    }
                }else {
                    perm = securityService.getUserPermMap(SessionUtil.getCurrentUser(),id);
                }
                map.put("perm", perm);
            }
        }
        return tree;
    }

    /**
     * 获得档案中案卷显示的字段
     *
     * @return
     */
    public Map getDocShowFields() {
        if (docShowFields == null) {
            try {
                Model doc = archiveService.getDocumentModel(modelName);
                docShowFields = JSON.parseObject(doc.getTemplate("showFields"), LinkedHashMap.class);
            } catch (ModelNotFoundException ex) {
                logger.error(ex.getMessage());
            } catch (TemplateNotFoundException ex) {
                docShowFields = JSON.parseObject(getEntityTemplate("Document-showFields"), LinkedHashMap.class);
            }
        }
        return docShowFields;
    }

    /**
     * 获取档案中案卷所有字段
     *
     * @return
     */
    public Map getDocFields() {
        if (docFields == null) {
            try {
                Model doc = archiveService.getDocumentModel(modelName);
                docFields = doc.getInheritfieldsMap();
            } catch (ModelNotFoundException ex) {
                logger.error(ex.getMessage());
            }
        }
        return docFields;
    }

    public String getLinkField() {
        if (linkField == null) {
            try {
                linkField = archiveService.getArchiveModel(modelName).getTemplate("linkField");
            } catch (Exception ex) {
                linkField = "tm";
            }
        }
        return linkField;
    }


    public String getDocLinkField() {
        if (docLinkField == null) {
            try {
                docLinkField = archiveService.getDocumentModel(modelName).getTemplate("linkField");
            } catch (ModelNotFoundException ex) {
                logger.error(ex.getMessage());
            } catch (TemplateNotFoundException ex) {
                docLinkField = "tm";
            }
        }
        return docLinkField;
    }


    /**
     * 快速补件
     *
     * @return
     * @throws Exception
     */
    public String fastAddOG() throws Exception {
        //
        return renderModelTemplate("fastAddOG");
    }

    /**
     * 获取是否存在卷内案卷模型
     *
     * @return
     */
    public boolean getIsShowArchiveInfo() {
        try {
            if (modelService.getModel(modelName.concat("_ai")) != null) {
                return true;
            }
        } catch (ModelNotFoundException ex) {
            return false;
        }
        return false;
    }

    /**
     * 获取案卷是否存在卷内
     *
     * @return
     */
    public boolean getIsShowArchiveDoc() {
        try {
            if (modelService.getModel(modelName.concat("_jn")) != null) {
                return true;
            }

        } catch (ModelNotFoundException ex) {
            return false;
        }
        return false;
    }

    /**
     * 打印档案相关案卷信息
     *
     * @return
     * @throws java.io.IOException
     * @throws freemarker.template.TemplateException
     *
     */
    public String printArcDocs() throws IOException, TemplateException {
        try {
            return renderTemplate(getEntityModel().getTemplate("printArcDoc"));
        } catch (TemplateNotFoundException ex) {
            logger.error(ex.getMessage());
        }
        return null;
    }


    /**
     * 检索数据后进行统一归档
     *
     * @return
     */
    public String gdAfterSearch() {
        List<Archive> list = getEntityPage().getItems();
        for (Archive archive : list) {
            AjhRange ajhRange = null;
            if (archive.getDh() == null) {
                try {
                    ajhRange = ajhRangeService.getAvailableAjhRange(modelName);
                    archive.setMlh(ajhRange.getMlh());
                    archive.setAjh(ajhRange.getNextValue());
                } catch (EntityNotFoundException e) {
                    Struts2Utils.renderText(e.getMessage());
                }
            }
            archive.setState(Archive.STATE_YGD);
            archive.setGdsj(new Date());
            archiveService.saveArchive(archive);
            if (ajhRange != null) {
                ajhRange.setCurrentValue(archive.getAjh());
                ajhRangeService.saveAjhRange(ajhRange);
            }
        }
        return null;
    }


    @Override
    public String remove() throws Exception {
        if (EnvHolder.isEnable(Switch.JIANGYIN)) {
            for (String id : ids) {
                Archive archive = archiveService.getArchive(modelName, id);
                RecordAjhRange recordAjhRange = new RecordAjhRange();
                recordAjhRange.setAjh(archive.getAjh());
                recordAjhRange.setMlh(archive.getMlh());
                recordAjhRange.setDwdm(archive.getDwdm());
                recordAjhRange.setModelName(archive.getModelName());
                recordAjhRangeService.saveRecordAjh(recordAjhRange);
            }
        }
        archiveService.removeArchive(modelName, ids);
        return null;
    }

    private List docEntities;

    /**
     * 获取档案相关卷内值
     *
     * @return
     */
    public List getDocEntities() {
        if (docEntities != null) {return docEntities;}
        docEntities = new ArrayList();
        if (ids.length > 0) {
            for (String id : ids) {
                docEntities.addAll(archiveService.getArchiveDocuments(modelName, id));
            }
        }
        return docEntities;
    }

    public void setIdString(String idString) {
        if (StringUtils.isNotBlank(idString)) {
            ids = idString.split(",");
        }
    }

    /**
     * 过滤条件查询ｉｄ
     *
     * @return
     */
    public String searchIds() {
        List<Criterion> criterions = createCriterions(new ArrayList<Criterion>());
        List<Order> orders = createOrders(new ArrayList<Order>());
        List items = entityService.search(modelName, criterions, orders, start, limit).getItems();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < items.size(); i++) {
            try {
                sb.append(PropertyUtils.getProperty(items.get(i), "id") + ",");
            } catch (Exception e) {
                logger.error(e.toString());
            }
        }
        ids = sb.toString().split(",");
        return cacheIds();
    }

    private String getCurrentDwdm() {
        dwdm = (String) Struts2Utils.getSessionAttribute("__dwdm");
        if (dwdm == null) {
            dwdm = userService.getUserRegionCode(SessionUtil.getCurrentUserId());
            Struts2Utils.getSession().setAttribute("__dwdm", dwdm);
        }
        return dwdm;
    }
}
