package com.gtis.archive.web;

import com.gtis.archive.core.dict.DictService;
import com.gtis.archive.core.dict.Item;
import com.gtis.archive.core.web.BaseModelAction;
import com.gtis.archive.entity.Archive;
import com.gtis.archive.entity.Position;
import com.gtis.archive.service.ArchiveService;
import com.gtis.archive.service.PositionService;
import com.opensymphony.xwork2.Action;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 库房管理
 * Created by linlong on 2017/4/25 0025.
 */
public class RoomAction extends BaseModelAction<Archive> {
    private String successString = "success";
    private String failureString = "failure";
    @Autowired
    private ArchiveService archiveService;
    @Autowired
    private DictService dictService;
    @Autowired
    private PositionService positionService;

    /**
     * 分页位置
     */
    protected int start = 0;

    /**
     * 房间列表
     */
    private List<Item> rooms;

    /**
     * 当前房间
     */
    private Item currentRoom;

    /**
     * 当前房间字典项的name
     */
    private String currentRoomName;

    /**
     * 当前的柜号
     */
    private String currentCabNum;

    /**
     * 当前的行号
     */
    private Integer currentRowNum;

    /**
     * 当前的列号
     */
    private Integer currentColNum;

    /**
     * 每个柜子的行号
     */
    private Integer rows;

    /**
     * 每个柜子的列号
     */
    private Integer cols;

    /**
     * 柜子总数
     */
    private List<Position> cabinets;

    /**
     * 案卷的id字符串
     */
    private String ids;

    /**
     * 输入的档号
     */
    private String inputDh;

    /**
     * 输入的盒号
     */
    private Integer inputBoxId;

    /**
     * 日常管理类型
     */
    private String type;

    public List<Position> getCabinets() {
        cabinets = positionService.getCabinetByRoom(currentRoom.getName());
        return cabinets;
    }

    public void setCabinets(List<Position> cabinets) {
        this.cabinets = cabinets;
    }

    public Integer getInputBoxId() {
        return inputBoxId;
    }

    public void setInputBoxId(Integer inputBoxId) {
        this.inputBoxId = inputBoxId;
    }

    public String getInputDh() {
        return inputDh;
    }

    public void setInputDh(String inputDh) {
        this.inputDh = inputDh;
    }

    public String getIds() {
        return ids;
    }

    public void setIds(String ids) {
        this.ids = ids;
    }

    /**
     * 当前格子号
     */
    private Integer currentCellNum;

    public Integer getCurrentCellNum() {
        return currentCellNum;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setCurrentCellNum(Integer currentCellNum) {
        this.currentCellNum = currentCellNum;
    }

    /**
     * 案卷列表
     */
    private List<Archive> archives;

    public List<Archive> getArchives() {
        return archives;
    }

    public void setArchives(List<Archive> archives) {
        this.archives = archives;
    }

    public List<Item> getRooms() {
        rooms = dictService.getItems("room");
        if (this.currentRoom == null) {
            this.currentRoom = rooms.get(0);
        }
        return rooms;
    }

    public void setRooms(List<Item> rooms) {
        this.rooms = rooms;
    }

    public Item getCurrentRoom() {
        return currentRoom;
    }

    public void setCurrentRoom(Item currentRoom) {
        this.currentRoom = currentRoom;
    }

    public String getCurrentRoomName() {
        if (currentRoomName == null) {
            currentRoomName = currentRoom.getName();
        } else {
            for (Item item : rooms) {
                if (item.getName().equals(currentRoomName)) {
                    this.currentRoom = item;
                    break;
                }
            }
        }
        return currentRoomName;
    }

    public void setCurrentRoomName(String currentRoomName) {
        this.currentRoomName = currentRoomName;
    }

    public String getCurrentCabNum() {
        return currentCabNum;
    }

    public void setCurrentCabNum(String currentCabNum) {
        this.currentCabNum = currentCabNum;
    }

    public Integer getCurrentRowNum() {
        return currentRowNum;
    }

    public void setCurrentRowNum(Integer currentRowNum) {
        this.currentRowNum = currentRowNum;
    }

    public Integer getCurrentColNum() {
        return currentColNum;
    }

    public void setCurrentColNum(Integer currentColNum) {
        this.currentColNum = currentColNum;
    }

    public void setRows(Integer rows) {
        this.rows = rows;
    }

    public void setCols(Integer cols) {
        this.cols = cols;
    }

    public Integer getRows() {
        return rows;
    }

    public Integer getCols() {
        return cols;
    }

    @Override
    public String execute() {
        return Action.SUCCESS;
    }

    /**
     * 获取格子里的档案
     *
     * @return
     */
    public void getCellArchives() {
        if (StringUtils.isNotBlank(currentRoomName) && StringUtils.isNotBlank(currentCabNum)
                && currentRowNum != null && currentColNum != null) {
            try {
                List<Archive> list = archiveService.getArchivesByCell(currentRoomName, currentCabNum, currentRowNum, currentColNum);
                renderJson(list);
            } catch (Exception e) {
                logger.error("获取档案失败");
            }
        }
    }

    /**
     * 打开档案上架页面
     *
     * @return
     */
    public String moveOn() {
        return "moveOn";
    }

    /**
     * 获取案卷信息
     */
    public void getArchiveInfo() {
        try {
            if (StringUtils.isNotBlank(inputDh)) {
                archives = archiveService.getArchivesByDh(inputDh);
                renderJson(archives);
            } else {
                logger.error("输入的档号为空");
            }
        } catch (Exception e) {
            logger.error("获取案卷信息失败");
        }

    }

    /**
     * 通过盒号获取档案
     */
    public void getArchivesByBox() {
        if (inputBoxId != null) {
            archives = archiveService.getArchivesByBox(inputBoxId);
            renderJson(archives);
        }
    }

    /**
     * 档案上架
     */
    public void moveOnArchives() {
        if (StringUtils.isNotBlank(ids)) {
            String[] idArr = ids.split(",");
            for (String id : idArr) {
                Archive archive = archiveService.getSimpleArchive(id);
                archive.setRoomId(currentRoomName);
                archive.setCabinetSno(currentCabNum);
                archive.setRowId(currentRowNum);
                archive.setColumnId(currentColNum);
                archive.setCellId(currentCellNum);
                archiveService.saveArchive(archive);
            }
            Position p = new Position();
            p.setRoomId(currentRoomName);
            p.setCabinetSno(currentCabNum);
            p.setRowId(currentRowNum);
            p.setColumnId(currentColNum);
            positionService.updateCabinetStatus(p, true);
        }
    }

    /**
     * 档案下架
     */
    public void moveOffArchives() {
        if (StringUtils.isNotBlank(ids)) {
            String[] idArr = ids.split(",");
            try {
                for (String id : idArr) {
                    Archive archive = archiveService.getSimpleArchive(id);
                    archive.setRoomId(null);
                    archive.setCabinetSno(null);
                    archive.setCellId(null);
                    archive.setRowId(null);
                    archive.setColumnId(null);
                    archive.setSideId(null);
                    archiveService.saveArchive(archive);
                }
                Position p = new Position();
                p.setRoomId(currentRoomName);
                p.setCabinetSno(currentCabNum);
                p.setRowId(currentRowNum);
                p.setColumnId(currentColNum);
                positionService.updateCabinetStatus(p, false);
                renderJson(successString);
            } catch (Exception e) {
                logger.error("档案下架失败");
            }
        } else {
            renderJson(failureString);
        }
    }

    /**
     * 保存柜子
     */
    public void saveCabinet() {
        try {
            Position position = positionService.getPositionByCabinet(currentRoomName, currentCabNum);
            if (position != null) {
                int addRows = position.getRowId() - rows;
                int addCols = position.getColumnId() - cols;
                position.setColumnId(cols);
                position.setRowId(rows);
                positionService.savePosition(position, addRows, addCols, false);
            } else {
                position = new Position();
                position.setRoomId(currentRoomName);
                position.setCabinetSno(currentCabNum);
                position.setColumnId(cols);
                position.setRowId(rows);
                positionService.savePosition(position, null, null, true);
            }
            renderJson(successString);
        } catch (Exception e) {
            renderJson(failureString);
        }
    }

    /**
     * 获取柜子的行数和列数
     */
    public void getRowsAndCols() {
        String messageString = "message";
        Map<String, Object> info = new HashMap<String, Object>();
        try {
            Position p = positionService.getPositionByCabinet(currentRoomName, currentCabNum);
            if (p == null) {
                info.put(messageString, successString);
                renderJson(info);
                return;
            }

            Map<String, Boolean> map = positionService.getCellHasArchives(p);
            info.put("col", p.getColumnId());
            info.put("row", p.getRowId());
            info.put("map", map);
            info.put(messageString, successString);
            renderJson(info);
        } catch (Exception e) {
            info.put(messageString, failureString);
        }
    }

    /**
     * 删除柜子
     */
    public void deleteCabinet() {
        try {
            Position position = positionService.getPositionByCabinet(currentRoomName, currentCabNum);
            if (position == null) {
                logger.error("查询柜子信息失败！");
                renderJson(successString);
                return;
            }
            String[] ids1 = new String[]{position.getId()};
            entityService.remove(Position.class, ids1);
            renderJson(successString);
        } catch (Exception e) {
            renderJson(failureString);
        }
    }
}
