package com.gtis.archive.web;

import com.gtis.archive.Constants;
import com.gtis.archive.Switch;
import com.gtis.archive.core.dict.Item;
import com.gtis.archive.core.environment.EnvHolder;
import com.gtis.archive.core.ex.ModelNotFoundException;
import com.gtis.archive.core.web.BaseModelAction;
import com.gtis.archive.entity.Archive;
import com.gtis.archive.entity.Resource;
import com.gtis.archive.service.*;
import com.gtis.archive.util.SearchUtils;
import com.gtis.archive.util.Struts2Utils;
import com.gtis.common.Page;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.vo.PfOrganVo;
import com.gtis.web.SessionUtil;
import com.opensymphony.xwork2.Action;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;

import java.io.IOException;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:USER@gtis.com.cn">WangGang</a>
 * @version V1.0, 2010-10-20
 */
public class ReceptionAction extends BaseModelAction<Archive> {
    private String type = "model";

    @Autowired
    private ArchiveService archiveService;
    @Autowired
    private ResourceService resourceService;
    @Autowired
    private ExtTreeService treeService;
    @Autowired
    private SecurityService securityService;
    @Autowired
    private SysUserService userService;
    @Autowired
    private PermissionService permissionService;
    @Autowired
    private LogManagerService logManagerService;
    /**
     * 案卷ID
     */
    private String archiveid;
    /**
     * id
     */
    private String id;
    /**
     * 权证号
     */
    private String qzh;
    /**
     * 档号
     */
    private String dh;
    /**
     * archiveids
     */
    private String[] archiveids;
    /**
     * 查询类型1为权证号,2为档号，3为无条件
     */
    private int st;
    /**
     * tree id
     */
    private String treeId;
    /**
     * 链接字段
     */
    private String linkField;
    /**
     * 模糊检索关键字
     */
    protected String query;

    private List<String> operationStrs;

    private String daglh;

    private String condition;


    public List<String> getOperationStrs() {
        return operationStrs;
    }

    public void setOperationStrs(List<String> operationStrs) {
        this.operationStrs = operationStrs;
    }

    public int getSt() {
        return st;
    }

    public void setSt(int st) {
        this.st = st;
    }

    public String getQzh() {
        return qzh;
    }

    public void setQzh(String qzh) {
        this.qzh = qzh;
    }

    public String getDh() {
        return dh;
    }

    public void setDh(String dh) {
        this.dh = dh;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getArchiveid() {
        return archiveid;
    }

    public void setArchiveid(String archiveid) {
        this.archiveid = archiveid;
    }

    @Override
    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String[] getArchiveids() {
        return archiveids;
    }

    public void setArchiveids(String[] archiveids) {
        this.archiveids = archiveids;
    }

    public String getTreeId() {
        return treeId;
    }

    public void setTreeId(String treeId) {
        this.treeId = treeId;
    }

    public String getQuery() {
        return query;
    }

    @Override
    public void setQuery(String query) {
        this.query = query;
    }

    public String getDaglh() {
        return daglh;
    }

    public void setDaglh(String daglh) {
        this.daglh = daglh;
    }

    public String getCondition() {
        return condition;
    }

    @Override
    public void setCondition(String condition) {
        this.condition = condition;
    }

    /**
     * 获取业务模型
     *
     * @return
     */
    public String resourceList() throws Exception {
        List<Resource> ress = StringUtils.isBlank(id) ? resourceService.getChildrenResource(resourceService.getResource(null, type).getId()) : resourceService.getChildrenResource(id);
        List<Map<Object, Serializable>> list = new ArrayList<Map<Object, Serializable>>();
        for (Resource res : ress) {
            Map<Object, Serializable> map = new HashMap<Object, Serializable>();
            map.put("id", res.getId());
            String text = res.getName();
            map.put("text", text);
            map.put("name", res.getName());
            map.put("title", res.getTitle());
            map.put("content", res.getContent());
            map.put("parentId", res.getParentId());
            map.put("flh", res.getFlh());
            map.put("orderNumber", res.getOrderNumber());
            map.put("iconCls", "no-icon");
            list.add(map);
        }
        Struts2Utils.renderJson(list);
        return null;
    }

    /**
     * 判断查询数据方法
     *
     * @return
     * @throws Exception
     */
    public void archiveList() throws Exception {
        renderJson(getArchiveEntityPage());
    }

    /**
     * 查询数据
     *
     * @return
     */
    protected Page<Archive> getArchiveEntityPage() {
        List<Criterion> criterions = new ArrayList<Criterion>();

        if (StringUtils.isNotBlank(query)) {
            criterions.add(Restrictions.like("id", "%" + query + "%"));
        }
        if (st == 2) {
            criterions.add(Restrictions.eq("state", 3));
        }

        if (StringUtils.isNotBlank(condition)) {
            criterions.addAll(SearchUtils.conditionToCriterion(getFields(), condition));
        }
        if(!SessionUtil.getCurrentUser().isAdmin()){
            criterions.add(Restrictions.or(Restrictions.isNull("dwdm"), Restrictions.like("dwdm", "%" + getDwdm() + "%")));
        }

        criterions.add(Restrictions.isNotNull("yjdh"));

        List<Order> orders = createOrders(new ArrayList<Order>());
        Page<Archive> page = entityService.search(modelName, criterions, orders, start, limit);
        for (Archive archive : page.getItems()) {
            archive.setHasOriginal(originalService.originalIsAll(archive.getId()));
        }

        return page;
    }

    @Override
    protected List<Order> createOrders(final ArrayList<Order> orders) {
        if (StringUtils.isNotEmpty(sort)) {
            if (DIR_ASC.equalsIgnoreCase(dir)) {
                orders.add(Order.asc(sort));
            } else {
                orders.add(Order.desc(sort));
            }
        }
        if (orders.isEmpty()) {
            for (Map.Entry<String, String> entry : getOrderFields().entrySet()) {
                orders.add(entry.getValue().equalsIgnoreCase(DIR_ASC) ? Order.asc(entry.getKey()) : Order.desc(entry.getKey()));
            }
        }
        return orders;
    }

    private List<Map<String, Object>> tree;

    public List<Map<String, Object>> getTree() {
        if (tree == null) {
            List<Map<String, Object>> listTree = treeService.getTree(null, Constants.MODEL_ROOT);
            for (Map item : listTree) {
                logger.debug(item.toString());
                if (item.get("name").equals(Constants.GENERIC)) {
                    listTree.remove(item);
                    break;
                }
            }
            tree = listTree;
        }
        return tree;
    }

    @Override
    public String execute() {
        String location = ServletActionContext.getRequest().getSession().getServletContext().getRealPath("/tpls/permission.json");
        try {
            operationStrs = permissionService.getLeavesId(location); // 获取所有的操作项
        } catch (IOException e) {
            logger.error("读取配置文件permission.json错误，请检查，文件位置为{}",location);
        }

        if (StringUtils.isNotEmpty(modelName)) {
            Resource res = resourceService.findChildResource(null, modelName, Constants.MODEL_ROOT);
            if (res != null) {
                treeId = res.getId();
            } else {
                throw new ModelNotFoundException(modelName);
            }
        }
        modelService.getModel(modelName);
        id = getId();
        if (id != null) {
            Archive archive = archiveService.getArchive(modelName, id);
            if (archive != null) {
                type = archive.getState() == Archive.STATE_YGD ? "ygd" : "wgd";
            }
        }

        return Action.SUCCESS;
    }

    /**
     * 获取超链接字段
     *
     * @return
     */
    public String getLinkField() {
        if (linkField == null) {
            try {
                linkField = archiveService.getArchiveModel(modelName).getTemplate("linkField");
            } catch (Exception ex) {
                linkField = "tm";
            }
        }
        return linkField;
    }



    @Override
    public String getDwdm() {
        String dwdm = userService.getUserRegionCode(SessionUtil.getCurrentUserId());
        ////单位代码用部门代码进行替换
        if (EnvHolder.isEnable(Switch.ORAGAN_NO)) {
            String oraganNo = null;
            List<PfOrganVo> pfOrganVoList = userService.getOrganListByUser(SessionUtil.getCurrentUserId());
            if (pfOrganVoList != null && !pfOrganVoList.isEmpty()) {
                PfOrganVo pfOrganVo = pfOrganVoList.get(0);
                oraganNo = pfOrganVo.getOraganNo();
            }
            dwdm = oraganNo;
        }
        return dwdm;
    }

    /**
     * 预归档（撤销）
     *
     * @return
     */
    public String cxyj() {
        for (int i = 0;i < archiveids.length - 1;i++) {
            if (org.apache.commons.lang3.StringUtils.isBlank(id)) {
                continue;
            }
            Archive archive = archiveService.getArchive(modelName, id);
            archive.setYjdh(null);
            archive.setYjsj(null);

            logManagerService.saveArchiveLogManager(SessionUtil.getCurrentUserId(), SessionUtil.getCurrentUser().getUsername(),
                    archive, "cxygd");
        }
        return null;
    }

    /**
     * 跳转到生成档案管理号页面
     *
     * @return
     */
    public String toSetDaglh() {
        return "setDaglh";
    }

    /**
     * 保存接收单号
     *
     * @return
     */
    public void saveJsdh() {
        DateFormat format = new SimpleDateFormat("yyyyMMddhhmmss");
        Date date = new Date();
        String dates = format.format(date);
        if (StringUtils.isEmpty(dates)) {return;}
        archiveids = archiveids[0].split(",");
        for (int i = 0;i < archiveids.length - 1;i++) {
            Archive archive = archiveService.getSimpleArchive(id);
            archive.setJsdh(dates);
            archive.setJssj(date);
            archive.setJsr(SessionUtil.getCurrentUser().getUsername());
            archiveService.saveArchive(archive);
            logManagerService.saveArchiveLogManager(SessionUtil.getCurrentUserId(), SessionUtil.getCurrentUser().getUsername(),
                    archive, "js");
        }
    }

    /**
     * 撤销入库
     *
     * @return
     */
    public void removeJsdh() {
        archiveids = archiveid.split(",");
        for(int i = 0;i < archiveids.length - 1;i++){
            Archive archive = archiveService.getSimpleArchive(id);
            archive.setJsdh(null);
            archive.setJspch(null);
            archive.setJssj(null);
            archive.setJsr(null);
            archiveService.saveArchive(archive);
        }
    }

    /**
     * 撤销入库
     *
     * @return
     */
    public void removeYjdh() {
        archiveids = archiveid.split(",");
        for(int i = 0;i < archiveids.length - 1;i++){
            Archive archive = archiveService.getSimpleArchive(id);
            archive.setYjdh(null);
            archive.setYjpch(null);
            archive.setYjsj(null);
            archive.setJsdh(null);
            archive.setJspch(null);
            archive.setJssj(null);
            archive.setJsr(null);
            archiveService.saveArchive(archive);
        }
    }

    /**
     * 获取单位符号
     *
     * @return
     */
    public void getDwdmSymbol() {
        Page<Archive> page = this.getArchiveEntityPage();
        if(!page.getItems().isEmpty()) {
            Archive archive = page.getItem(0);
            String dwdm = archive.getDwdm();
            String dwjc = "01";
            if (dwdm != null) {
                List<Item> items = this.dictService.getItems("dwdmSymbol");
                for (Item item : items) {
                    String name = item.getName();
                    if (name.equals(dwdm)) {
                        dwjc = item.getValue();
                        logger.info(dwdm + ":" + dwjc);
                        break;
                    }
                }
            } else {
                logger.error("获取单位简称失败");
            }

            renderJson(dwjc);
        }
    }
}
