package com.gtis.archive.web;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.gtis.archive.Constants;
import com.gtis.archive.Switch;
import com.gtis.archive.core.dict.Item;
import com.gtis.archive.core.environment.EnvHolder;
import com.gtis.archive.core.ex.ModelNotFoundException;
import com.gtis.archive.core.ex.NoPermissionException;
import com.gtis.archive.core.ex.TemplateNotFoundException;
import com.gtis.archive.core.web.BaseModelAction;
import com.gtis.archive.entity.Archive;
import com.gtis.archive.entity.Document;
import com.gtis.archive.entity.Permission;
import com.gtis.archive.entity.Resource;
import com.gtis.archive.service.*;
import com.gtis.archive.util.Struts2Utils;
import com.gtis.common.Page;
import com.gtis.plat.service.SysUserService;
import com.gtis.web.SessionUtil;
import com.opensymphony.xwork2.Action;
import org.apache.commons.lang.StringUtils;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.*;

public class PaperAction extends BaseModelAction<Document> {
    @Autowired
    private ArchiveService archiveService;
    @Autowired
    private ResourceService resourceService;
    @Autowired
    private ExtTreeService treeService;
    @Autowired
    private SecurityService securityService;
    @Autowired
    private OriginalService originalService;

    @Autowired
    private SysUserService userService;

    private List<Map<String, Object>> tree;

    private Map docArchive;
    /**
     * tree id
     */
    private String treeId;
    /**
     * document view type,wlj(未立卷) ylj(已立卷)
     */
    private String type;
    /**
     * 档案id
     */
    private String archiveId;

    /**
     * 链接字段
     */
    private String linkField;

    private String dwdm;

    private String archiveIdString = "archiveId";

    @Override
    public void setModelName(String modelName) {
        super.setModelName(Archive.toDocumentModelName(modelName));
    }

    public void setTreeId(String treeId) {
        this.treeId = treeId;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setArchiveId(String archiveId) {
        this.archiveId = archiveId;
    }

    public String getTreeId() {
        return treeId;
    }

    public String getType() {
        return type;
    }

    @Override
    public String getDwdm() {
        return dwdm;
    }

    public void setDwdm(String dwdm) {
        this.dwdm = dwdm;
    }

    public String getPermJson() {
        List<Item> operations = dictService.getItems(Permission.OPERATION_DICT);
        Map<String, Boolean> perm = new HashMap<String, Boolean>();
        for (Item item : operations) {
            if ("view".equals(item.getName())) {
                perm.put(item.getName(), true);
            }
        }
        return JSON.toJSONString(perm);
    }

    public List<Map<String, Object>> getTree() {
        if (tree == null) {
            List<Map<String, Object>> listTree = treeService.getAllTree(null, Constants.MODEL_ROOT);
            for (Map item : listTree) {
                logger.debug(item.toString());
                if (item.get("name").equals(Constants.GENERIC)) {
                    listTree.remove(item);
                    break;
                }
            }
            tree = listTree;
        }
        return tree;
    }

    @Override
    public String execute() throws Exception {
        String currentDwdm = getCurrentDwdm();
        boolean hasPermission= false;
        try{
            List<Item> items = dictService.getItems(Constants.HUCHA_PREFIX + currentDwdm);
            for (Item item : items) {
                if (item.getValue().equals(this.dwdm)) {
                    hasPermission=true;
                }
            }
        }catch (Exception ex){
            logger.error(ex.getMessage());
        }
        if(!hasPermission) {
            return Action.NONE;
        }
        if (StringUtils.isNotEmpty(modelName)) {
            Resource res = resourceService.findChildResource(null, Document.toArchiveModelName(modelName), Constants.MODEL_ROOT);
            if (res != null) {
                treeId = res.getId();
                if (!EnvHolder.isEnable(Switch.isNewPermission)) {
                    if (!securityService.isPermitted(treeId, Permission.VIEW_PERMISSION)) {
                        throw new NoPermissionException(modelName);
                    }
                }else {
                    if (!securityService.isResPermittedNew(treeId,Permission.VIEW_PERMISSION)){
                        throw new NoPermissionException(modelName);
                    }
                }
            } else {
                throw new ModelNotFoundException(modelName);
            }
        }
        modelService.getModel(modelName);
        String id = getId();
        if (id != null) {
            Document doc = archiveService.getDocument(modelName, id);
            if (doc != null) {
                type = doc.getArchiveId()==null ? "wlj" : "ylj";
            }
        }
        return Action.SUCCESS;
    }

    @Override
    protected Page<Document> searchEntity(List<Criterion> criterions, List<Order> orders) {
        if (StringUtils.isNotEmpty(archiveId)) {
            if(EnvHolder.isEnable(Switch.JIANGYIN)){
                List<Document> documents=  entityService.<Document>search(Archive.toDocumentModelName(modelName),
                        Collections.singletonList(Restrictions.eq(archiveIdString, archiveId)), orders, 0, Page.ALL).getItems();
                if(!documents.isEmpty()){
                    documents.get(0).setArchive(archiveService.getArchive(modelName,archiveId));
                }
                return new Page<Document>(documents);
            }else {
                return new Page<Document>(entityService.<Document>search(Archive.toDocumentModelName(modelName),
                        Collections.singletonList(Restrictions.eq(archiveIdString, archiveId)), orders, 0, Page.ALL).getItems());
            }
        }
        if(EnvHolder.isEnable(Switch.JIANGYIN)){
            Page<Document> page= super.searchEntity(criterions, orders);
            for(Document document:page.getItems()){
                if(StringUtils.isNotBlank(document.getArchiveId())){
                    document.setArchive(archiveService.getArchive(modelName,document.getArchiveId()));
                }
                document.setHasOriginal(originalService.hasOriginal(document.getId()));
            }
            return page;
        }else{
            return super.searchEntity(criterions, orders);
        }

    }

    @Override
    protected List<Criterion> createCriterions(ArrayList<Criterion> criterions) {
        if(type == null || !"all".equals(type)) {
            criterions.add("ylj".equals(type) ? Restrictions.isNotNull(archiveIdString) : Restrictions.isNull(archiveIdString));
        }
        return super.createCriterions(criterions);
    }

    @Override
    protected List<Order> createOrders(ArrayList<Order> orders) {
        List<Order> superOrders = super.createOrders(orders);
        if(!superOrders.isEmpty()) {return superOrders;}
        if (StringUtils.isNotEmpty(archiveId)) {
            orders.add(Order.desc("sxh"));
        }
        orders.add(Order.desc("id"));
        return super.createOrders(orders);
    }

    /**
     *  获取卷内所属的档案
     * @return
     */

    public Map getDocArchive(){
        try{
            if(docArchive==null) {
                docArchive = JSON.parseObject(JSON.toJSONString(archiveService.getArchive(modelName,archiveId), SerializerFeature.WriteMapNullValue));
                docArchive.remove("id");
            }
        }catch(Exception ex){
            logger.error(ex.toString());
        }
        return docArchive;
    }

    public String getLinkField(){
        if(linkField==null){
            try{
                linkField=archiveService.getDocumentModel(modelName).getTemplate("linkField");
            }catch (ModelNotFoundException ex){
                logger.error(ex.getMessage());
            }catch (TemplateNotFoundException ex){
                linkField="tm";
            }
        }
        return linkField;
    }

    private String getCurrentDwdm() {
        dwdm = (String) Struts2Utils.getSessionAttribute("__dwdm");
        if (dwdm == null) {
            dwdm = userService.getUserRegionCode(SessionUtil.getCurrentUserId());
            Struts2Utils.getSession().setAttribute("__dwdm", dwdm);
        }
        return dwdm;
    }

}
