package com.gtis.archive.web;

import com.gtis.archive.core.web.BaseEntityAction;
import com.gtis.archive.entity.Note;
import com.gtis.plat.vo.UserInfo;
import com.gtis.web.SessionUtil;
import org.hibernate.criterion.Restrictions;

import java.util.*;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:wanglei@gtis.com.cn">wanglei</a>
 * @version V1.0, 2010-11-9
 */
public class NoteEntityAction extends BaseEntityAction<Note> {
    private String archiveId;

    private boolean check;

    public void setArchiveId(String archiveId) {
        this.archiveId = archiveId;
    }

    public Boolean getCheck() {
        return check;
    }

    public void setCheck(Boolean check) {
        this.check = check;
    }

    @Override
    public void prepare() {
        UserInfo userInfo = SessionUtil.getCurrentUser();
        entity = entityService.query(Note.class, Restrictions.eq("archiveId", archiveId));
        if (entity == null) {
            entity = new Note();
            entity.setLjr(userInfo.getUsername());
            entity.setLjrq(new Date());
        } else {
            if (check) {
                entity.setJcr(userInfo.getUsername());
                entity.setJcrq(new Date());
            }
        }
    }
    public String check() throws Exception {
        return renderModelTemplate("check");
    }
}
