package com.gtis.archive.web;

import com.gtis.archive.service.ArchiveService;
import com.gtis.archive.service.GatewayService;
import com.gtis.archive.service.sv.SqlServerService;
import com.gtis.common.Page;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import javax.annotation.Resource;
import java.util.Date;
import java.util.Map;

import static com.gtis.archive.util.Struts2Utils.renderJson;

/**
 * Created by wangxinyi on 2018/5/24.
 */
public class MyTask {
    private static final Logger logger = LoggerFactory.getLogger(MyTask.class);
    @Resource
    private ArchiveService archiveService;
    @Resource
    private GatewayService gatewayService;
    @Resource
    private SqlServerService sqlServerService;

    /**
     * 获取案卷信息
     */
    public void floodData() {
        Date date = new Date();
        logger.info("开始执行" + date);
    }

    /*
     *马鞍山收发文数据 定时任务
     */
    @Transactional
    public void getTransmitXml() {
        Page<Map<String, Object>> page;
        //       String esql = "select * from dbo.OA_MAINTAIN where DateDiff(dd,RECVDATE,getdate())<=1";
        String esql = "select * from dbo.OA_MAINTAIN where datediff(week,RECVDATE,getdate()) = 0";
        logger.error(esql);
        try {
            page = sqlServerService.getTransmitDate(esql);
            for (int i = 0; i < page.getItems().size(); i++) {
                Map<String,Object> map = page.getItem(i);
                String s = gatewayService.getTransmitXmlData(map);
                String ss = gatewayService.in(s);
                renderJson(ss);
                logger.info(map.get("ID").toString() + map.get("TM").toString());
            }
        } catch (Exception e) {
            logger.error("导入数据错误" + e, e);
        }
    }
}
