package com.gtis.archive.web;

import com.gtis.archive.entity.Original;
import com.gtis.archive.service.OriginalService;
import com.opensymphony.xwork2.ActionSupport;

import org.springframework.beans.factory.annotation.Autowired;

/**
 * @作者 王建明
 * @创建日期 2017/10/26 0026
 * @创建时间 下午 8:09
 * @版本号 V 1.0
 */
public class MediaAction extends ActionSupport {
	@Autowired
	private OriginalService originalService;
	private String id;
	private String fileType;

	/**
	 * @作者 王建明
	 * @创建日期 2017/10/26 0026
	 * @创建时间 下午 7:34
	 * @描述 —— 媒体播放页面
	 */
	public String play() throws Exception {
		if(fileType.equalsIgnoreCase("mp3") || fileType.equalsIgnoreCase("mpg") || fileType.equalsIgnoreCase("mov")){
			return "playmp3";
		}else {
			return "play";
		}
	}

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getFileType() {
		Original original = originalService.getOriginal(id);
		if(original != null) {
			fileType = original.getName();
		}
		return fileType;
	}

	public void setFileType(String fileType) {
		this.fileType = fileType;
	}
}
