package com.gtis.archive.web;

import com.alibaba.fastjson.JSON;

import com.gtis.archive.core.Field;
import com.gtis.archive.core.Model;
import com.gtis.archive.core.dict.Item;
import com.gtis.archive.core.ex.ModelNotFoundException;

import com.gtis.archive.core.ex.TemplateNotFoundException;
import com.gtis.archive.core.web.BaseModelAction;

import com.gtis.archive.entity.Resource;
import com.gtis.archive.service.ArchiveService;
import com.gtis.archive.service.PermissionService;
import com.gtis.archive.service.ResourceService;
import com.gtis.archive.service.SecurityService;

import com.gtis.archive.util.Struts2Utils;

import com.opensymphony.xwork2.Action;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;

import org.springframework.beans.factory.annotation.Autowired;

import java.io.IOException;
import java.io.Serializable;
import java.util.*;

/**
 * Created with IntelliJ IDEA.
 * User: zhangbixi
 * Date: 12-10-18
 * Time: 下午4:32
 * To change this template use File | Settings | File Templates.
 */
public class MainAction extends BaseModelAction {

    @Autowired
    private ResourceService resourceService;

    @Autowired
    private ArchiveService archiveService;

    @Autowired
    private SecurityService securityService;

    @Autowired
    private PermissionService permissionService;

    private String treeId;

    private String id;

    private Map showFields;

    private Map docShowFields;

    private List<Item> operations;
    private Map<String, String> topMenu;

    /**
     * 权限项
     */
    private List<String> operationStr;

    @Override
    public String execute() {
        String location = ServletActionContext.getRequest().getSession().getServletContext().getRealPath("/tpls/permission.json");
        try {
            operationStr = permissionService.getLeavesId(location);
        } catch (IOException e) {
            logger.error("读取permission.json错误,请检查路径{}permission.json文件是否存在",location);
        }
        return Action.SUCCESS;
    }

    public String node() throws Exception {
        String modelText = "model";
        List<Resource> ress = StringUtils.isBlank(id) ? resourceService.getChildrenResource(resourceService.getResource(null, modelText).getId()) : resourceService.getChildrenResource(id);
        List<Map<Object, Serializable>> list = new ArrayList<Map<Object, Serializable>>();
        for (Resource res : ress) {
            Map<Object, Serializable> map = new HashMap<Object, Serializable>();
            map.put("id", res.getId());
            String text = res.getName();
            if (!res.getParentId().equals(resourceService.getResource(null, modelText).getId()) && StringUtils.isNotEmpty(res.getTitle())) {

                    text = res.getTitle();

            }
            map.put("text", text);
            map.put("name", res.getName());
            map.put("title", res.getTitle());
            map.put("content", res.getContent());
            map.put("parentId", res.getParentId());
            map.put("flh", res.getFlh());
            map.put("orderNumber", res.getOrderNumber());
            map.put("iconCls", modelText);
            list.add(map);
        }
        Struts2Utils.renderJson(list);
        return null;
    }

    @Override
    public Map getShowFields() {
        if (showFields == null) {
            showFields = JSON.parseObject(getEntityTemplate("showFields"), LinkedHashMap.class);
        }
        Map<String, Field> fileds = getFields();
        StringBuilder sb = new StringBuilder("{\"result\":[");
        Iterator iter = showFields.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry) iter.next();
            StringBuilder content = new StringBuilder("{\"fieldName\":");
            String key = entry.getKey().toString();
            content.append("\"" + key + "\",\"title\":\"" + fileds.get(key).getTitle() + "\",");
            Map val = (Map) entry.getValue();
            Iterator it = val.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry en = (Map.Entry) it.next();
                String keyV = en.getKey().toString();
                String value = en.getValue().toString();
                content.append("\"" + keyV + "\":\"" + value + "\"");
                if (it.hasNext()) {
                    content.append(",");
                }
            }
            if (iter.hasNext()) {
                content.append("},");
                sb.append(content.toString());
            } else {
                content.append("}");
                sb.append(content.toString() + "]}");
            }
        }
        Struts2Utils.renderJson(sb.toString());
        return null;
    }

    /**
     * 获取卷被的字段
     * @return
     */
    public Map getDocShowFields() {
        if (docShowFields == null) {
            try {
                Model doc = archiveService.getDocumentModel(modelName);
                docShowFields = JSON.parseObject(doc.getTemplate("showFields"), LinkedHashMap.class);
            } catch (ModelNotFoundException ex) {
                logger.error(ex.getMessage());
            } catch (TemplateNotFoundException ex) {
                docShowFields = JSON.parseObject(getEntityTemplate("Document-showFields"), LinkedHashMap.class);
            }
        }

        Map<String, Field> fileds = getDocFields();
        StringBuilder sb = new StringBuilder("{\"result\":[");
        Iterator iter = docShowFields.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry) iter.next();
            StringBuilder content = new StringBuilder("{\"fieldName\":");
            String key = entry.getKey().toString();
            content.append("\"" + key + "\",\"title\":\"" + fileds.get(key).getTitle() + "\",");
            Map val = (Map) entry.getValue();
            Iterator it = val.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry en = (Map.Entry) it.next();
                String keyV = en.getKey().toString();
                String value = en.getValue().toString();
                content.append("\"" + keyV + "\":\"" + value + "\"");
                if (it.hasNext()) {
                    content.append(",");
                }
            }
            if (iter.hasNext()) {
                content.append("},");
                sb.append(content.toString());
            } else {
                content.append("}");
                sb.append(content.toString() + "]}");
            }
        }
        Struts2Utils.renderJson(sb.toString());
        return null;
    }

    public Map getDocFields() {
        Map docFields = null;
        try {
            Model doc = archiveService.getDocumentModel(modelName);
            docFields = doc.getInheritfieldsMap();
        } catch (ModelNotFoundException ex) {
            logger.error(ex.getMessage());
        }
        return docFields;
    }


    public String getTreeId() {
        return treeId;
    }

    public void setTreeId(String treeId) {
        this.treeId = treeId;
    }

    @Override
    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Map<String, String> getTopMenu() {
        if (topMenu == null) {
            topMenu = new LinkedHashMap<String, String>();
            for (Item item : dictService.getItems("archiveMenu")) {
                if ("true".equalsIgnoreCase(item.getValue())) {
                    topMenu.put(item.getName(), item.getRemark());
                }
            }
        }
        return topMenu;
    }

    public String getPermJson() {
        Map<String, Boolean> perm = new HashMap<String, Boolean>();

        if (operationStr == null) {
            String location = ServletActionContext.getRequest().getSession().getServletContext().getRealPath("/tpls/permission.json");
            try {
                operationStr = permissionService.getLeavesId(location);
                for (String s : operationStr) {
                    perm.put(s, true);
                }
            } catch (IOException e) {
                logger.error("读取permission.json错误,请检查路径" + location + "permission.json文件是否存在",e);
            }
        }
        if (treeId != null) {
            Struts2Utils.renderJson(perm);
        }
        return null;
    }

    public List<Item> getOperations() {
        return operations;
    }

    public List<String> getOeprationStr() {
        return operationStr;
    }
}
