package com.gtis.archive.web;

import java.lang.reflect.Field;

import java.util.Date;

import com.gtis.archive.service.ArchiveService;
import com.gtis.archive.service.GatewayService;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

import com.gtis.archive.Switch;
import com.gtis.archive.core.EntityService;
import com.gtis.archive.core.environment.EnvHolder;
import com.gtis.archive.core.web.BaseEntityAction;
import com.gtis.archive.entity.Archive;
import com.gtis.archive.entity.Document;
import com.gtis.archive.entity.Loan;
import com.gtis.archive.entity.LoanCart;
import com.gtis.archive.service.LoanService;
import com.gtis.archive.util.Struts2Utils;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.vo.UserInfo;
import com.gtis.web.SessionUtil;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:wanggang@gtis.com.cn">WangGang</a>
 * @version V1.0, 2010-11-9
 */
public class LoanEntityAction extends BaseEntityAction<Loan> {

    @Autowired
    private SysUserService userService;

    @Autowired
    private LoanService loanService;

    @Autowired
    private EntityService entityService;

    @Autowired
    private GatewayService gatewayService;

    @Autowired
    private ArchiveService archiveService;

    private String archiveId;

    private String type;
    private String mold;
    private String print;
    private String fn = "onComplete";
    private String redenJsOpen = "(opener||parent||self||top).";
    private String trueText = "(true,'";
    private String currentAid = "currentAId";
    @Override
    public String preview() throws Exception {
        try {
            if ("return".equals(type)) {
                return renderModelTemplate("preview-return");
            } else if ("view".equals(type)) {
                return renderModelTemplate("preview-view");
            } else {
                return renderModelTemplate("preview");
            }
        } catch (Exception ex) {
            return renderModelTemplate("preview");
        }
    }

    public String renderReturnTpl() {
        try {
            entity.setGhrq(new Date());
            return renderModelTemplate("return");
        } catch (Exception e) {
            logger.error("template is not exits:" + e.toString(),e);
        }

        return null;
    }

    @Override
    public String execute() throws Exception {
        try {
            if ("view".equals(mold)) {
                return renderModelTemplate("view");
            } else {
                return renderModelTemplate("edit");
            }
        } catch (Exception e) {
            logger.error("获取view模板出错：" + e.getMessage(),e);
            return renderModelTemplate("edit");
        }
    }

    public void saveLoan(Loan entity){
        entity.setState(1);
        this.entityService.save(entity);

        String successMessage = "归还成功";
        Struts2Utils.renderJs(redenJsOpen + fn + trueText + successMessage + "');");
    }

    @Override
    protected void doSave(Loan entity){
        if(StringUtils.isNotBlank(entity.getSatisfy())){
            entity.setSatisfy("不满意".equals(entity.getSatisfy()) ? "0" : "1");
        }
        String[] archiveIds = StringUtils.split(entity.getArchiveId(), ",");
        String[] loanIds = new String[archiveIds.length];
        String judgeLyg = EnvHolder.getAppEnv().get("lianyungang.enable");

        if (entity.isBackNow()) {
            if (judgeLyg.equalsIgnoreCase("true")) {
                String mothed = "RFIDReturnDA";   //连云港归还档案接口
                String dh = entity.getDh();
                if (dh == null) {
                    String aId = entity.getArchiveId();
                    Archive archive = archiveService.getSimpleArchive(aId);
                    dh = archive.getDh();
                }
                String remark = gatewayService.translate(dh, mothed);
                if (remark.equals("操作失败")) {

                    String successMessage = "档案" + dh + "归还库管系统失败";
                    Struts2Utils.renderJs(redenJsOpen + fn + trueText + successMessage + "');");
                } else {
                    entity.setState(1);
                    this.entityService.save(entity);

                    String successMessage = "归还成功";
                    Struts2Utils.renderJs(redenJsOpen + fn + trueText + successMessage + "');");
                }
            }else {
                entity.setState(1);
                this.entityService.save(entity);
                fn = "onComplete";
                String successMessage = "归还成功";
                Struts2Utils.renderJs(redenJsOpen + fn + trueText + successMessage + "');");
            }
        } else if(entity.getEditXg()){
            entityService.save(entity);
        }else {
            UserInfo userInfo = SessionUtil.getCurrentUser();
            String entityName = "";
            try {
                entityName = PropertyUtils.getProperty(entity, "type").toString();
            } catch (Exception e) {
                logger.error(e.getMessage());
            }
            for (int i = 0; i < archiveIds.length; i++) {
                try {
                    Loan loan = loanService.findLoanById(entity.getId());
                    if (loan == null) {
                        loan = entity.clone();
                    }
                    loan.setArchiveId(StringUtils.trim(archiveIds[i]));
                    if (EnvHolder.isEnable(Switch.DWDM)) {loan.setDwdm(getDwdm());}
                    if ("查阅".equals(mold) || "view".equals(mold)) {
                        loan.setState(2);
                        loan.setLoanType("查阅");
                    }else {
                        loan.setLoanType("借阅");
                    }
                    if(loan.getLoanType().isEmpty()){
                        loan.setSfpz(0);
                    }else {
                        loan.setSfpz(4);
                    }
                    loan.setPch(loan.getJyr() + loan.getJyrq());
                    loan.setUserId(userInfo.getId());
                    loan.setJc(String.valueOf(archiveIds.length));
                    if (StringUtils.isNotBlank(entityName)) {
                        if (entityName.indexOf("_jn") != -1) {
                            Document document = entityService.load(entityName, loan.getArchiveId());
                            if (document.getArchive() != null || document.getArchiveId() != null) {
                                Archive archive = document.getArchive() == null ?
                                        (Archive) entityService.load(Archive.class, document.getArchiveId()) :
                                        document.getArchive();
                                if (archive != null) {
                                    loan.setDh(archive.getDh());
                                    loan.setAjh(String.valueOf(archive.getAjh()));
                                    loan.setMlh(archive.getMlh());
                                }
                            }
                            loan.setTm(document.getTm());
                        } else {
                            Archive arvhice = entityService.load(entityName, loan.getArchiveId());
                            if (arvhice != null) {
                                loan.setDh(arvhice.getDh());
                                if(!(arvhice.getTm() == null || arvhice.getTm().isEmpty())) {
                                    loan.setTm(arvhice.getTm());
                                }else if(isExist(arvhice.getClass(),"qlrmc")){
                                    loan.setTm(PropertyUtils.getProperty(arvhice,"qlrmc").toString());
                                }else{
                                    loan.setTm("档案查借阅");
                                }
                                loan.setAjh(String.valueOf(arvhice.getAjh()));
                                loan.setMlh(arvhice.getMlh());
                            }
                        }
                        loan.setType(entityName);
                    } else {
                        if (StringUtils.isNotBlank(entity.getLoanCartId())) {
                            String[] loanCartIds = StringUtils.split(entity.getLoanCartId(), ",");
                            String loanCartId = loanCartIds[i].trim();
                            LoanCart loanCart = entityService.load(LoanCart.class, loanCartId);
                            loan.setDh(loanCart.getDh());
                            loan.setTm(loanCart.getTm());
                            loan.setType(loanCart.getArchiveType());
                            loan.setMlh(loanCart.getMlh());
                            loan.setAjh(loanCart.getAjh());
                        }
                    }
                    if (judgeLyg.equalsIgnoreCase("true")) {
                        if (loan.getLoanType().equals("借阅")) {
                            String mothed = "RFIDBorrowDA";   //连云港借阅档案接口
                            String dh = entity.getDh();
                            if (dh == null) {
                                String aId = entity.getArchiveId();
                                Archive archive = archiveService.getSimpleArchive(aId);
                                dh = archive.getDh();
                            }
                            String remark = gatewayService.translate(dh, mothed);
                            if (remark.equals("操作失败")) {
                                entityService.save(loan);
                                loanIds[i] = loan.getId();
                                session.put(currentAid, loan.getId());
                            } else {
                                String successMessage = "档案" + dh + "从库管系统借阅失败";
                                Struts2Utils.renderJs(redenJsOpen + fn + trueText + successMessage + "');");
                            }
                        } else {
                            entityService.save(loan);
                            loanIds[i] = loan.getId();
                            session.put(currentAid, loan.getId());
                        }
                    }else {
                        entityService.save(loan);
                        loanIds[i] = loan.getId();
                        session.put(currentAid, loan.getId());
                    }
                } catch (Exception ex) {
                    logger.error(ex.getMessage());
                }
            }

            String[] loanCartIds = StringUtils.split(entity.getLoanCartId(), ",");
            for (String id : loanCartIds) {
                loanService.removeFromCart(entityService.load(LoanCart.class, id.trim()));
            }
        }
    }

    @Override
    protected String getSuccessMsg(){
        return mold;
    }

    @Override
    protected String getJsCallBack() {
        return "onLoanComplete";
    }

    private String getDwdm() {
        String dwdm = (String) Struts2Utils.getSessionAttribute("__dwdm");
        if (dwdm == null) {
            dwdm = userService.getUserRegionCode(SessionUtil.getCurrentUserId());
            Struts2Utils.getSession().setAttribute("__dwdm", dwdm);
        }
        return dwdm;
    }

    @Override
    public void prepare() {
        UserInfo userInfo = SessionUtil.getCurrentUser();
        if(StringUtils.isNotBlank(print) && print != null && "scan".equals(print)){
            String id = (String) session.get(currentAid);
            entity = loanService.findLoanById(id);
        }else {
            entity = StringUtils.isBlank(id) ? (Loan)entityService.newInstance(modelName) : entityService.<Loan>load(modelName, id);
        }
        if(entity.getJyr() == null) {
            entity.setJyrq(new Date());
            entity.setJyr(userInfo.getUsername());
            if (StringUtils.isNotBlank(archiveId)) {
                try {
                    PropertyUtils.setProperty(entity, "jc", String.valueOf(archiveId.split(",").length));
                    PropertyUtils.setProperty(entity, "type", type);
                } catch (Exception e) {
                    logger.error(e.getMessage());
                }
            }
        }
    }

    //归还
    public String returnLoan(String[] ids) {
        for (String id : ids) {
            if (StringUtils.isBlank(id)) {
                continue;
            }
            Loan loan = entityService.load(Loan.class, id);
            loan.setState(1);
            entityService.save(loan);
        }
        return null;
    }

    public boolean isExist(Class loan,String name){
        Field[] fields=loan.getDeclaredFields();
        boolean b=false;
        for(int i=0;i<fields.length;i++) {
            if (fields[i].getName().equals(name)) {
                b = true;
                break;
            }
        }
        return b;
    }

    public String getArchiveId() {
        return archiveId;
    }

    public void setArchiveId(String archiveId) {
        this.archiveId = archiveId;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getMold() {
        return mold;
    }

    public void setMold(String mold) {
        this.mold = mold;
    }

    public String getPrint() {
        return print;
    }

    public void setPrint(String print) {
        this.print = print;
    }
}
