package com.gtis.archive.web;

import com.alibaba.fastjson.JSON;
import com.gtis.archive.Switch;
import com.gtis.archive.core.environment.EnvHolder;
import com.gtis.archive.core.ex.NoPermissionException;
import com.gtis.archive.core.support.hibernate.UUIDHexGenerator;
import com.gtis.archive.core.web.BaseModelAction;
import com.gtis.archive.entity.*;
import com.gtis.archive.service.LoanService;
import com.gtis.archive.service.SecurityService;
import com.gtis.archive.util.Struts2Utils;
import com.gtis.common.Page;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.vo.UserInfo;
import com.gtis.web.SessionUtil;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.hibernate.type.StandardBasicTypes;
import org.springframework.beans.factory.annotation.Autowired;
import java.util.*;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:wanggang@gtis.com.cn">WangGang</a>
 * @version V1.0, 2010-11-9
 */
public class LoanAction extends BaseModelAction<Loan> {
    @Autowired
    private SecurityService securityService;
    @Autowired
    private SysUserService userService;
    @Autowired
    private LoanService loanService;
    private String idString;

    protected static final Map<String, String[]> idCaches = Collections.synchronizedMap(new LRUMap(500));


    public String getIdString() {
        return idString;
    }

    public void setIdString(String idString) {
        this.idString = idString;
    }

    /**
     * 列表要显示的字段
     */
    private Map showFields;

    private String type;

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return type;
    }

    /**
     * 审批状态
     */
    private int sfpz;

    /**
     * 借阅类型
     */
    private String loanType;
    private Integer state;
    private String userIdText = "userId";
    private String stateText = "state";
    private String borrow = "borrow";
    private String unPass = "unpass";



    /**
     *
     * 打印类型
     */
    private String printType;

    public Integer getState() {
        return state;
    }

    public void setState(Integer state) {
        this.state = state;
    }

    public int getSfpz() {
        return sfpz;
    }

    public void seoSfpz(int sfpz) {
        this.sfpz = sfpz;
    }

    public String getLoanType() {
        return loanType;
    }

    public void setLoanType(String loanType) {
        this.loanType = loanType;
    }

    public String getPrintType() {
        return printType;
    }

    @Override
    public void setPrintType(String printType) {
        this.printType = printType;
    }

    //归还档案
    public String returnLoan() {
        for (String id : ids) {
            if (StringUtils.isBlank(id)) {
                continue;
            }
            Loan loan = entityService.load(Loan.class, id);
            loan.setState(1);
            loan.setGhrq(new Date());
            entityService.save(loan);
        }
        return null;
    }

    /**
     *  获取借阅的内容
     */
    public void loanList() {
        UserInfo userInfo = SessionUtil.getCurrentUser();
        List<Criterion> criterions = createCriterions(new ArrayList<Criterion>());
        criterions.add(Restrictions.eq(userIdText, userInfo.getId()));
        criterions.add(Restrictions.eq("sfpz", 4));
        Page<Loan> loanPage = loanService.pageLoan(start, limit, criterions);

        for (Loan loan : loanPage.getItems()) {
            loan.setHasOriginal(originalService.hasOriginal(loan.getId()));
        }
        renderJson(loanPage);
    }

    /**
     *  打印借阅的内容
     */
    public Page<Loan> loanListP() {
        UserInfo userInfo = SessionUtil.getCurrentUser();
        List<Criterion> criterions = createCriterions(new ArrayList<Criterion>());
        criterions.add(Restrictions.eq(userIdText, userInfo.getId()));
        criterions.add(Restrictions.eq("sfpz", 4));
        Page<Loan> loanPage = loanService.pageLoan(start, limit, criterions);

        for (Loan loan : loanPage.getItems()) {
            loan.setHasOriginal(originalService.hasOriginal(loan.getId()));
        }
        return loanPage;
    }

    /**
     * 审核通过
     */
    public void examed() {
        for (String id : ids) {
            if (StringUtils.isBlank(id)) {
                continue;
            }
            Loan loan = entityService.load(Loan.class, id);
            loan.setPzld(SessionUtil.getCurrentUser().getUsername());
            loan.setSfpz(2);
            entityService.save(loan);
        }
    }

    /**
     * 审核不通过
     */
    public void unexamed() {
        for (String id : ids) {
            if (StringUtils.isBlank(id)) {
                continue;
            }
            Loan loan = entityService.load(Loan.class, id);
            loan.setSfpz(1);
            entityService.save(loan);
        }
    }
    @Override
    public Map getShowFields() {
        if (showFields == null) {
            showFields = JSON.parseObject(getEntityTemplate("showFields"), LinkedHashMap.class);
        }
        return showFields == null ? Collections.emptyMap() : showFields;
    }

    @Override
    protected Page<Loan> searchEntity(final List<Criterion> criterions, final List<Order> orders) {
        String loanTypeText = "loanType";
        if (!StringUtils.isBlank(idString)) {
            Loan loan = loanService.findLoanById(idString);
            List<Loan> loans = new ArrayList<Loan>();
            loans.add(loan);
            Page<Loan> loanPage = new Page<Loan>();
            loanPage.setItems(loans);

            return loanPage;
        }else {

            if ("exam".equals(type)) {
                criterions.add(Restrictions.eq("sfpz", sfpz));
            } else if ("view".equals(type)) {
                criterions.add(Restrictions.eq("sfpz", 2));
                criterions.add(Restrictions.eq(loanTypeText, dictService.getItemName(Permission.LOANTYPE_DICT, loanType)));
            } else if ("loaned".equals(type)) {
                criterions.add(Restrictions.eq("sfpz", 2));
                if (state != null) {
                    criterions.add(Restrictions.eq(stateText, state));
                }
                criterions.add(Restrictions.eq(loanTypeText, dictService.getItemName(Permission.LOANTYPE_DICT, loanType)));
            } else if ("exceed".equals(type)) {
                criterions.add(Restrictions.sqlRestriction("jyrq+jyqx<?", new Date(), StandardBasicTypes.DATE));
                criterions.add(Restrictions.eq("sfpz", 2));
                criterions.add(Restrictions.eq(stateText, 0));
                criterions.add(Restrictions.eq(loanTypeText, dictService.getItemName(Permission.LOANTYPE_DICT, loanType)));
            } else if (borrow.equals(type)) {
                criterions.add(Restrictions.eq("sfpz", sfpz));
            }

            if (query != null) {
                criterions.add(Restrictions.or(Restrictions.like("arc.tm", "%" + query + "%"), Restrictions.like("arc.dh", "%" + query + "%")));
            }

            if (EnvHolder.isEnable(Switch.DWDM) && !SessionUtil.getCurrentUser().isAdmin()) {
                criterions.add(Restrictions.or(Restrictions.isNull("dwdm"), Restrictions.eq("dwdm", getDwdm())));
            }

            Page<Loan> page = entityService.search(Loan.class, criterions, orders, start, limit);
            for (Loan loan : page.getItems()) {
                loan.setViewState(loanService.viewState(loan.getId()));
            }

            return page;
        }
    }

    @Override
    protected String[] getQueryFields() {
        return new String[0];
    }

    @Override
    public String getDwdm() {
        String dwdm = (String) Struts2Utils.getSessionAttribute("__dwdm");
        if (dwdm == null) {
            dwdm = userService.getUserRegionCode(SessionUtil.getCurrentUserId());
            Struts2Utils.getSession().setAttribute("__dwdm", dwdm);
        }
        return dwdm;
    }

    @Override
    public String execute() throws Exception {
        if (!EnvHolder.isEnable(Switch.isNewPermission)) {
            if (!securityService.isPermitted("sys", "loan")) {
                throw new NoPermissionException("没有权限访问借阅管理");
            }
        }else {
            if (!securityService.isResPermittedNew("sys","loan")){
                throw new NoPermissionException("没有权限访问借阅管理");
            }
        }
        return super.execute();
    }
    public String toGetLoanByUser() {
        return "list";
    }

    /**
     * 获取用户已批准的借阅
     */
   public Page<Loan> getLoanByUserP(){
       this.loanType = "0";
       String userId = SessionUtil.getCurrentUserId();
       List<Criterion> criterions =createCriterions(new ArrayList<Criterion>());
       List<Order> orders = createOrders(new ArrayList<Order>());
       criterions.add(Restrictions.sqlRestriction("jyrq+jyqx>=?", new Date(), StandardBasicTypes.DATE));
       criterions.add(Restrictions.eq("sfpz", 2));
       criterions.add(Restrictions.or(Restrictions.eq(stateText, 0),Restrictions.eq(stateText, 2)));
       criterions.add(Restrictions.eq(userIdText,userId));
       return entityService.search(Loan.class.getSimpleName(),criterions,orders,start,limit);
   }

    /**
     * 打印用户已批准的查借阅
     */
    public void getLoanByUser(){
        String userId = SessionUtil.getCurrentUserId();
        List<Criterion> criterions =createCriterions(new ArrayList<Criterion>());
        List<Order> orders = createOrders(new ArrayList<Order>());
        criterions.add(Restrictions.sqlRestriction("jyrq+jyqx>=?", new Date(), StandardBasicTypes.DATE));
        criterions.add(Restrictions.eq("sfpz", 2));
        criterions.add(Restrictions.or(Restrictions.eq(stateText, 0),Restrictions.eq(stateText, 2)));
        criterions.add(Restrictions.eq(userIdText,userId));
        Page<Loan> loans = entityService.search(Loan.class.getSimpleName(),criterions,orders,start,limit);
        Struts2Utils.renderJson(loans);
    }

    public String toGetUnpass() {
        return unPass;
    }

    //获取当前用户审批未通过的借阅
    public void getLoanUnpass(){
        List<Criterion> criterions = createCriterions(new ArrayList<Criterion>());
        String userId = SessionUtil.getCurrentUserId();
        List<Order> orders = createOrders(new ArrayList<Order>());
        criterions.add(Restrictions.eq(userIdText,userId));
        criterions.add(Restrictions.eq("sfpz",1));
        Page<Loan> loans = entityService.search(Loan.class.getSimpleName(),criterions,orders,start,limit);
        Struts2Utils.renderJson(loans);
    }

    //打印当前用户审批未通过的借阅
    public Page<Loan> getLoanUnpassP(){
        List<Criterion> criterions = createCriterions(new ArrayList<Criterion>());
        String userId = SessionUtil.getCurrentUserId();
        List<Order> orders = createOrders(new ArrayList<Order>());
        criterions.add(Restrictions.eq(userIdText,userId));
        criterions.add(Restrictions.eq("sfpz",1));
        return entityService.search(Loan.class.getSimpleName(),criterions,orders,start,limit);
    }

    public void getLoanCount() {
        String dwdm = getDwdm();
        Integer count = loanService.getLoanCount(new ArrayList<Criterion>(), dwdm);
        Struts2Utils.renderText(count.toString());
    }

    public String getLoantype() {
        String loantype = null;
        try {
            if (idString != null) {
                Loan loan = loanService.findLoanById(idString);
                loantype = loan.getLoanType();
            }
        }catch (Exception e){
            logger.error(e.getMessage());
        }
        return renderJson(loantype);
    }

    public String loanSave() {
        try {
            for (String id : ids) {
                if (StringUtils.isBlank(id)) {
                    continue;
                }
                Loan loan = entityService.load(Loan.class, id);
                loan.setSfpz(0);
                entityService.save(loan);
            }
        }catch (Exception e){
            logger.error("借阅车登记：" + e.getMessage(),e);
            return renderJson("登记失败！");
        }
        return renderJson("登记成功！");
    }

    /**
     * 获取借阅档案的modelName
     */
    public void getLoanById() {
        Loan loan = entityService.load(Loan.class, idString);
        LoanCart loanCart = null;
        Archive archive = null;
        Document doc = null;
        if (loan ==  null) {
            loanCart = entityService.load(LoanCart.class, idString);
        }
        if (loan != null) {
            if (loan.getType().contains("_jn")) {
                doc = entityService.load(loan.getType(), loan.getArchiveId());
            } else {
                archive = entityService.load(loan.getType(), loan.getArchiveId());
            }
        } else if (loanCart != null) {
            if (loanCart.getArchiveType().contains("_jn")) {
                doc = entityService.load(loanCart.getArchiveType(), loanCart.getArchiveId());
            } else {
                archive = entityService.load(loanCart.getArchiveType(), loanCart.getArchiveId());
            }
        }

        Map map = new HashMap();
        if (archive != null) {
            map.put("modelName", archive.getModelName());
            map.put("resourceId", archive.getResourceId());
        } else if(doc != null){
            map.put("modelName", doc.getModelName());
            map.put("ajModelName",Document.toArchiveModelName(doc.getModelName()));
            map.put("archiveId", doc.getArchiveId());
        }

        renderJson(map);
    }

    @Override
    public String cacheIds() {
        String key = UUIDHexGenerator.generate();
        idsCaches.put(key, ids);
        return renderJson(Collections.singletonMap("idsKey", key));
    }

    @Override
    public String print() throws Exception {
        isPrint = true;
        if(borrow.equals(printType)) {
            entities = loanListP().getItems();
        }else if(unPass.equals(printType)){
            entities = getLoanUnpassP().getItems();
        }else if("byUaer".equals(printType)){
            entities = getLoanByUserP().getItems();
        }
        return renderTemplate(getEntityModel().getTemplate("print"));
    }

    @Override
    public String export() throws Exception {
        ServletActionContext.getResponse().setContentType("application/vnd.ms-excel");
        ServletActionContext.getResponse().setHeader("Content-Disposition", "attachment; filename=" + modelName + "-export.xls");
        if(borrow.equals(printType)) {
            entities = loanListP().getItems();
        }else if(unPass.equals(printType)){
            entities = getLoanUnpassP().getItems();
        }else if("byUaer".equals(printType)){
            entities = getLoanByUserP().getItems();
        }
        return renderModelTemplate("export");
    }
}
