package com.gtis.archive.web;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.gtis.archive.Switch;
import com.gtis.archive.core.Field;
import com.gtis.archive.core.Model;
import com.gtis.archive.core.ModelService;
import com.gtis.archive.core.dict.DictService;
import com.gtis.archive.core.environment.EnvHolder;
import com.gtis.archive.core.ex.ModelNotFoundException;
import com.gtis.archive.core.ex.TemplateNotFoundException;
import com.gtis.archive.entity.Archive;
import com.gtis.archive.entity.Document;
import com.gtis.archive.entity.LogManager;
import com.gtis.archive.entity.Original;
import com.gtis.archive.service.*;
import com.gtis.archive.util.ReportCache;
import com.gtis.archive.util.Struts2Utils;
import com.gtis.common.Page;
import com.gtis.web.SessionUtil;
import com.opensymphony.xwork2.Action;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.convention.annotation.InterceptorRef;
import org.apache.struts2.convention.annotation.InterceptorRefs;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.FileCopyUtils;

import javax.servlet.http.HttpServletRequest;
import java.awt.image.BufferedImage;
import java.io.*;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

import static com.gtis.archive.util.Struts2Utils.renderJson;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2010-9-30
 */
@InterceptorRefs({@InterceptorRef(value = "fileUpload", params = {"maximumSize", "5368709120"}), @InterceptorRef(value = "defaultStack")})
public class GatewayAction implements Action {
    private static final Logger logger = LoggerFactory.getLogger(GatewayAction.class);

    @Autowired
    private GatewayService gatewayService;

    @Autowired
    private DictService dictService;

    @Autowired
    private FileToPicService fileToPicService;

    @Autowired
    private ArchiveService archiveService;

    @Autowired
    protected ModelService modelService;

    @Autowired
    private OriginalService originalService;
    @Autowired
    private LogManagerService logManagerService;
    @Autowired
    public ReportCache reportCache;

    private String data;

    private String id;

    private String proid;
    private String gdr;
    private String modelName;

    private String mlh;  //目录号

    private Map docShowFields;
    private Map docFields;

    private String tm;

    /** 档号 */
    private String dh;

    /**
     * 链接字段
     */
    private String linkField;
    private String archiveId;

    /**
     * 列表要显示的字段
     */
    private Map showFields;

    /** 原文id **/
    private String originalId;

    //证件号码
    private String zjhm;
    //随机码
    private String code;
    //马鞍山触摸屏个人查询
    private Integer catalogType;

    private String archiveString = "Archive";

    public Integer getCatalogType() {
        return catalogType;
    }

    public void setCatalogType(Integer catalogType) {
        this.catalogType = catalogType;
    }

    public static Logger getLogger() {
        return logger;
    }

    public String getZjhm() {
        return zjhm;
    }

    public void setZjhm(String zjhm) {
        this.zjhm = zjhm;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    private File file;

    private String successMassage = "success";

    public File getFile() {
        return file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String getOriginalId() {
        return originalId;
    }

    public void setOriginalId(String originalId) {
        this.originalId = originalId;
    }

    public String getGdr() {
        return gdr;
    }

    public void setGdr(String gdr) {
        this.gdr = gdr;
    }

    public String getDh() {
        return dh;
    }

    public void setDh(String dh) {
        this.dh = dh;
    }


    public String getLinkField(){
        if(linkField==null){
            try{
                linkField=archiveService.getArchiveModel(modelName).getTemplate("linkField");
            }catch (Exception ex){
                linkField="tm";
            }
        }
        return linkField;
    }

    public String getArchiveId() {
        return archiveId;
    }

    public void setArchiveId(String archiveId) {
        this.archiveId = archiveId;
    }

    public Map getShowFields() {
        if (showFields == null) {
            showFields = JSON.parseObject(getEntityTemplate("showFields"), LinkedHashMap.class);
        }
        return showFields == null ? Collections.emptyMap() : showFields;
    }

    /**
     * 获取案卷是否存在卷内
     * @return
     */
    public boolean getIsShowArchiveDoc(){
        try{
            if(modelService.getModel(modelName.concat("_jn")) != null){
                return true;
            }

        }catch (ModelNotFoundException ex){
            return false;
        }
        return false;
    }

    /**
     * 获取字段列表
     *
     * @return 字段列表
     */
    public Map<String, Field> getFields() {
        return getEntityModel().getInheritfieldsMap();
    }

    public void setData(String data) {
        this.data = data;
    }

    public void setMlh(String mlh) {
        this.mlh = mlh;
    }

    public String getTm() {
        return tm;
    }

    public void setTm(String tm) {
        this.tm = URLDecoder.decode(tm);
    }

    /**
     * 默认插入档案
     *
     * @return
     * @throws Exception
     */
    @Override
    public String execute() throws Exception {
        if (StringUtils.isNotBlank(data)) {
            Struts2Utils.renderXml(gatewayService.in(data));
        }
        return null;
    }

    /**
     * 更新档案
     *
     * @return
     */
    public String update() {
        if (StringUtils.isNotBlank(data)) {
            Struts2Utils.renderXml(gatewayService.update(data));
        }
        return null;
    }

    /**
     *
     * @return
     * @throws Exception
     */
    public String preIn() throws Exception{
        if(StringUtils.isNotBlank(data)) {
            Struts2Utils.renderXml(gatewayService.preIn(data));
        }
        return null;
    }

    /**
     *    预处理
     * @return
     */
    public String preDispose(){
        try{
            gatewayService.preDispose(modelName,id,mlh);
            renderJson(successMassage);
        }catch (Exception ex){
            renderJson(ex.toString());
        }
        return null;
    }

    /**
     * 撤销预处理
     * @return
     */
    public String cancelDispose(){
        try{
            gatewayService.cancelDispose(modelName,id);
            renderJson(successMassage);
        }catch (Exception ex){
            logger.error(ex.getMessage());
        }
        return null;
    }


    /**
     * 打印完交接单在档案列表中显示
     * @return
     */
    public String dispose(){
        try{
            renderJson(gatewayService.dispose(modelName,id));
        }catch (Exception ex){
            renderJson(ex.toString());
        }
        return null;
    }

    public String edit() {
        if (id != null && StringUtils.isNotBlank(id)) {
            Archive archive = archiveService.getSimpleArchive(id);
            if (modelName == null || StringUtils.isBlank(modelName)) {
                modelName = archive.getModelName();
            }
        }

        if (proid != null && StringUtils.isNotBlank(proid)) {
            Archive archive = archiveService.getSimpleArchiveByProId(proid);
            if(id == null || StringUtils.isBlank(id)){
                id = archive.getId();
            }

            if (modelName == null || StringUtils.isBlank(modelName)) {
                modelName = archive.getModelName();
            }
        }
        return "edit";
    }

    public String chpedit() {
        if (id != null && StringUtils.isNotBlank(id)) {
            Document document = archiveService.getSimpleDocument(id);
            if (modelName == null || StringUtils.isBlank(modelName)) {
                modelName = document.getModelName();
            }
        }
        return "chpedit";
    }

    public String view() {
        if (id != null && StringUtils.isNotBlank(id)) {
            Archive archive = archiveService.getSimpleArchive(id);
            if (modelName == null || StringUtils.isBlank(modelName)) {
                modelName = archive.getModelName();
            }
        }

        if (proid != null && StringUtils.isBlank(proid)) {
            Archive archive = archiveService.getSimpleArchiveByProId(proid);
            if(id == null || StringUtils.isBlank(id)){
                id = archive.getId();
            }
            if (modelName == null || StringUtils.isBlank(modelName)) {
                modelName = archive.getModelName();
            }
        }
        return "view";
    }

    public String originalInfo() {
        HttpServletRequest request = ServletActionContext.getRequest();
        if (StringUtils.isBlank(modelName) && StringUtils.isNotBlank(id)) {
            modelName = archiveService.getSimpleArchive(id).getModelName();
        }

        if (StringUtils.isBlank(id) && StringUtils.isNotBlank(dh)) {
            Archive archive = archiveService.getArchiveByDh(dh);
            id = archive.getId();
            modelName = StringUtils.isBlank(modelName) ? archive.getModelName() : modelName;
        }
        request.setAttribute("id",this.id);
        request.setAttribute("modelName",this.modelName);
        return "originalInfo";
    }

    public String originalInfoByTm() throws IOException {
        List<Criterion> criterions = new ArrayList<Criterion>();
        List<Order> orders = new ArrayList<Order>();
        Archive archive = null;

        criterions.add(Restrictions.like("tm","%" + tm +"%"));
        List archives = archiveService.searchArchiveList(modelName, criterions,orders,-1,-1);

        if(!archives.isEmpty()){
            archive = (Archive)archives.get(0);
            setId(archive.getId());
        }else {
            setId("");
        }
        return "originalInfo";
    }

    public String inBox() {
        return "inBox";
    }

    public String list(){
        Archive archive=archiveService.getArchive(modelName, id);
        return "list";
    }

    public String out(){
        if(StringUtils.isNotBlank(id)&&StringUtils.isNotBlank(modelName)) {
            Struts2Utils.renderXml(gatewayService.out(id, modelName));
        } else if(StringUtils.isNotBlank(id)) {
            Struts2Utils.renderXml(gatewayService.out(id));
        }
        return null;
    }

    /**
     * 档案信息删除
     * @return
     */
    public String remove() {
        if (StringUtils.isNotBlank(id) && StringUtils.isNotBlank(modelName)) {
            if (gatewayService.remove(id, modelName)) {
                renderJson(successMassage);
            } else {
                renderJson("fail");
            }
        }
        return null;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getModelName() {
        return modelName;
    }

    public String getId() {
        return id;
    }

    public String getSessionId() {
        return ServletActionContext.getRequest().getSession().getId();
    }

    public String getProid() {
        return proid;
    }

    public void setProid(String proid) {
        this.proid = proid;
    }

    public Map getDocShowFields() {
        if(docShowFields==null)
        {
            try{
                Model doc = archiveService.getDocumentModel(modelName+"_jn");
                docShowFields = JSON.parseObject(doc.getTemplate("showFields"), LinkedHashMap.class);
            }catch(ModelNotFoundException ex){
                logger.error(ex.getMessage());
            }catch(TemplateNotFoundException ex){
                docShowFields = JSON.parseObject(getEntityTemplate("Document-showFields"),LinkedHashMap.class);
            }
        }
        return docShowFields;
    }

    public Map getDocFields() {
        if (docFields==null) {
            try {
                Model doc = archiveService.getDocumentModel(modelName);
                docFields = doc.getInheritfieldsMap();
            } catch(ModelNotFoundException ex) {
                logger.error(ex.getMessage());
            }
        }
        return docFields;
    }

    private String getEntityTemplate(String name) {
        return getEntityModel().getTemplate(name);
    }

    private Model getEntityModel() {
        return modelService.getModel(modelName);
    }

    public String getList(){
        Collection<Model> models=getModels();
        Map<String,String> map=new HashMap<String,String>();
        Iterator iterator=models.iterator();
        while (iterator.hasNext()){
            Model model=(Model)iterator.next();
            if(archiveString.equals(model.getParentName())) {
                map.put(model.getTitle(), model.getName());
            }
        }
        return JSON.toJSONString(map);
    }

    public ArrayList<String> getKeys(){
        Collection<Model> models=getModels();
        ArrayList<String> keys=new ArrayList<String>();
        Iterator iterator=models.iterator();
        while (iterator.hasNext()){
            Model model=(Model)iterator.next();
            if(archiveString.equals(model.getParentName())) {
                keys.add(model.getTitle());
            }
        }
        return keys;
    }

    public Collection<Model> getModels() {
        return modelService.getModels();
    }

    /**
     * 返回新档案的信息
     */
    public String getNewArchiveInfo() {
        Map showInfo = new HashMap();
        Archive archive = archiveService.getArchive(modelName,id);
        Set<Field> fields = modelService.getModel(Archive.MODEL_NAME).getFields();
        Set<Field> archiveFields = modelService.getModel(modelName).getFields();
        for (Field field : fields) {
            if (Struts2Utils.hasProperty(archive, field.getName())) {
                for(Field archiveField : archiveFields) {
                    if(!field.getTitle().equals(archiveField.getTitle())) {
                        try {
                            showInfo.put(field.getTitle(), PropertyUtils.getProperty(archive, field.getName()));
                        } catch (Exception e) {
                            logger.error(e.getMessage());
                        }
                    }
                }
            }
        }
        setId(archive.getId());
        return JSONObject.toJSONString(showInfo);
    }

    /**
     * ceb转图片
     */
    public void getCebPic() {
        if (StringUtils.isBlank(archiveId)) {
            logger.error("档案id为空");
        }

        logger.info("archiveId = {}", archiveId);

        if (StringUtils.isBlank(modelName)) {
            logger.error("modelName为空");
        }

        logger.info("modelName = {}", modelName);
        logger.info("file = {}", getFile().getName());
        ZipInputStream zis = null;
        String temp = "D:";
        String parent = temp + File.separator + "cebToJpg";
        file = new File(parent);
        Archive archive = archiveService.getArchive(modelName, archiveId);

        String standardPrefix = archive.getQzh() + "-" + archive.getMlh()
                + "-0000-" + addPrefixZero(4, archive.getAjh());
        logger.info("standardPrefix = {}", standardPrefix);
        ZipEntry entry = null;
        ZipFile zip = null;
        File zipFile = null;
        FileInputStream fileInputStream = null;
        try {
            if (!file.exists()) {
                file.mkdirs();
            }
            String zipPath = parent + File.separator + archive.getId() + ".zip";
            zipFile = new File(zipPath);
            logger.info("=============开始复制文件===========");
            if (!zipFile.exists()) {
                if(!zipFile.createNewFile()){
                    logger.error("getCebPic创建临时文件失败！[{}]" , zipFile.getPath());
                }
            }
            logger.info("=============开始写入文件===========");
            FileCopyUtils.copy(new BufferedInputStream(new FileInputStream(getFile())), new BufferedOutputStream(new FileOutputStream(zipPath)));
            zip = createZip(zipPath);
            if (zipFile.exists()) {
                fileInputStream = new FileInputStream(zipFile);
                zis = createZipInputStream(fileInputStream);
                List<Original> originals = originalService.getOriginals(archiveId);
                logger.info("originals的大小{}", originals.size());
                int pageNum = originals == null ? 1 : originals.size() + 1;
                while ((entry = zis.getNextEntry()) != null && !entry.isDirectory()) {
                    logger.info("获取压缩文件{}中的{}", zip.getName(), entry.getName());
                    File target = new File(parent + File.separator + standardPrefix + "-" + addPrefixZero(4, pageNum) + ".jpg");
                    logger.info("开始复制文件{}", entry.getName());
                    FileCopyUtils.copy(zip.getInputStream(entry), new BufferedOutputStream(new FileOutputStream(target)));
                    pageNum++;
                    logger.info("pageNum = {}", pageNum);
                }
            }

            File[] files = file.listFiles();
            logger.info("文件数量 = {}", files == null ? 0 : files.length);

            int j = 1;
            if (files != null && files.length > 0) {
                for (File jpg : files) {
                    if (jpg.getName().endsWith("jpg")) {
                        logger.info("jpg name = {}", jpg.getName());
                        if (j == 1 && EnvHolder.isEnable(Switch.GENERATE_ARCHIVE_INFO_TABLE)) {
                            String[][] archiveInfo = {{archive.getQzh(), ("WS" + archive.getNd()), archive.getAjh().toString()},
                                    {"", files.length + ""}};
                            logger.info("archiveInfo = {}", Arrays.toString(archiveInfo));
                            String digitalSign = temp + File.separator + "digitalSign.png";
                            logger.info("digitalSign = {}", digitalSign);
                            logger.info("============开始生成文件流===============");
                            fileToPicService.generateTableGraphics(archiveInfo, digitalSign, 16, 168, 27);
                            logger.info("===============开始生成电子签名==================");
                            BufferedImage img = fileToPicService.digitalSign(jpg, new File(digitalSign), 1.0f);
                            logger.info("============开始生成文件===================");
                            fileToPicService.generateSignFile(img, jpg.getPath());
                        }
                        Original original = new Original();
                        original.setOwnerId(archive.getId());
                        original.setName(jpg.getName());
                        originalService.saveOriginalFile(original, jpg, modelName, StringUtils.isBlank(original.getId()));
                        originalService.saveOriginal(original);
                        j++;
                        logger.info("j = {}", j);
                    }
                }
            }

            int ys = archive.getYs() == null ? 0 : archive.getYs();
            archive.setYs(ys + j);
            archiveService.saveArchive(archive);
        }catch (IOException e) {
            logger.error(e.getMessage());
        }finally {
            try {
                if (zis != null) {
                    zis.closeEntry();
                }
                IOUtils.closeQuietly(zis);
                if (zip != null) {
                    zip.close();
                }
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                if (zipFile != null) {
                    if(!zipFile.delete()){
                        logger.error("getCebPic删除临时文件失败！[{}]" , zipFile.getPath());
                    }
                }
                FileUtils.cleanDirectory(file);
            } catch (IOException e) {
                logger.error(e.getMessage());
            }
        }
    }

    public ZipFile createZip(String path){
        ZipFile zip = null;
        try{
            zip = new ZipFile(path);
        }catch (Exception e){
            logger.error(e.getMessage());
        }
        return zip;
    }

    public ZipInputStream createZipInputStream(FileInputStream fileInputStream){
        ZipInputStream zis = null;
        try{
            zis = new ZipInputStream(fileInputStream);
        }catch (Exception e){
            logger.error(e.getMessage());
        }
        return zis;
    }

    /**
     * 数字补齐0
     *
     * @param count 位数
     * @param i     数字
     * @return 补齐后的字符串
     */
    private String addPrefixZero(int count, Integer i) {
        if (i == null || count <= 0) {
            return null;
        }
        return String.format("%0" + count + "d", i);
    }

    /**
     * 连云港电子标签获取档案信息
     */
    public void getArchiveForRFID() {
        JSONObject json = JSON.parseObject(data);
        JSONArray jsonArray = json.getJSONArray("data");
        JSONObject jsonObject = jsonArray.getJSONObject(0);
        String modelName = jsonObject.getString("modelName");
        String mlh = jsonObject.getString("mlh");
        String ajh = jsonObject.getString("ajh");
        String nd = jsonObject.getString("nd");
        renderJson(gatewayService.getArchiveForEdit(modelName,mlh,ajh,nd));
    }

    /**
     * 连云港库房门禁验证借阅归还信息
     */
    public void loanVerification() {
        String mothed = "AddRFIDBorrowDA";
        renderJson(gatewayService.setLoanToRFID(dh , mothed));
    }

    /**
     * 马鞍山触摸屏个人查询
     */
    public String query() {
        LogManager logManager = new LogManager();
        logManager = this.setCatalogType(catalogType, logManager);
        logManager.setOprationTime(new Date());
        List<Archive> archives = null;
        StringBuilder stringBuffer = new StringBuilder();
        if (!org.apache.commons.lang3.StringUtils.isEmpty(tm)) {
            logManager.setUserName(tm);
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty(dh)) {
            if (stringBuffer.length() != 0 && stringBuffer != null) {
                stringBuffer.append(" and dh = '" + dh + "'");
            }else {
                stringBuffer.append("from Archive where dh = '" + dh + "'");
            }
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty(zjhm)) {
            if (stringBuffer.length() != 0 && stringBuffer != null) {
                stringBuffer.append(" and zjhm = '" + zjhm + "'");
            } else {
                stringBuffer.append("from Archive where zjhm = '" + zjhm + "'");
            }
        }

        logger.error(stringBuffer.toString());
        try {
            if (stringBuffer != null) {
                archives = this.archiveService.getArchiveByHQL(stringBuffer.toString());
            }
            logManager.setOwnerType(archives.get(0).getModelName());
        } catch (Exception e) {
            logger.error(e.getMessage());
        }
        logManagerService.saveLogManager(logManager);
        ServletActionContext.getRequest().setAttribute("archives", archives);
        return "query";
    }

    public String findArchiveByCode() {
        LogManager logManager = new LogManager();
        logManager = this.setCatalogType(catalogType, logManager);
        logManager.setOprationTime(new Date());
        try {
            Map<String, Object> map = (Map) reportCache.getReportCache(code);
            Archive archive = (Archive) map.get("archive");
            int time = (Integer) map.get("time");
            List<Archive> archives = new ArrayList<Archive>();
            archives.add(archive);
            Struts2Utils.getRequest().setAttribute("archives", archives);
            Struts2Utils.getRequest().setAttribute("time", time);
        } catch (Exception e) {
            logger.error(e.getMessage());
        }
        logManagerService.saveLogManager(logManager);
        return "query";
    }

    public LogManager setCatalogType(Integer catalogType, LogManager logManager) {
        if (catalogType != null) {
            switch (catalogType) {
                case 0:
                    logManager.setCatalogType("其他");
                    break;
                case 1:
                    logManager.setCatalogType("个人");
                    break;
                case 2:
                    logManager.setCatalogType("单位");
                    break;
                case 3:
                    logManager.setCatalogType("公检法机关");
                    break;
                case 4:
                    logManager.setCatalogType("本系统");
                    break;
                default:
                    logManager.setCatalogType("本系统");
                    break;
            }
        } else {
            logManager.setCatalogType("本系统");
        }
        return logManager;
    }

    /**
     * 马鞍山触摸屏查阅
     */
    public String getArchiveById() {
        if (archiveId != null) {
            Archive archive = this.archiveService.getArchive(archiveString, archiveId);
            ServletActionContext.getRequest().setAttribute("entity", archive);
        }
        return "detail";
    }

    /**
     * 通过档号获取档案信息
     */
    public void getArchiveByDh() {
        String isSuccessful = "isSuccessful";
        String reData = "reData";
        String errMsg = "errMsg";
        java.util.Map rootItem = new HashMap();
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");//设置日期格式
        String newsNo = df.format(new Date());
        if (!Struts2Utils.isNull(dh)) {
            try {
                Archive archive = this.archiveService.getArchiveByDh(dh);
                rootItem.put(isSuccessful, "1");
                rootItem.put(reData, newsNo);
                rootItem.put(errMsg, "1");
                rootItem.put("data",archive);
                renderJson(rootItem);
            }catch (Exception e){
                rootItem.put(isSuccessful, "0");
                rootItem.put(reData, newsNo);
                rootItem.put(errMsg, e.getMessage());
                renderJson(rootItem);
            }
        }else{
            rootItem.put(isSuccessful, "0");
            rootItem.put(reData, newsNo);
            rootItem.put(errMsg, "档号为空！");
            renderJson(rootItem);
        }
    }

    /**
     * 查询页面
     */
    public String search() {
        return "search";
    }
}
