package com.gtis.archive.web;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

import com.gtis.archive.core.support.hibernate.UUIDHexGenerator;
import com.gtis.archive.core.web.BaseEntityAction;
import com.gtis.archive.entity.Archive;
import com.gtis.archive.entity.ArchiveJdHistory;
import com.gtis.archive.entity.Document;
import com.gtis.archive.service.ArchiveJdHistoryService;
import com.gtis.archive.service.ArchiveService;
import com.gtis.archive.service.FondsManagerService;
import com.gtis.archive.service.LogManagerService;
import com.gtis.web.SessionUtil;


/**
 * 描述：档案鉴定打包全宗卷
 * @author 卜祥东
 * 2017年10月9日 下午4:53:26
 */
public class FondsManagerEntityAppraisalAction extends BaseEntityAction<Archive> {

    @Autowired
    private FondsManagerService fondsManagerService;
    @Autowired
    private ArchiveService archiveService;
    @Autowired
    private LogManagerService logManagerService;
    @Autowired
    private ArchiveJdHistoryService archiveJdHistoryService;

    /** 记录是否是更新 */
    private boolean update;
    /** 档案主键id*/
    private String idsArchiveHis;

    @Override
    public void preSave() {
        if (StringUtils.isBlank(entity.getId())) {
            update = false;
        } else {
            update = true;
        }

        if (entity.getBgqx() == null) {
            entity.setBgqx("默认");
        }
    }

    public void doSave(Archive archive,String idsArchiveHis) {
    	archive.setId(UUIDHexGenerator.generate());
    	archiveService.saveArchive(archive);
    	modelName = "Dajd_jn";
		//选中档案打包到全宗卷
        if(StringUtils.isNotBlank(idsArchiveHis)){
        	String[] idsArchiveHisArr = idsArchiveHis.split(",");
        	for (int i = 0; i < idsArchiveHisArr.length; i++) {
        		String archiveHisId = idsArchiveHisArr[i];
        		ArchiveJdHistory archiveH = archiveJdHistoryService.getSimpleArchiveJdHistory(archiveHisId);
        		String archiveId = archiveH.getArchiveId();
        		Archive temp = archiveService.getSimpleArchive(archiveH.getArchiveId());
        		//1.打包到全宗卷
                Document doc = archiveService.newDocument(modelName);
                Document document = archiveService.getMaxSxhDocuments(modelName, archiveId);
                if (document == null) {
                	doc.setSxh(i+1);
                } else {
                	doc.setSxh(document.getSxh() + 1);
                }
                doc.setArchive(archive);
                doc.setMlh(temp.getMlh());
                doc.setArchiveId(archive.getId());
                doc.setAjh(archive.getAjh());
                doc.setTm(temp.getTm());
                doc.setQzh(archive.getQzh());
                doc.setModelName(modelName);
                doc.setYs(i+1);
                archiveService.saveDocument(doc);
        	}
        }
    }

    @Override
    public void afterSave() {
        if (!update) {
            logManagerService.saveArchiveLogManager(SessionUtil.getCurrentUserId(), SessionUtil.getCurrentUser().getUsername(), entity, "add");
        } else {
            logManagerService.saveArchiveLogManager(SessionUtil.getCurrentUserId(), SessionUtil.getCurrentUser().getUsername(), entity, "edit");
        }
    }

    @Override
    public String save() throws Exception {
        return renderJs(new Runner() {
            @Override
            public void run() {
                preSave();
                doSave(entity,idsArchiveHis);
                afterSave();
            }
        }, "保存成功", "保存失败", "onFondsManagerComplete");
    }

	public String getIdsArchiveHis() {
		return idsArchiveHis;
	}

	public void setIdsArchiveHis(String idsArchiveHis) {
		this.idsArchiveHis = idsArchiveHis;
	}


}
