package com.gtis.archive.web;

import com.gtis.archive.Switch;
import com.gtis.archive.core.environment.EnvHolder;
import com.gtis.archive.core.support.hibernate.UUIDHexGenerator;
import com.gtis.archive.core.web.BaseEntityAction;
import com.gtis.archive.entity.AjhRange;
import com.gtis.archive.entity.Archive;

import com.gtis.archive.service.ArchiveService;
import com.gtis.archive.service.FondsManagerService;
import com.gtis.archive.service.LogManagerService;
import com.gtis.archive.service.RecordAjhRangeService;

import com.gtis.plat.service.SysUserService;

import com.gtis.plat.vo.UserInfo;
import com.gtis.web.SessionUtil;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.Authentication;
import org.springframework.security.context.SecurityContext;




/**
 * 全宗卷实体类处理
 * Created by linlong on 2017/6/16.
 */
public class FondsManagerEntityAction extends BaseEntityAction<Archive> {

    @Autowired
    private FondsManagerService fondsManagerService;
    @Autowired
    private ArchiveService archiveService;
    @Autowired
    private LogManagerService logManagerService;
    @Autowired
    private SysUserService userService;
    @Autowired
    private RecordAjhRangeService recordAjhRangeService;

    /** 记录是否是更新 */
    private boolean update;


    private AjhRange ajhRange;

    public AjhRange getAjhRange() {
        return ajhRange;
    }

    public void setAjhRange(AjhRange ajhRange) {
        this.ajhRange = ajhRange;
    }

    public Archive saveOrUpdateFondManager(Archive fondsManager) {
        if (StringUtils.isBlank(fondsManager.getId())) {
            fondsManager.setId(UUIDHexGenerator.generate());
            fondsManagerService.saveFondsManager(fondsManager);
            return fondsManager;
        } else {
            fondsManagerService.updateFondsManager(fondsManager);
            return fondsManager;
        }
    }

    @Override
    public void preSave() {
        if (StringUtils.isBlank(entity.getId())) {
            update = false;
        } else {
            update = true;
        }

        if (entity.getBgqx() == null) {
            entity.setBgqx("默认");
        }
    }

    @Override
    public void doSave(Archive archive) {
        archiveService.saveArchive(archive);
    }

    @Override
    public void afterSave() {
        if (!update) {
            logManagerService.saveArchiveLogManager(SessionUtil.getCurrentUserId(), SessionUtil.getCurrentUser().getUsername(), entity, "add");
        } else {
            logManagerService.saveArchiveLogManager(SessionUtil.getCurrentUserId(), SessionUtil.getCurrentUser().getUsername(), entity, "edit");
        }
    }

    @Override
    public String save() throws Exception {
        return renderJs(new Runner() {
            @Override
            public void run() {
                preSave();
                doSave(entity);
                afterSave();
            }
        }, "保存成功", "保存失败", "onFondsManagerComplete");
    }

    /**
     * 获取可用的案卷号
     *
     * @return
     */
    private AjhRange getAvailableAjhRange() {
        if (entity.getMlh() != null) {
            return ajhRangeService.getAvailableAjhRange(modelName, entity.getMlh());
        } else if(EnvHolder.isEnable(Switch.INDIVIDUAL_MLH)){
            UserInfo userInfo = new UserInfo();
            SecurityContext context = (SecurityContext)session.get("SPRING_SECURITY_CONTEXT");
            if (context != null) {
                Authentication authentication = context.getAuthentication();
                userInfo =(UserInfo) authentication.getPrincipal();
            }
            if(userInfo !=null) {
                String dwdm = userInfo.getRegionCode();
                return ajhRangeService.getAvailableAjhRangeByDwdm(modelName, dwdm);
            }else {
                return ajhRangeService.getAvailableAjhRange(modelName);
            }
        }else {
            return ajhRangeService.getAvailableAjhRange(modelName);
        }
    }
}
