package com.gtis.archive.web;

import java.io.IOException;
import java.util.*;

import com.gtis.archive.Switch;
import com.gtis.archive.core.environment.EnvHolder;
import com.gtis.archive.entity.Resource;
import com.gtis.archive.service.*;
import com.gtis.plat.vo.UserInfo;
import com.gtis.web.SessionUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import com.alibaba.fastjson.JSON;
import com.gtis.archive.core.EntityService;
import com.gtis.archive.core.Field;
import com.gtis.archive.core.Model;
import com.gtis.archive.core.dict.DictService;
import com.gtis.archive.core.dict.Item;
import com.gtis.archive.core.ex.ModelNotFoundException;
import com.gtis.archive.core.ex.TemplateNotFoundException;
import com.gtis.archive.core.support.hibernate.UUIDHexGenerator;
import com.gtis.archive.core.web.BaseModelAction;
import com.gtis.archive.entity.Archive;
import com.gtis.archive.util.SearchUtils;
import com.gtis.archive.util.Struts2Utils;
import com.gtis.common.Page;

/**
 * 全宗卷
 * Created by linlong on 2017/6/15.
 */
public class FondsManagerAction extends BaseModelAction<Archive> {

    @Autowired
    private FondsManagerService fondsManagerService;
    @Autowired
    private ArchiveService archiveService;
    @Autowired
    private DictService dictService;
    @Autowired
    private EntityService entityService;
    @Autowired
    private SecurityService securityService;
    @Autowired
    private PermissionService permissionService;
    @Autowired
    private ResourceService resourceService;

    /** 字典配置的fondsManager */
    private List<Item> models;

    /** 全宗卷的id */
    private String fdId;

    /** 字段modelName的值 */
    private String fieldModelName;

    /** 档案中卷内显示的字段 */
    private Map docShowFields;

    /** 卷内的超链接字段 */
    private String docLinkField;

    /** 案卷的字段 */
    private Map docFields;

    /**
     * tree id
     */
    private String treeId;

    /**
     * 所有的操作项
     */
    private List<String> operationStrs;

    private String fondsManagerText = "fondsManager";

    public String getFieldModelName() {
        return fieldModelName;
    }

    public void setFieldModelName(String fieldModelName) {
        this.fieldModelName = fieldModelName;
    }

    public List<Item> getModels() {
        models = dictService.getItems(fondsManagerText);
        return models;
    }

    public void setModels(List<Item> models) {
        this.models = models;
    }

    /**
     * 获得档案中案卷显示的字段
     *
     * @return
     */
    public Map getDocShowFields() {
        if (docShowFields == null) {
            try {
                Model doc = archiveService.getDocumentModel(modelName);
                docShowFields = JSON.parseObject(doc.getTemplate("showFields"), LinkedHashMap.class);
            } catch (ModelNotFoundException ex) {
                logger.error(ex.getMessage());
            } catch (TemplateNotFoundException ex) {
                docShowFields = JSON.parseObject(getEntityTemplate("Document-showFields"), LinkedHashMap.class);
            }
        }
        return docShowFields;
    }

    /**
     * 获取档案中案卷所有字段
     *
     * @return
     */
    public Map getDocFields() {
        if (docFields == null) {
            try {
                Model doc = archiveService.getDocumentModel(modelName);
                docFields = doc.getInheritfieldsMap();
            } catch (ModelNotFoundException ex) {
                logger.error(ex.getMessage());
            }
        }
        return docFields;
    }

    public String getTreeId() {
        return treeId;
    }

    public void setTreeId(String treeId) {
        this.treeId = treeId;
    }

    public String getDocLinkField() {
        if (docLinkField == null) {
            try {
                docLinkField = archiveService.getDocumentModel(modelName).getTemplate("linkField");
            } catch (ModelNotFoundException ex) {
                logger.error(ex.getMessage());
            } catch (TemplateNotFoundException ex) {
                docLinkField = "tm";
            }
        }
        return docLinkField;
    }

    @Override
    public String execute() {
        if (StringUtils.isNotEmpty(modelName)) {
            Resource res = resourceService.getResourceByName(modelName);
            if (res != null) {
                treeId = res.getId();
            } else {
                throw new ModelNotFoundException(modelName);
            }
        }
        return SUCCESS;
    }

    public String getPermJson() {
        Map<String, Boolean> perm = new HashMap<String, Boolean>();
        UserInfo userInfo = SessionUtil.getCurrentUser();
        String location = ServletActionContext.getRequest().getSession().getServletContext().getRealPath("/tpls/permission.json");
        try {
            operationStrs = permissionService.getLeavesId(location); // 获取所有的操作项
        } catch (IOException e) {
            logger.error("读取配置文件permission.json错误，请检查，文件位置为" + location,e);
        }
        if(!EnvHolder.isEnable(Switch.isNewPermission) || userInfo.isAdmin()) {
            for (String s : operationStrs) {
                if (securityService.isPermitted(treeId, s)) {
                    perm.put(s, true);
                }
            }
        }else {
            perm = securityService.getUserPermMap(userInfo,treeId);
        }
        return JSON.toJSONString(perm);
    }

    @Override
    public String cacheIds() {
        String key = UUIDHexGenerator.generate();
        if (ids.length == 1 && ids[0].contains(",")) {
            ids = ids[0].split(",");
        }
        idsCaches.put(key, ids);
        return renderJson(Collections.singletonMap("idsKey", key));
    }

    /**
     * 从字典获取第一个字典项
     */
    public void getFirstModelName() {
        String modelName = dictService.getItems(fondsManagerText).get(0).getName();
        renderJson(modelName);
    }

    /**
     * 编辑或者保存
     * @return
     */
    public String editFondsManager() {
        if (StringUtils.isNotBlank(fdId)) {
            Archive fondsManager = fondsManagerService.getFondsManager(fdId);
            if (fondsManager != null) {
                ServletActionContext.getRequest().setAttribute(fondsManagerText, fondsManager);
            }
        }
        return "edit";
    }

    @Override
    public void list() {
        try {
            renderJson(getEntityPage());
        } catch (Exception e) {
            renderJson(new Page());
        }
    }

    /**
     * 根据条件查找返回结果给前台
     * @param criterions
     * @param orders
     * @return
     */
    @Override
    protected Page<Archive> searchEntity(List<Criterion> criterions, List<Order> orders) {
        Page<Archive> page = fondsManagerService.searchFondsManager(fieldModelName, criterions, orders, start, limit);
        for (Archive fondsManager : page.getItems()) {
            fondsManager.setHasOriginal(originalService.hasOriginal(fondsManager.getId()));
        }
        return page;
    }

    /**
     * 设置查询条件
     * @param criterions
     * @return
     */
    @Override
    protected List<Criterion> createCriterions(ArrayList<Criterion> criterions) {
        Criterion cr = null;
        Model model = modelService.getModel(fieldModelName);
        Set<Field> fieldSet = model.getFields();
        //追加继承字段
        Set<Field> fieldSetParent = model.getParent().getFields();
        for (Field fParent : fieldSetParent) {
        	fieldSet.add(fParent);
        }
        if (StringUtils.isNotBlank(condition)) {
            criterions.addAll(SearchUtils.conditionToCriterion(getFields(), condition));
        }

        if (StringUtils.isNotBlank(query)) {
            query = query.trim();
            String[] fields = getQueryFields();
            for (String fieldName : fields) {
                for (Field f : fieldSet) {
                    if (f.getName().equals(fieldName)) {
                        if (f.getType() == Field.Type.DATE) {
                            Criterion c = Restrictions.sqlRestriction("to_char(" + fieldName +", 'yyyy-MM-dd') like '%" + query + "%'");
                            cr = cr == null ? c : Restrictions.or(c, cr);
                        } else if (f.getType() == Field.Type.NUMBER) {
                            Criterion c = Restrictions.sqlRestriction("to_char(" + fieldName +") like '%" + query + "%'");
                            cr = cr == null ? c : Restrictions.or(c, cr);
                        } else {
                            Criterion c = Restrictions.like(fieldName, query, MatchMode.ANYWHERE);
                            cr = cr == null ? c : Restrictions.or(c, cr);
                        }
                    }
                }
            }
        }
        cr = cr == null ? Restrictions.eq("modelName", fieldModelName) : Restrictions.and(cr, Restrictions.eq("modelName", fieldModelName));
        criterions.add(cr);
        return criterions;
    }


    /**
     * 获取或者新建一个全宗卷对象
     */
    public void getOrCreateFondsManager() {
        Archive fondsManager;
        if (StringUtils.isNotBlank(idsKey)) {
            fondsManager = fondsManagerService.getFondsManager(idsKey);
        } else {
            try {
                fondsManager = entityService.newInstance(modelService.getClass(fieldModelName));
                fondsManager.setAjh(fondsManagerService.generateSxh(fieldModelName));
                fondsManager.setModelName(fieldModelName);
            } catch (ClassNotFoundException e) {
                logger.error(e.getMessage());
                throw new RuntimeException("业务未找到，请检查配置");
            }
        }
        renderJson(fondsManager);
    }

    /**
     * 删除全宗卷
     */
    public String deleteFondsManager() {
        try {
            if (StringUtils.isNotBlank(idsKey)) {
                String[] ids = idsKey.split(",");
                fondsManagerService.removeFondsManager(ids, fieldModelName);
                Struts2Utils.renderJson("success");
            }
        } catch (Exception e) {
            Struts2Utils.renderJson("failure");
        }
        return null;
    }

}
