package com.gtis.archive.web;

import com.gtis.archive.core.web.BaseEntityAction;
import com.gtis.archive.entity.Archive;
import com.gtis.archive.entity.Document;
import com.gtis.archive.service.ArchiveService;
import com.gtis.archive.service.LogManagerService;
import com.gtis.web.SessionUtil;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2010-10-13
 */
public class DocEntityAction extends BaseEntityAction<Document> {
    @Autowired
    private ArchiveService archiveService;
    @Autowired
    private LogManagerService logManagerService;

    /**
     * 档案id
     */
    private String archiveId;

    /**
     * 泗洪参照档案的id
     */
    private String preid="";

    /**
     * 案卷modelName
     */
    private String ajModelName;

    public String getPreid() {
        return preid;
    }

    public void setPreid(String preid) {
        this.preid = preid;
    }

    public String getAjModelName() {
        return ajModelName;
    }

    public void setAjModelName(String ajModelName) {
        this.ajModelName = ajModelName;
    }

    @Override
    public void prepare() {
        if (StringUtils.isBlank(id)) {
            if ("".equals(preid)) {
                entity = archiveService.newDocument(modelName);
                Document lastDocument = null;
                    lastDocument = archiveService.getMaxSxhDocuments(modelName,archiveId);
                if (lastDocument != null) {
                    try {
                        PropertyUtils.copyProperties(entity, lastDocument);
                        entity.setSxh(entity.getSxh() + 1);
                    } catch (Exception ignored) {
                        logger.error(ignored.getMessage());
                    }
                    entity.setId(null);
                }
            }
            else {
                List<Document> documentList;
                documentList=archiveService.getArchiveDocuments(ajModelName,preid);
                entity = archiveService.newDocument(modelName);
                    try {
                        List<Document> documents;
                        documents = archiveService.getArchiveDocuments(ajModelName,archiveId);
                        if(!documents.isEmpty()){
                            List<Integer> list = new ArrayList<Integer>();
                            for(Document document : documents) {
                                list.add(document.getSxh());
                            }
                            Collections.sort(list);
                            int i = list.get(list.size()-1);
                            for (Document document : documentList) {
                                if (document.getSxh() == i+1) {
                                    PropertyUtils.copyProperties(entity, document);
                                }
                            }
                        }
                        else {
                            for (Document document : documentList) {
                                if (document.getSxh() == 1) {
                                    PropertyUtils.copyProperties(entity, document);
                                }
                            }
                        }
                    } catch (Exception ignored) {
                        logger.error(ignored.getMessage());
                    }
                    entity.setId(null);

            }
        } else {
            entity = archiveService.getDocument(modelName, id);
            if (archiveId == null) {
                archiveId = entity.getArchiveId();
            }
        }
        if (entity != null && archiveId != null) {
            try{
                Archive archive = archiveService.getArchive(modelName,archiveId);
                if (entity.getSxh() == null) {
                    entity.setSxh(1);
                }
                entity.setArchive(archive);
                entity.setQzh(archive.getQzh());
                entity.setMlh(archive.getMlh());
                entity.setAjh(archive.getAjh());
                entity.setDabh(archive.getDh());
            } catch (Exception ex) {
                logger.debug(ex.toString());
            }
        }
    }

    @Override
    protected void doSave(Document entity) {
        try {
            archiveService.saveDocument(entity);
            if (StringUtils.isBlank(id)) {
                logManagerService.saveDocumentLogManage(SessionUtil.getCurrentUserId(), SessionUtil.getCurrentUser().getUsername(),
                        entity, "add");
            } else {
                logManagerService.saveDocumentLogManage(SessionUtil.getCurrentUserId(), SessionUtil.getCurrentUser().getUsername(),
                        entity, "edit");
            }
        } catch (Exception e) {
            logger.error("保存卷内失败,{}", e.getMessage());
            logger.error("保存卷内失败");
        }

    }

    @Override
    protected String getJsCallBack() {
        return "onDocumentComplete";
    }

    @Override
    protected void afterSave() {
        session.put("currentDId", entity.getId());
    }

    public void setArchiveId(String archiveId) {
        this.archiveId = archiveId;
    }

}
